/*
 * Decompiled with CFR 0.152.
 */
package com.spedoske.commands.init;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class LangInitializer {
    private static HashMap<String, HashMap<String, String>> LangMap = new HashMap();
    private static List<String> LangTypes = new ArrayList<String>();
    private static boolean loaded = false;

    LangInitializer() {
        if (!loaded) {
            try {
                char tmp;
                InputStream in = this.getClass().getResourceAsStream("/assets/spedoske/lang/lang.info");
                InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
                char[] data = new char[in.available()];
                for (int i = 0; i < data.length && (tmp = (char)isr.read()) != '\uffff'; ++i) {
                    data[i] = tmp;
                }
                in.close();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < data.length && data[i] != '\u0000'; ++i) {
                    if (data[i] == '\r') continue;
                    if (data[i] == '\n') {
                        LangTypes.add(sb.toString());
                        sb.delete(0, sb.length());
                        continue;
                    }
                    sb.append(data[i]);
                }
                if (sb.length() != 0) {
                    LangTypes.add(sb.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String type : LangTypes) {
                HashMap<String, String> LangMapNode = null;
                try {
                    char tmp;
                    InputStream in = this.getClass().getResourceAsStream("/assets/spedoske/lang/" + type + ".lang");
                    InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
                    char[] data = new char[in.available()];
                    for (int i = 0; i < data.length && (tmp = (char)isr.read()) != '\uffff'; ++i) {
                        data[i] = tmp;
                    }
                    in.close();
                    LangMapNode = new HashMap<String, String>();
                    StringBuilder tmpKey = new StringBuilder();
                    StringBuilder tmpValue = new StringBuilder();
                    boolean toggleKeyValue = false;
                    for (int i = 0; i < data.length && data[i] != '\u0000'; ++i) {
                        if (data[i] == '\n') {
                            toggleKeyValue = false;
                            LangMapNode.put(tmpKey.toString(), tmpValue.toString());
                            tmpKey.delete(0, tmpKey.length());
                            tmpValue.delete(0, tmpValue.length());
                            continue;
                        }
                        if (data[i] == '#') {
                            while (i < data.length && data[i] != '\n') {
                                ++i;
                            }
                            --i;
                            continue;
                        }
                        if (data[i] == '=') {
                            toggleKeyValue = true;
                            continue;
                        }
                        if (data[i] == '\r') continue;
                        if (toggleKeyValue) {
                            tmpValue.append(data[i]);
                            continue;
                        }
                        tmpKey.append(data[i]);
                    }
                    if (tmpKey.length() != 0 && tmpValue.length() != 0) {
                        LangMapNode.put(tmpKey.toString(), tmpValue.toString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (LangMapNode == null) continue;
                LangMap.put(type, LangMapNode);
            }
        }
        loaded = true;
    }

    private static String getLangType(EntityPlayerMP player) {
        String langType;
        try {
            Field playerLangField = EntityPlayerMP.class.getDeclaredField("field_71148_cg");
            playerLangField.setAccessible(true);
            langType = (String)playerLangField.get(player);
        }
        catch (Exception e) {
            langType = "en_us";
            e.printStackTrace();
        }
        return langType;
    }

    private static String translate(String langType, String formatString, Object ... prams) {
        String localizedString;
        HashMap<String, String> LangMapNode = LangMap.get(langType);
        if (LangMapNode == null) {
            LangMapNode = LangMap.get("en_us");
        }
        if ((localizedString = LangMapNode.get(formatString)) == null) {
            return formatString;
        }
        return String.format(localizedString, prams);
    }

    public static String translate(EntityPlayerMP player, String formatString, Object ... prams) {
        return LangInitializer.translate(LangInitializer.getLangType(player), formatString, prams);
    }

    public static String translate(ICommandSender sender, String formatString, Object ... prams) {
        return LangInitializer.translate((EntityPlayerMP)sender, formatString, prams);
    }
}

