/*
 * Decompiled with CFR 0.152.
 */
package legendera.world;

import legendera.LEConfig;
import legendera.world.abyss.BiomeAbyss;
import legendera.world.chaos.BiomeChaos;
import legendera.world.devildom.WorldProviderDevildom;
import legendera.world.devildom.biome.BiomeDevildomForest;
import legendera.world.devildom.biome.BiomeDevildomHill;
import legendera.world.devildom.biome.BiomeDevildomPlain;
import legendera.world.devildom.biome.BiomeDevildomSwamp;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LEWorld {
    public static Biome devildom_plain = new BiomeDevildomPlain();
    public static Biome devildom_forest = new BiomeDevildomForest();
    public static Biome devildom_swamp = new BiomeDevildomSwamp();
    public static Biome devildom_hill = new BiomeDevildomHill();
    public static Biome abyss = new BiomeAbyss();
    public static Biome chaos = new BiomeChaos();
    public static int dimension_id_devildom = LEConfig.dimension_id_devildom;
    public static int dimension_id_chaos = LEConfig.dimension_id_chaos;
    public static DimensionType devildom;
    public static DimensionType chaos_dimension;

    public LEWorld() {
        LEWorld.registerBiome(devildom_plain, "devildom_plain", 0, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        LEWorld.registerBiome(devildom_forest, "devildom_forest", 0, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        LEWorld.registerBiome(devildom_swamp, "devildom_swamp", 0, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SWAMP);
        LEWorld.registerBiome(devildom_hill, "devildom_hill", 0, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HILLS);
        LEWorld.registerBiome(abyss, "abyss", 0, true, BiomeManager.BiomeType.COOL, null);
        LEWorld.registerBiome(chaos, "chaos", 0, true, BiomeManager.BiomeType.COOL, null);
        devildom = DimensionType.register((String)"Devildom", (String)"devildom", (int)dimension_id_devildom, WorldProviderDevildom.class, (boolean)false);
        DimensionManager.registerDimension((int)dimension_id_devildom, (DimensionType)devildom);
    }

    private static void registerBiome(Biome biome, String name, int weight, boolean canSpawnIn, BiomeManager.BiomeType type, BiomeDictionary.Type ... types) {
        biome.setRegistryName(new ResourceLocation("legendera", name));
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        if (types != null) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        }
        if (canSpawnIn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
    }
}

