/*
 * Decompiled with CFR 0.152.
 */
package llibrary;

import java.io.File;
import llibrary.server.ServerProxy;
import llibrary.server.capability.IEntityDataCapability;
import llibrary.server.config.ConfigHandler;
import llibrary.server.config.LLibraryConfig;
import llibrary.server.network.AnimationMessage;
import llibrary.server.network.BlockEntityMessage;
import llibrary.server.network.NetworkHandler;
import llibrary.server.network.NetworkWrapper;
import llibrary.server.network.PropertiesMessage;
import llibrary.server.network.SnackbarMessage;
import llibrary.server.network.SurvivalTabMessage;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lelib", name="LELib", acceptedMinecraftVersions="[1.12.2]")
public class LLibrary {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"LELib");
    @SidedProxy(serverSide="llibrary.server.ServerProxy", clientSide="llibrary.client.ClientProxy")
    public static ServerProxy PROXY;
    @Mod.Instance(value="lelib")
    public static LLibrary INSTANCE;
    @CapabilityInject(value=IEntityDataCapability.class)
    public static Capability<IEntityDataCapability> ENTITY_DATA_CAPABILITY;
    public static LLibraryConfig CONFIG;
    @NetworkWrapper(value={AnimationMessage.class, PropertiesMessage.class, SnackbarMessage.class, BlockEntityMessage.class, SurvivalTabMessage.class})
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    public static int QUBBLE_VERSION;
    public static int QUBBLE_VANILLA_VERSION;
    public static final File LLIBRARY_ROOT;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        if (!LLIBRARY_ROOT.exists()) {
            LLIBRARY_ROOT.mkdirs();
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            ConfigHandler.INSTANCE.injectConfig(mod, event.getAsmData());
            NetworkHandler.INSTANCE.injectNetworkWrapper(mod, event.getAsmData());
        }
        CONFIG.load();
        PROXY.onPreInit();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        PROXY.onInit();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        PROXY.onPostInit();
    }

    static {
        CONFIG = new LLibraryConfig();
        QUBBLE_VERSION = 1;
        QUBBLE_VANILLA_VERSION = 1;
        LLIBRARY_ROOT = new File(".", "lelib");
    }
}

