/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.gui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import llibrary.LLibrary;
import llibrary.client.gui.ElementGUI;
import llibrary.client.gui.config.ConfigCategory;
import llibrary.client.gui.config.ConfigProperty;
import llibrary.client.gui.config.property.ForgeConfigProperty;
import llibrary.client.gui.element.ButtonElement;
import llibrary.client.gui.element.Element;
import llibrary.client.gui.element.LabelElement;
import llibrary.client.gui.element.ListElement;
import llibrary.client.gui.element.color.ColorScheme;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConfigGUI
extends ElementGUI {
    public static final ColorScheme RETURN = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getSecondaryColor());
    public static final ColorScheme SIDEBAR = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getTertiaryColor());
    public static final ResourceLocation SETTINGS_ICON = new ResourceLocation("llibrary", "textures/gui/settings.png");
    protected GuiScreen parent;
    protected String parentName;
    protected List<ConfigCategory> categories = new ArrayList<ConfigCategory>();
    protected Map<ConfigProperty, Element<ConfigGUI>> propertyElements = new HashMap<ConfigProperty, Element<ConfigGUI>>();
    protected ConfigCategory selectedCategory;
    private Mod mod;

    public ConfigGUI(GuiScreen parent, Object mod, Configuration config) {
        this(parent, mod, config, "Mod List");
    }

    public ConfigGUI(GuiScreen parent, Object mod, Configuration config, String parentName) {
        this.parent = parent;
        this.parentName = parentName;
        if (!mod.getClass().isAnnotationPresent(Mod.class)) {
            throw new RuntimeException("@Mod annotation not found in class " + mod + "!");
        }
        this.mod = mod.getClass().getAnnotation(Mod.class);
        if (config != null) {
            this.categories.addAll(config.getCategoryNames().stream().map(arg_0 -> ((Configuration)config).getCategory(arg_0)).filter(category -> category.size() > 0).map(category -> {
                ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>();
                for (Property property : category.values()) {
                    ForgeConfigProperty configProperty = ForgeConfigProperty.factory(property);
                    if (configProperty == null) continue;
                    configProperties.add(configProperty);
                }
                return new ConfigCategory(category.getQualifiedName(), configProperties);
            }).collect(Collectors.toList()));
        }
    }

    @Override
    public void initElements() {
        this.addElement(new ButtonElement<ConfigGUI>(this, "<", 0.0f, 0.0f, 30, 20, button -> {
            this.field_146297_k.func_147108_a(this.parent);
            return true;
        }).withColorScheme(this.getReturnButtonColorScheme()));
        this.addElement(new LabelElement<ConfigGUI>(this, this.parentName, 35.0f, 6.0f));
        this.addElement(new LabelElement<ConfigGUI>(this, this.mod.name().toUpperCase() + " SETTINGS", 35.0f, 26.0f));
        ListElement categoryList = (ListElement)new ListElement<ConfigGUI>(this, 0.0f, 40.0f, 120, this.field_146295_m - 40, this.categories.stream().map(ConfigCategory::getName).collect(Collectors.toList()), 20, list -> {
            this.selectedCategory = this.categories.get(list.getSelectedIndex());
            this.propertyElements.values().forEach(this::removeElement);
            this.propertyElements.clear();
            return true;
        }).withPersistence(true).withColorScheme(this.getSidebarColorScheme());
        categoryList.setSelectedIndex(0);
        this.selectedCategory = this.categories.get(0);
        this.addElement(categoryList);
        this.propertyElements.clear();
    }

    @Override
    public void drawScreen(float mouseX, float mouseY, float partialTicks) {
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)40, (int)this.getTopBackgroundColor());
        Gui.func_73734_a((int)120, (int)40, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.getContentBackgroundColor());
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int color = this.getAccentColor();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179152_a((float)0.15f, (float)0.15f, (float)0.15f);
        this.field_146297_k.func_110434_K().func_110577_a(SETTINGS_ICON);
        this.func_73729_b(40, 135, 0, 0, 128, 128);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        int x = 125;
        int y = 45;
        for (ConfigProperty property : this.selectedCategory.getProperties()) {
            Element<ConfigGUI> propertyElement;
            this.field_146289_q.func_78276_b(property.name, x, y, this.getTextColor());
            y += 10;
            if (property.description != null && property.description.length() > 0) {
                this.field_146289_q.func_78276_b(property.description, x, y, this.getTextColor());
                y += 10;
            }
            if ((propertyElement = this.propertyElements.get(property)) == null && (propertyElement = property.provideElement(this, x, y)) != null) {
                this.decoratePropertyElement(propertyElement);
                this.propertyElements.put(property, propertyElement);
                this.addElement(propertyElement);
            }
            if (propertyElement == null) continue;
            y += propertyElement.getHeight() + 4;
        }
    }

    @Override
    public void func_146281_b() {
        MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent(this.mod.modid(), null, this.field_146297_k.field_71441_e != null, false));
        super.func_146281_b();
    }

    public ColorScheme getReturnButtonColorScheme() {
        return RETURN;
    }

    public ColorScheme getSidebarColorScheme() {
        return SIDEBAR;
    }

    public int getTopBackgroundColor() {
        return LLibrary.CONFIG.getPrimaryColor();
    }

    public int getContentBackgroundColor() {
        return LLibrary.CONFIG.getColorMode().equals("dark") ? -15132391 : -1;
    }

    public int getAccentColor() {
        return LLibrary.CONFIG.getAccentColor();
    }

    public int getTextColor() {
        return LLibrary.CONFIG.getTextColor();
    }

    public void decoratePropertyElement(Element<ConfigGUI> element) {
    }

    public GuiScreen getParent() {
        return this.parent;
    }
}

