/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.gui.element;

import java.util.function.Function;
import llibrary.LLibrary;
import llibrary.client.gui.element.Element;
import llibrary.client.gui.element.IElementGUI;
import llibrary.client.gui.element.color.ColorScheme;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ButtonElement<T extends IElementGUI>
extends Element<T> {
    public static final ColorScheme CLOSE = ColorScheme.create(() -> LLibrary.CONFIG.getDarkAccentColor(), () -> -2078905);
    protected String text;
    protected Function<ButtonElement<T>, Boolean> function;

    public ButtonElement(T gui, String text, float posX, float posY, int width, int height, Function<ButtonElement<T>, Boolean> function) {
        super(gui, posX, posY, width, height);
        this.text = text;
        this.function = function;
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), this.isEnabled() && this.isSelected(mouseX, mouseY) ? this.getColorScheme().getSecondaryColor() : this.getColorScheme().getPrimaryColor());
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        fontRenderer.func_175065_a(this.text, this.getPosX() + (float)(this.getWidth() / 2) - (float)(fontRenderer.func_78256_a(this.text) / 2), this.getPosY() + (float)(this.getHeight() / 2) - (float)(fontRenderer.field_78288_b / 2), LLibrary.CONFIG.getTextColor(), false);
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            if (this.function.apply(this).booleanValue()) {
                this.gui.playClickSound();
            }
            return true;
        }
        return false;
    }
}

