/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.gui.element;

import llibrary.LLibrary;
import llibrary.client.gui.element.Element;
import llibrary.client.gui.element.IElementGUI;
import llibrary.server.property.IStringSelectionProperty;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DropdownButtonElement<T extends IElementGUI>
extends Element<T> {
    private IStringSelectionProperty selected;
    private boolean dropped;
    private int dropdownWidth;

    public DropdownButtonElement(T gui, float posX, float posY, int width, int height, IStringSelectionProperty selected) {
        super(gui, posX, posY, width, height);
        this.selected = selected;
        for (String value : this.selected.getValidStringValues()) {
            int entryWidth = gui.getFontRenderer().func_78256_a(value) + 5;
            if (entryWidth <= this.dropdownWidth) continue;
            this.dropdownWidth = entryWidth;
        }
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), this.isEnabled() && (this.isSelected(mouseX, mouseY) || this.dropped) ? this.getColorScheme().getPrimaryColor() : this.getColorScheme().getSecondaryColor());
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        String text = this.selected.getString();
        fontRenderer.func_175065_a(text, this.getPosX() + (float)(this.getWidth() / 2) - (float)(fontRenderer.func_78256_a(text) / 2), this.getPosY() + (float)(this.getHeight() / 2) - (float)(fontRenderer.field_78288_b / 2), LLibrary.CONFIG.getTextColor(), false);
        if (this.dropped) {
            this.drawRectangle(this.getPosX(), this.getPosY() + (float)this.getHeight(), this.dropdownWidth, this.selected.getValidStringValues().size() * 12, this.getColorScheme().getSecondaryColor());
            float y = this.getPosY() + (float)this.getHeight() + 2.0f;
            for (String entry : this.selected.getValidStringValues()) {
                if (this.isEntrySelected(mouseX, mouseY, y)) {
                    this.drawRectangle(this.getPosX(), y - 2.0f, this.dropdownWidth, 12.0, this.getColorScheme().getPrimaryColor());
                }
                fontRenderer.func_175065_a(entry, this.getPosX() + 3.0f, y, LLibrary.CONFIG.getTextColor(), false);
                y += 12.0f;
            }
        }
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.dropped = !this.dropped;
            this.gui.playClickSound();
            return true;
        }
        boolean clicked = false;
        if (this.dropped) {
            float y = this.getPosY() + (float)this.getHeight() + 2.0f;
            for (String value : this.selected.getValidStringValues()) {
                if (this.isEntrySelected(mouseX, mouseY, y) && this.selected.trySetString(value)) {
                    this.gui.playClickSound();
                    clicked = true;
                    break;
                }
                y += 12.0f;
            }
        }
        this.dropped = false;
        return clicked;
    }

    public String getSelected() {
        return this.selected.getString();
    }

    private boolean isEntrySelected(float mouseX, float mouseY, float y) {
        float x = this.getPosX() + 3.0f;
        return mouseX >= x && mouseX <= x + (float)this.dropdownWidth && mouseY >= y && mouseY <= y + 12.0f;
    }
}

