/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.gui.element;

import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import llibrary.LLibrary;
import llibrary.client.ClientProxy;
import llibrary.client.gui.element.IElementGUI;
import llibrary.client.gui.element.ScrollbarElement;
import llibrary.client.gui.element.color.ColorScheme;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Element<T extends IElementGUI> {
    public static final ColorScheme DEFAULT = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getSecondaryColor());
    protected final T gui;
    private Element<T> parent;
    private List<Element<T>> children = new ArrayList<Element<T>>();
    private ColorScheme colorScheme = DEFAULT;
    private float posX;
    private float posY;
    private int width;
    private int height;
    private boolean enabled = true;
    private boolean visible = true;

    public Element(T gui, float posX, float posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public void init() {
    }

    public void update() {
    }

    public void render(float mouseX, float mouseY, float partialTicks) {
    }

    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseDragged(float mouseX, float mouseY, int button, long timeSinceClick) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean mouseReleased(float mouseX, float mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean keyPressed(char character, int key) {
        return false;
    }

    public boolean mouseScrolled(float mouseX, float mouseY, int amount) {
        if (this.isSelected(mouseX, mouseY)) {
            for (Element<T> child : this.getChildren()) {
                if (!(child instanceof ScrollbarElement)) continue;
                ((ScrollbarElement)child).setScrollVelocity(((ScrollbarElement)child).getScrollVelocity() + (float)amount / 120.0f * 0.5f);
                return true;
            }
        }
        return false;
    }

    protected boolean isSelected(float mouseX, float mouseY) {
        return this.gui.isElementOnTop(this) && mouseX >= this.getPosX() && mouseY >= this.getPosY() && mouseX < this.getPosX() + (float)this.getWidth() && mouseY < this.getPosY() + (float)this.getHeight();
    }

    protected boolean isSelected(RectangularShape rectangle, float mouseX, float mouseY) {
        return (double)mouseX >= rectangle.getMinX() && (double)mouseY >= rectangle.getMinY() && (double)mouseX < rectangle.getMaxX() && (double)mouseY < rectangle.getMaxY();
    }

    public Element<T> withParent(Element<T> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (this.parent != null && !this.parent.children.contains(this)) {
            this.parent.children.add(this);
        }
        this.children.clear();
        this.init();
        return this;
    }

    public Element<T> withColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
        return this;
    }

    public Element<T> getParent() {
        return this.parent;
    }

    public List<Element<T>> getChildren() {
        return this.children;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public float getPosX() {
        return this.posX + (this.getParent() != null ? this.getParent().getPosX() : 0.0f);
    }

    public Element<T> setPosX(float posX) {
        this.posX = posX;
        return this;
    }

    public float getPosY() {
        return this.posY + (this.getParent() != null ? this.getParent().getPosY() : 0.0f);
    }

    public Element<T> setPosY(float posY) {
        this.posY = posY;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Element<T> setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Element<T> setHeight(int height) {
        this.height = height;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Element<T> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Element<T> setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public void renderChildren(float mouseX, float mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.render(mouseX, mouseY, partialTicks);
            for (Element<T> child : this.children) {
                child.renderChildren(mouseX, mouseY, partialTicks);
            }
        }
    }

    protected void drawRectangle(double x, double y, double width, double height, int color) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(x, y + height, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x, y, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    protected void drawRectangle(RectangularShape rectangle, int color) {
        this.drawRectangle(rectangle.getMinX(), rectangle.getMinY(), rectangle.getWidth(), rectangle.getHeight(), color);
    }

    protected void drawTexturedRectangle(double x, double y, double width, double height, int color) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        vertexBuffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179090_x();
    }

    protected void drawTexturedRectangle(RectangularShape rectangle, int color) {
        this.drawTexturedRectangle(rectangle.getMinX(), rectangle.getMinY(), rectangle.getWidth(), rectangle.getHeight(), color);
    }

    protected void drawOutline(double x, double y, double width, double height, int color, double outlineSize) {
        this.drawRectangle(x, y, width - outlineSize, outlineSize, color);
        this.drawRectangle(x + width - outlineSize, y, outlineSize, height - outlineSize, color);
        this.drawRectangle(x, y + height - outlineSize, width, outlineSize, color);
        this.drawRectangle(x, y, outlineSize, height - outlineSize, color);
    }

    protected void drawOutline(RectangularShape rectangle, int color, double outlineSize) {
        this.drawOutline(rectangle.getMinX(), rectangle.getMinY(), rectangle.getWidth(), rectangle.getHeight(), color, outlineSize);
    }

    protected void startScissor() {
        GL11.glEnable((int)3089);
        float scaleFactor = new ScaledResolution(ClientProxy.MINECRAFT).func_78325_e();
        GL11.glScissor((int)((int)(this.posX * scaleFactor)), (int)((int)(((float)this.gui.getHeight() - (this.posY + (float)this.height)) * scaleFactor)), (int)((int)((float)this.width * scaleFactor)), (int)((int)((float)this.height * scaleFactor)));
    }

    protected void endScissor() {
        GL11.glDisable((int)3089);
    }
}

