/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.gui.element;

import java.util.ArrayList;
import java.util.List;
import llibrary.LLibrary;
import llibrary.client.gui.element.ButtonElement;
import llibrary.client.gui.element.Element;
import llibrary.client.gui.element.IElementGUI;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WindowElement<T extends IElementGUI>
extends Element<T> {
    private String name;
    private float dragOffsetX;
    private float dragOffsetY;
    private boolean isDragging;
    private boolean hasCloseButton;
    private List<Element<T>> elementList = new ArrayList<Element<T>>();

    public WindowElement(T gui, String name, int width, int height) {
        this(gui, name, width, height, gui.getWidth() / 2 - width / 2, gui.getHeight() / 2 - height / 2, true);
    }

    public WindowElement(T gui, String name, int width, int height, boolean hasCloseButton) {
        this(gui, name, width, height, gui.getWidth() / 2 - width / 2, gui.getHeight() / 2 - height / 2, hasCloseButton);
    }

    public WindowElement(T handler, String name, int width, int height, int posX, int posY, boolean hasCloseButton) {
        super(handler, posX, posY, width, height);
        this.name = name;
        this.hasCloseButton = hasCloseButton;
        if (hasCloseButton) {
            this.addElement(new ButtonElement<IElementGUI>(this.gui, "x", this.getWidth() - 14, 0.0f, 14, 14, v -> {
                this.gui.removeElement(this);
                return true;
            }).withColorScheme(ButtonElement.CLOSE));
        }
    }

    public void addElement(Element<T> element) {
        element.withParent(this);
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.startScissor();
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), LLibrary.CONFIG.getPrimaryColor());
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), 14.0, LLibrary.CONFIG.getAccentColor());
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        fontRenderer.func_175065_a(this.name, this.getPosX() + 2.0f, this.getPosY() + 3.0f, LLibrary.CONFIG.getTextColor(), false);
        for (Element<T> element : this.elementList) {
            element.render(mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179121_F();
        this.endScissor();
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        if (button != 0 || !this.isSelected(mouseX, mouseY)) {
            return false;
        }
        if (mouseY < this.getPosY() + 14.0f) {
            this.dragOffsetX = mouseX - this.getPosX();
            this.dragOffsetY = mouseY - this.getPosY();
            this.isDragging = true;
            this.gui.sendElementToFront(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(float mouseX, float mouseY, int button, long timeSinceClick) {
        if (this.isDragging) {
            this.setPosX(Math.min(Math.max(mouseX - this.dragOffsetX, 0.0f), (float)(this.gui.getWidth() - this.getWidth())));
            this.setPosY(Math.min(Math.max(mouseY - this.dragOffsetY, 0.0f), (float)(this.gui.getHeight() - this.getHeight())));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(float mouseX, float mouseY, int button) {
        this.isDragging = false;
        return false;
    }

    @Override
    public boolean keyPressed(char character, int keyCode) {
        return false;
    }
}

