/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.model.qubble.vanilla;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleVanillaFace
implements INBTSerializable<NBTTagCompound> {
    private EnumFacing facing;
    private EnumFacing cullface;
    private String texture;
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;
    private boolean enabled = true;

    private QubbleVanillaFace(EnumFacing facing) {
        this.facing = facing;
    }

    private QubbleVanillaFace() {
    }

    public static QubbleVanillaFace create(EnumFacing facing, String texture, float minU, float minV, float maxU, float maxV) {
        QubbleVanillaFace face = new QubbleVanillaFace(facing);
        face.setTexture(texture);
        face.setUV(minU, minV, maxU, maxV);
        return face;
    }

    public static QubbleVanillaFace deserialize(NBTTagCompound compound) {
        QubbleVanillaFace face = new QubbleVanillaFace();
        face.deserializeNBT(compound);
        return face;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public void setCullface(EnumFacing cullface) {
        this.cullface = cullface;
    }

    public void setMinU(float minU) {
        this.minU = minU;
    }

    public void setMinV(float minV) {
        this.minV = minV;
    }

    public void setMaxU(float maxU) {
        this.maxU = maxU;
    }

    public void setMaxV(float maxV) {
        this.maxV = maxV;
    }

    public void setUV(float minU, float minV, float maxU, float maxV) {
        this.minU = minU;
        this.minV = minV;
        this.maxU = maxU;
        this.maxV = maxV;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public String getTexture() {
        return this.texture;
    }

    public float getMinU() {
        return this.minU;
    }

    public float getMinV() {
        return this.minV;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public EnumFacing getCullface() {
        return this.cullface;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.cullface != null) {
            compound.func_74774_a("cullface", (byte)this.cullface.ordinal());
        }
        if (this.texture != null) {
            compound.func_74778_a("texture", this.texture);
        }
        compound.func_74776_a("minU", this.minU);
        compound.func_74776_a("minV", this.minV);
        compound.func_74776_a("maxU", this.maxU);
        compound.func_74776_a("maxV", this.maxV);
        compound.func_74757_a("enabled", this.enabled);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.facing = EnumFacing.values()[compound.func_74771_c("facing")];
        if (compound.func_74764_b("cullface")) {
            this.setCullface(EnumFacing.values()[compound.func_74771_c("cullface")]);
        }
        if (compound.func_74764_b("texture")) {
            this.setTexture(compound.func_74779_i("texture"));
        }
        this.setUV(compound.func_74760_g("minU"), compound.func_74760_g("minV"), compound.func_74760_g("maxU"), compound.func_74760_g("maxV"));
        if (compound.func_74764_b("enabled")) {
            this.setEnabled(compound.func_74767_n("enabled"));
        } else {
            this.setEnabled(true);
        }
    }

    public QubbleVanillaFace copy() {
        QubbleVanillaFace face = QubbleVanillaFace.create(this.facing, this.texture, this.minU, this.minV, this.maxU, this.maxV);
        face.setEnabled(this.isEnabled());
        return face;
    }
}

