/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.model.qubble.vanilla;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import llibrary.LLibrary;
import llibrary.client.model.qubble.vanilla.QubbleVanillaCuboid;
import llibrary.client.model.qubble.vanilla.QubbleVanillaTexture;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleVanillaModel
implements INBTSerializable<NBTTagCompound> {
    private String name;
    private String author;
    private int version;
    private boolean ambientOcclusion = true;
    private Map<String, QubbleVanillaTexture> textures = new LinkedHashMap<String, QubbleVanillaTexture>();
    private Set<QubbleVanillaCuboid> cuboids = new LinkedHashSet<QubbleVanillaCuboid>();
    private transient String fileName;

    private QubbleVanillaModel() {
    }

    public static QubbleVanillaModel create(String name, String author) {
        QubbleVanillaModel model = new QubbleVanillaModel();
        model.setName(name == null ? "Unknown" : name);
        model.setAuthor(author == null ? "Unknown" : author);
        model.setVersion(LLibrary.QUBBLE_VANILLA_VERSION);
        return model;
    }

    public static QubbleVanillaModel deserialize(NBTTagCompound compound) {
        QubbleVanillaModel model = new QubbleVanillaModel();
        model.deserializeNBT(compound);
        return model;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("author", this.author);
        compound.func_74774_a("version", (byte)(this.version & 0xFF));
        compound.func_74757_a("ambientOcclusion", this.ambientOcclusion);
        NBTTagList textures = new NBTTagList();
        for (Map.Entry<String, QubbleVanillaTexture> entry : this.textures.entrySet()) {
            NBTTagCompound texture = new NBTTagCompound();
            texture.func_74778_a("key", entry.getKey());
            texture.func_74782_a("value", (NBTBase)entry.getValue().serializeNBT());
            textures.func_74742_a((NBTBase)texture);
        }
        compound.func_74782_a("textures", (NBTBase)textures);
        NBTTagList cuboids = new NBTTagList();
        for (QubbleVanillaCuboid cuboid : this.cuboids) {
            cuboids.func_74742_a((NBTBase)cuboid.serializeNBT());
        }
        compound.func_74782_a("cuboids", (NBTBase)cuboids);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.author = compound.func_74779_i("author");
        this.version = compound.func_74771_c("version") & 0xFF;
        if (compound.func_74764_b("ambientOcclusion")) {
            this.ambientOcclusion = compound.func_74767_n("ambientOcclusion");
        }
        NBTTagList textures = compound.func_150295_c("textures", 10);
        for (int i = 0; i < textures.func_74745_c(); ++i) {
            NBTTagCompound texture = textures.func_150305_b(i);
            if (!texture.func_74764_b("key") || !texture.func_74764_b("value")) continue;
            this.addTexture(texture.func_74779_i("key"), QubbleVanillaTexture.deserialize(texture.func_74775_l("value")));
        }
        NBTTagList cuboids = compound.func_150295_c("cuboids", 10);
        for (int i = 0; i < cuboids.func_74745_c(); ++i) {
            this.addCuboid(QubbleVanillaCuboid.deserialize(cuboids.func_150305_b(i)));
        }
    }

    public QubbleVanillaModel copy() {
        QubbleVanillaModel model = QubbleVanillaModel.create(this.name, this.author);
        model.setFileName(this.fileName);
        model.setAmbientOcclusion(this.ambientOcclusion);
        model.setVersion(this.version);
        for (QubbleVanillaCuboid qubbleVanillaCuboid : this.cuboids) {
            model.addCuboid(qubbleVanillaCuboid.copy());
        }
        for (Map.Entry entry : this.textures.entrySet()) {
            model.addTexture((String)entry.getKey(), ((QubbleVanillaTexture)entry.getValue()).copy());
        }
        return model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setAmbientOcclusion(boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
    }

    public void addCuboid(QubbleVanillaCuboid cuboid) {
        if (this.getCuboid(cuboid.getName()) == null) {
            this.cuboids.add(cuboid);
        }
    }

    public QubbleVanillaCuboid removeCuboid(String name) {
        QubbleVanillaCuboid cuboid = this.getCuboid(name);
        if (cuboid != null) {
            this.cuboids.remove(cuboid);
        }
        return cuboid;
    }

    public QubbleVanillaCuboid getCuboid(String name) {
        for (QubbleVanillaCuboid cuboid : this.cuboids) {
            if (!cuboid.getName().equals(name)) continue;
            return cuboid;
        }
        return null;
    }

    public void addTexture(String key, QubbleVanillaTexture texture) {
        this.textures.put(key, texture);
    }

    public void removeTexture(String key) {
        this.textures.remove(key);
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean hasAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public Map<String, QubbleVanillaTexture> getTextures() {
        return this.textures;
    }

    public Set<QubbleVanillaCuboid> getCuboids() {
        return this.cuboids;
    }
}

