/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.model.qubble.vanilla;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleVanillaRotation
implements INBTSerializable<NBTTagCompound> {
    private EnumFacing.Axis axis;
    private float originX = 8.0f;
    private float originY = 8.0f;
    private float originZ = 8.0f;
    private float angle;

    private QubbleVanillaRotation() {
    }

    public static QubbleVanillaRotation create(EnumFacing.Axis axis, float originX, float originY, float originZ, float angle) {
        QubbleVanillaRotation rotation = new QubbleVanillaRotation();
        rotation.setAxis(axis);
        rotation.setOrigin(originX, originY, originZ);
        rotation.setAngle(angle);
        return rotation;
    }

    public static QubbleVanillaRotation deserialize(NBTTagCompound compound) {
        QubbleVanillaRotation rotation = new QubbleVanillaRotation();
        rotation.deserializeNBT(compound);
        return rotation;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("axis", (byte)this.axis.ordinal());
        compound.func_74776_a("originX", this.originX);
        compound.func_74776_a("originY", this.originY);
        compound.func_74776_a("originZ", this.originZ);
        compound.func_74776_a("angle", this.angle);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.setAxis(EnumFacing.Axis.values()[compound.func_74771_c("axis")]);
        this.setOrigin(compound.func_74760_g("originX"), compound.func_74760_g("originY"), compound.func_74760_g("originZ"));
        this.setAngle(compound.func_74760_g("angle"));
    }

    public void setAxis(EnumFacing.Axis axis) {
        this.axis = axis;
    }

    public void setOriginX(float originX) {
        this.originX = originX;
    }

    public void setOriginY(float originY) {
        this.originY = originY;
    }

    public void setOriginZ(float originZ) {
        this.originZ = originZ;
    }

    public void setOrigin(float originX, float originY, float originZ) {
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
    }

    public void setAngle(float angle) {
        this.angle = this.limitAngle(angle);
    }

    protected float limitAngle(float angle) {
        return (float)MathHelper.func_76128_c((double)((double)angle / 22.5)) * 22.5f;
    }

    public EnumFacing.Axis getAxis() {
        return this.axis;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public float getOriginZ() {
        return this.originZ;
    }

    public QubbleVanillaRotation copy() {
        return QubbleVanillaRotation.create(this.axis, this.originX, this.originY, this.originZ, this.angle);
    }
}

