/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.model.qubble.vanilla;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class QubbleVanillaTexture
implements INBTSerializable<NBTTagCompound> {
    private String texture;
    private Map<String, String> properties = new HashMap<String, String>();

    private QubbleVanillaTexture() {
    }

    public static QubbleVanillaTexture create(String value) {
        QubbleVanillaTexture texture = new QubbleVanillaTexture();
        texture.texture = value;
        return texture;
    }

    public static QubbleVanillaTexture deserialize(NBTTagCompound compound) {
        QubbleVanillaTexture texture = new QubbleVanillaTexture();
        texture.deserializeNBT(compound);
        return texture;
    }

    public String getTexture() {
        return this.texture;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        String property = this.getProperty(key);
        return property != null && property.equals("true");
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("texture", this.texture);
        NBTTagList propertyList = new NBTTagList();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            NBTTagCompound property = new NBTTagCompound();
            property.func_74778_a("key", entry.getKey());
            property.func_74778_a("value", entry.getValue());
            propertyList.func_74742_a((NBTBase)property);
        }
        compound.func_74782_a("properties", (NBTBase)propertyList);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.texture = compound.func_74779_i("texture");
        NBTTagList propertyList = compound.func_150295_c("properties", 10);
        for (int i = 0; i < propertyList.func_74745_c(); ++i) {
            NBTTagCompound property = propertyList.func_150305_b(i);
            if (!property.func_74764_b("key") || !property.func_74764_b("value")) continue;
            this.properties.put(property.func_74779_i("key"), property.func_74779_i("value"));
        }
    }

    public QubbleVanillaTexture copy() {
        QubbleVanillaTexture texture = QubbleVanillaTexture.create(this.texture);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            texture.setProperty(entry.getKey(), entry.getValue());
        }
        return texture;
    }
}

