/*
 * Decompiled with CFR 0.152.
 */
package llibrary.client.model.tools;

import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Model3DTexture
extends ModelBox {
    private int width;
    private int height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, float posX, float posY, float posZ, int width, int height) {
        super(model, 0, 0, posX, posY, posZ, 0, 0, 0, 0.0f);
        this.width = width;
        this.height = height;
        this.u1 = (float)textureOffsetX / model.field_78801_a;
        this.v1 = (float)textureOffsetY / model.field_78799_b;
        this.u2 = (float)(textureOffsetX + width) / model.field_78801_a;
        this.v2 = (float)(textureOffsetY + height) / model.field_78799_b;
    }

    public Model3DTexture(ModelRenderer model, int textureOffsetX, int textureOffsetY, int width, int height) {
        this(model, textureOffsetX, textureOffsetY, 0.0f, 0.0f, 0.0f, width, height);
    }

    public void func_178780_a(BufferBuilder vertexBuffer, float scale) {
        float f9;
        float f8;
        float f7;
        int k;
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_78252_a * scale), (float)(this.field_78250_b * scale), (float)(this.field_78251_c * scale));
        GlStateManager.func_179152_a((float)((float)this.width / 16.0f), (float)((float)this.height / 16.0f), (float)1.0f);
        float depth = 0.0625f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexBuffer.func_181662_b(0.0, 1.0, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 1.0, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)this.v1).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexBuffer.func_181662_b(1.0, 0.0, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 0.0, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)this.v2).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        tessellator.func_78381_a();
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v2 - this.v1) / (float)this.height;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.u1 + (this.u2 - this.u1) * f7 - f5;
            vertexBuffer.func_181662_b((double)f7, 0.0, (double)(0.0f - depth)).func_187315_a((double)f8, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f7, 0.0, 0.0).func_187315_a((double)f8, (double)this.v2).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f7, 1.0, 0.0).func_187315_a((double)f8, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f7, 1.0, (double)(0.0f - depth)).func_187315_a((double)f8, (double)this.v1).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < this.width; ++k) {
            f7 = (float)k / (float)this.width;
            f8 = this.u1 + (this.u2 - this.u1) * f7 - f5;
            f9 = f7 + 1.0f / (float)this.width;
            vertexBuffer.func_181662_b((double)f9, 1.0, (double)(0.0f - depth)).func_187315_a((double)f8, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f9, 1.0, 0.0).func_187315_a((double)f8, (double)this.v1).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f9, 0.0, 0.0).func_187315_a((double)f8, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)f9, 0.0, (double)(0.0f - depth)).func_187315_a((double)f8, (double)this.v2).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.v2 + (this.v1 - this.v2) * f7 - f6;
            f9 = f7 + 1.0f / (float)this.height;
            vertexBuffer.func_181662_b(0.0, (double)f9, 0.0).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(1.0, (double)f9, 0.0).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(1.0, (double)f9, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.0, (double)f9, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (k = 0; k < this.height; ++k) {
            f7 = (float)k / (float)this.height;
            f8 = this.v2 + (this.v1 - this.v2) * f7 - f6;
            vertexBuffer.func_181662_b(1.0, (double)f7, 0.0).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.0, (double)f7, 0.0).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.0, (double)f7, (double)(0.0f - depth)).func_187315_a((double)this.u1, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuffer.func_181662_b(1.0, (double)f7, (double)(0.0f - depth)).func_187315_a((double)this.u2, (double)f8).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

