/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.asm;

import llibrary.server.asm.ClassPatcher;
import llibrary.server.asm.Descriptors;
import llibrary.server.asm.MappingHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Method {
    private ClassPatcher patcher;
    InsnList insnList = new InsnList();
    private AbstractInsnNode insnNode;

    public Method(ClassPatcher patcher, AbstractInsnNode insnNode) {
        this.patcher = patcher;
        this.insnNode = insnNode;
    }

    public AbstractInsnNode getInsnNode() {
        return this.insnNode;
    }

    public Method field(int opcode, Object obj, String name, Object type) {
        if (obj instanceof String) {
            String cls = MappingHandler.INSTANCE.getClassMapping((String)obj);
            String desc = MappingHandler.INSTANCE.getClassMapping(Descriptors.field(type));
            this.insnList.add((AbstractInsnNode)new FieldInsnNode(opcode, cls, MappingHandler.INSTANCE.getFieldMapping(cls, name), desc));
        }
        return this;
    }

    public Method var(int opcode, int var) {
        return this.var(opcode, var, var);
    }

    public Method var(int opcode, int from, int to) {
        if (from < to) {
            while (from <= to) {
                this.insnList.add((AbstractInsnNode)new VarInsnNode(opcode, from));
                ++from;
            }
        } else if (from > to) {
            while (from >= to) {
                this.insnList.add((AbstractInsnNode)new VarInsnNode(opcode, from));
                --from;
            }
        } else {
            this.insnList.add((AbstractInsnNode)new VarInsnNode(opcode, from));
        }
        return this;
    }

    public Method method(int opcode, Object obj, String name, Object ... params) {
        if (obj instanceof String) {
            String cls = MappingHandler.INSTANCE.getClassMapping((String)obj);
            String desc = MappingHandler.INSTANCE.getClassMapping(Descriptors.method(params));
            this.insnList.add((AbstractInsnNode)new MethodInsnNode(opcode, cls, MappingHandler.INSTANCE.getMethodMapping(cls, name, desc), desc, opcode == 185));
        }
        return this;
    }

    public Method node(int opcode) {
        return this.node((AbstractInsnNode)new InsnNode(opcode));
    }

    public Method node(AbstractInsnNode node) {
        this.insnList.add(node);
        return this;
    }
}

