/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import llibrary.server.asm.ClassPatcher;
import llibrary.server.asm.Descriptors;
import llibrary.server.asm.MappingHandler;
import llibrary.server.asm.Method;
import llibrary.server.asm.MethodPatcher;
import llibrary.server.asm.PatchClassWriter;
import llibrary.server.asm.Transformed;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class RuntimePatcher
implements IClassTransformer,
Opcodes {
    private Map<String, ClassPatcher> patcherMap = new HashMap<String, ClassPatcher>();

    public RuntimePatcher() {
        if (this.getClass().getAnnotation(Transformed.class) == null) {
            throw new RuntimeException("RuntimePatcher has not been transformed and cannot be loaded.");
        }
    }

    public abstract void onInit();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        byte[] prev;
        if (bytes == null) {
            return null;
        }
        if (this.patcherMap.isEmpty()) {
            this.onInit();
        }
        if ((prev = bytes) != (bytes = this.handlePatches(bytes, MappingHandler.INSTANCE.getClassMapping(transformedName)))) {
            this.saveBytecode(transformedName, bytes);
        }
        return bytes;
    }

    private byte[] handlePatches(byte[] bytes, String cls) {
        ClassPatcher patcher = this.patcherMap.get(cls);
        if (patcher != null) {
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            patcher.handlePatches(classNode);
            PatchClassWriter classWriter = new PatchClassWriter(classReader, 3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return bytes;
    }

    public ClassPatcher patchClass(Object obj) {
        ClassPatcher patcher = null;
        if (obj instanceof String) {
            String cls = MappingHandler.INSTANCE.getClassMapping((String)obj);
            patcher = new ClassPatcher(cls);
            this.patcherMap.put(cls, patcher);
        }
        return patcher;
    }

    public Predicate<MethodPatcher.PredicateData> at(At at, Object ... args) {
        return at.getPredicate(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBytecode(String name, byte[] bytes) {
        FileOutputStream out = null;
        try {
            File debugDir = new File("llibrary/debug/");
            if (debugDir.exists()) {
                debugDir.delete();
            }
            debugDir.mkdirs();
            out = new FileOutputStream(new File(debugDir, name + ".class"));
            out.write(bytes);
            out.close();
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public String toString() {
        return "runtimePatcher:" + this.getClass().getSimpleName() + this.patcherMap.values();
    }

    public static enum Patch {
        BEFORE{

            @Override
            public void apply(MethodPatcher.PatchData patch, MethodNode methodNode, AbstractInsnNode location, Method method) {
                methodNode.instructions.insertBefore(location, method.insnList);
            }
        }
        ,
        AFTER{

            @Override
            public void apply(MethodPatcher.PatchData patch, MethodNode methodNode, AbstractInsnNode location, Method method) {
                methodNode.instructions.insert(location, method.insnList);
            }
        }
        ,
        REPLACE{

            @Override
            public void apply(MethodPatcher.PatchData patch, MethodNode methodNode, AbstractInsnNode location, Method method) {
                methodNode.instructions.clear();
                methodNode.instructions.add(method.insnList);
            }
        }
        ,
        REPLACE_NODE{

            @Override
            public void apply(MethodPatcher.PatchData patch, MethodNode methodNode, AbstractInsnNode location, Method method) {
                methodNode.instructions.insertBefore(location, method.insnList);
                methodNode.instructions.remove(location);
            }
        };


        public abstract void apply(MethodPatcher.PatchData var1, MethodNode var2, AbstractInsnNode var3, Method var4);
    }

    public static enum At {
        METHOD{

            @Override
            public Predicate<MethodPatcher.PredicateData> getPredicate(final Object ... args) {
                return new Predicate<MethodPatcher.PredicateData>(){
                    private String mappedName;
                    private String mappedDesc;

                    @Override
                    public boolean test(MethodPatcher.PredicateData predicateData) {
                        if (predicateData.node instanceof MethodInsnNode) {
                            MethodInsnNode methodNode = (MethodInsnNode)predicateData.node;
                            if (this.mappedDesc == null) {
                                this.mappedDesc = MappingHandler.INSTANCE.getClassMapping(Descriptors.method(Arrays.copyOfRange(args, 1, args.length)));
                            }
                            if (this.mappedName == null) {
                                this.mappedName = MappingHandler.INSTANCE.getMethodMapping(predicateData.cls, (String)args[0], this.mappedDesc);
                            }
                            return methodNode.name.equals(this.mappedName) && (this.mappedDesc.isEmpty() || methodNode.desc.equals(this.mappedDesc));
                        }
                        return false;
                    }
                };
            }
        }
        ,
        RETURN{

            @Override
            public Predicate<MethodPatcher.PredicateData> getPredicate(Object ... args) {
                return predicateData -> {
                    int opcode = predicateData.node.getOpcode();
                    return opcode == 177 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176;
                };
            }
        }
        ,
        LDC{

            @Override
            public Predicate<MethodPatcher.PredicateData> getPredicate(Object ... args) {
                return predicateData -> {
                    if (predicateData.node instanceof LdcInsnNode) {
                        LdcInsnNode ldcNode = (LdcInsnNode)predicateData.node;
                        if (ldcNode.cst.equals(args[0])) {
                            return true;
                        }
                    }
                    return false;
                };
            }
        }
        ,
        NODE{

            @Override
            public Predicate<MethodPatcher.PredicateData> getPredicate(Object ... args) {
                return predicateData -> predicateData.node.getOpcode() == ((Integer)args[0]).intValue();
            }
        };


        public abstract Predicate<MethodPatcher.PredicateData> getPredicate(Object ... var1);
    }
}

