/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.capability;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import llibrary.LLibrary;
import llibrary.server.capability.IEntityData;
import llibrary.server.capability.IEntityDataCapability;
import net.minecraft.entity.Entity;

public enum EntityDataHandler {
    INSTANCE;

    private final Map<Entity, List<IEntityData>> queuedEntityData = new IdentityHashMap<Entity, List<IEntityData>>();

    @Deprecated
    public <T extends Entity> void registerExtendedEntityData(T entity, IEntityData<T> entityData) {
        IEntityDataCapability dataCap = (IEntityDataCapability)entity.getCapability(LLibrary.ENTITY_DATA_CAPABILITY, null);
        if (dataCap == null) {
            List data = this.queuedEntityData.computeIfAbsent(entity, e -> new ArrayList());
            data.add(entityData);
        } else {
            dataCap.registerData(entityData);
        }
    }

    @Nullable
    public <T extends Entity> IEntityData<T> getEntityData(T entity, String identifier) {
        IEntityDataCapability dataCap = (IEntityDataCapability)entity.getCapability(LLibrary.ENTITY_DATA_CAPABILITY, null);
        if (dataCap == null) {
            throw new IllegalStateException("Cannot get entity data on entity without data cap");
        }
        return dataCap.getData(identifier);
    }

    public <T extends Entity> List<IEntityData<T>> getEntityData(T entity) {
        IEntityDataCapability dataCap = (IEntityDataCapability)entity.getCapability(LLibrary.ENTITY_DATA_CAPABILITY, null);
        if (dataCap == null) {
            throw new IllegalStateException("Cannot get entity data on entity without data cap");
        }
        return dataCap.getData();
    }

    @Deprecated
    public void putQueuedData(Entity entity, IEntityDataCapability dataCap) {
        List<IEntityData> queuedData = this.queuedEntityData.remove(entity);
        if (queuedData != null) {
            queuedData.forEach(dataCap::registerData);
        }
    }

    @Deprecated
    public void releaseQueuedData(Entity entity) {
        this.queuedEntityData.remove(entity);
    }
}

