/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.network;

import io.netty.buffer.ByteBuf;
import llibrary.server.capability.EntityDataHandler;
import llibrary.server.capability.IEntityData;
import llibrary.server.entity.EntityProperties;
import llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PropertiesMessage
extends AbstractMessage<PropertiesMessage> {
    private String propertyID;
    private NBTTagCompound compound;
    private int entityID;

    public PropertiesMessage() {
    }

    public PropertiesMessage(EntityProperties<?> properties, Entity entity) {
        this.propertyID = properties.getID();
        NBTTagCompound compound = new NBTTagCompound();
        properties.saveTrackingSensitiveData(compound);
        this.compound = compound;
        this.entityID = entity.func_145782_y();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, PropertiesMessage message, EntityPlayer player, MessageContext messageContext) {
        IEntityData<Entity> extendedProperties;
        Entity entity = player.field_70170_p.func_73045_a(message.entityID);
        if (entity != null && (extendedProperties = EntityDataHandler.INSTANCE.getEntityData(entity, message.propertyID)) instanceof EntityProperties) {
            EntityProperties properties = (EntityProperties)extendedProperties;
            properties.loadTrackingSensitiveData(message.compound);
            properties.onSync();
        }
    }

    @Override
    public void onServerReceived(MinecraftServer server, PropertiesMessage message, EntityPlayer player, MessageContext messageContext) {
    }

    public void fromBytes(ByteBuf buf) {
        this.propertyID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.entityID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.propertyID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
        buf.writeInt(this.entityID);
    }
}

