/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.property;

import llibrary.server.property.IDoubleProperty;

public interface IDoubleRangeProperty
extends IDoubleProperty {
    @Override
    default public boolean isValidDouble(double value) {
        return value >= this.getMinDoubleValue() && value <= this.getMaxDoubleValue();
    }

    public double getMinDoubleValue();

    public double getMaxDoubleValue();

    default public double getDoubleValueRange() {
        return this.getMaxDoubleValue() - this.getMinDoubleValue();
    }

    public static class WithState
    extends IDoubleProperty.WithState
    implements IDoubleRangeProperty {
        private final double minDoubleValue;
        private final double maxDoubleValue;

        public WithState(double value, double minDoubleValue, double maxDoubleValue) {
            super(value);
            this.minDoubleValue = minDoubleValue;
            this.maxDoubleValue = maxDoubleValue;
        }

        @Override
        public double getMinDoubleValue() {
            return this.minDoubleValue;
        }

        @Override
        public double getMaxDoubleValue() {
            return this.maxDoubleValue;
        }
    }
}

