/*
 * Decompiled with CFR 0.152.
 */
package llibrary.server.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import llibrary.server.structure.BlockList;
import llibrary.server.structure.ComponentInfo;
import llibrary.server.structure.StructureGenerator;
import llibrary.server.structure.rule.FixedRule;
import llibrary.server.structure.rule.RepeatRule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class StructureBuilder
extends StructureGenerator {
    private final HashMap<BlockPos, BlockList> blocks = new HashMap();
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private final List<RepeatRule> repeats = new ArrayList<RepeatRule>();
    private final List<ComponentInfo> components = new ArrayList<ComponentInfo>();
    private ComponentInfo currentLayer;
    private EnumFacing front = EnumFacing.EAST;
    private EnumFacing top = EnumFacing.UP;

    @Override
    public void generate(World world, BlockPos pos, Random random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (ComponentInfo layer : this.components) {
            for (RepeatRule rule : layer.repeats) {
                rule.reset(world, random, mutablePos);
            }
        }
        BlockPos.PooledMutableBlockPos pooledPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (ComponentInfo layer : this.components) {
            mutablePos.func_189533_g((Vec3i)pos);
            for (RepeatRule rule : layer.repeats) {
                rule.init(world, random, mutablePos);
                while (rule.continueRepeating(world, random, mutablePos)) {
                    for (Map.Entry<BlockPos, BlockList> e : layer.blocks.entrySet()) {
                        BlockPos coords = e.getKey();
                        int blockX = coords.func_177958_n() + mutablePos.func_177958_n();
                        int blockY = coords.func_177956_o() + mutablePos.func_177956_o();
                        int blockZ = coords.func_177952_p() + mutablePos.func_177952_p();
                        world.func_175656_a(pooledPos.func_181079_c(blockX, blockY, blockZ).func_185334_h(), e.getValue().getRandom(random));
                    }
                    rule.repeat(world, random, mutablePos);
                }
            }
        }
        pooledPos.func_185344_t();
    }

    @Override
    public StructureBuilder rotate(EnumFacing front, EnumFacing top) {
        if (front == top || front.func_176734_d() == top) {
            throw new IllegalArgumentException("Invalid rotation: " + front + " & " + top);
        }
        Vec3i frontVec = new Vec3i(front.func_82601_c(), front.func_96559_d(), front.func_82599_e());
        Vec3i topVec = new Vec3i(-top.func_82601_c(), -top.func_96559_d(), -top.func_82599_e());
        Vec3i perpVec = topVec.func_177955_d(frontVec);
        StructureBuilder copy = new StructureBuilder();
        copy.front = StructureBuilder.transform(this.front, frontVec, topVec, perpVec);
        copy.top = StructureBuilder.transform(this.top, frontVec, topVec, perpVec);
        for (ComponentInfo oldComp : this.components) {
            ComponentInfo newComp = new ComponentInfo();
            newComp.repeats.addAll(oldComp.repeats);
            newComp.front = StructureBuilder.transform(oldComp.front, frontVec, topVec, perpVec);
            newComp.top = StructureBuilder.transform(oldComp.top, frontVec, topVec, perpVec);
            HashMap<BlockPos, BlockList> blocks = newComp.blocks;
            boolean inverted = top == EnumFacing.DOWN;
            for (BlockPos coords : oldComp.blocks.keySet()) {
                BlockPos newCoords = StructureBuilder.transform((Vec3i)coords, frontVec, topVec, perpVec);
                BlockList newList = oldComp.blocks.get(coords).copy();
                IBlockState[] states = newList.getStates();
                for (int i = 0; i < states.length; ++i) {
                    EnumFacing facing;
                    IBlockState state = states[i];
                    if (state.func_177230_c() instanceof BlockStairs) {
                        facing = StructureBuilder.transform((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a), frontVec, topVec, perpVec);
                        EnumFacing perp = StructureBuilder.transform(EnumFacing.UP, frontVec, topVec, perpVec);
                        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                            if (state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM) {
                                perp = perp.func_176734_d();
                                if (facing == EnumFacing.UP) {
                                    state = state.func_177231_a((IProperty)BlockStairs.field_176308_b);
                                }
                            } else if (facing == EnumFacing.DOWN) {
                                state = state.func_177231_a((IProperty)BlockStairs.field_176308_b);
                            }
                            state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)perp);
                        } else {
                            state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing);
                        }
                        if (inverted) {
                            state = state.func_177231_a((IProperty)BlockStairs.field_176308_b);
                        }
                    } else if (state.func_177230_c() instanceof BlockSlab) {
                        if (inverted) {
                            state = state.func_177231_a((IProperty)BlockSlab.field_176554_a);
                        }
                    } else if (state.func_177230_c() instanceof BlockVine) {
                        facing = StructureBuilder.transform((Boolean)state.func_177229_b((IProperty)BlockVine.field_176273_b) != false ? EnumFacing.NORTH : ((Boolean)state.func_177229_b((IProperty)BlockVine.field_176278_M) != false ? EnumFacing.EAST : ((Boolean)state.func_177229_b((IProperty)BlockVine.field_176279_N) != false ? EnumFacing.SOUTH : EnumFacing.WEST)), frontVec, topVec, perpVec);
                        if (inverted) {
                            facing = facing.func_176734_d();
                        }
                        state = state.func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(facing == EnumFacing.NORTH));
                        state = state.func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(facing == EnumFacing.EAST));
                        state = state.func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(facing == EnumFacing.SOUTH));
                        state = state.func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(facing == EnumFacing.WEST));
                    } else if (state.func_177230_c() instanceof BlockLog) {
                        BlockLog.EnumAxis axis = (BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a);
                        EnumFacing facing2 = axis == BlockLog.EnumAxis.X ? EnumFacing.EAST : (axis == BlockLog.EnumAxis.Y ? EnumFacing.UP : EnumFacing.SOUTH);
                        EnumFacing transformed = StructureBuilder.transform(facing2, frontVec, topVec, perpVec);
                        state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)transformed.func_176740_k()));
                    } else {
                        for (IProperty prop : state.func_177227_a()) {
                            if (!(prop instanceof PropertyDirection)) continue;
                            PropertyDirection propDir = (PropertyDirection)prop;
                            EnumFacing facing3 = (EnumFacing)state.func_177229_b((IProperty)propDir);
                            EnumFacing newFacing = StructureBuilder.transform(facing3, frontVec, topVec, perpVec);
                            if (!propDir.func_177700_c().contains(newFacing)) continue;
                            state = state.func_177226_a((IProperty)propDir, (Comparable)newFacing);
                        }
                    }
                    states[i] = state;
                }
                blocks.put(newCoords, newList);
            }
            copy.components.add(newComp);
        }
        return copy;
    }

    private static BlockPos transform(Vec3i pos, Vec3i vec3i, Vec3i vec3i1, Vec3i vec3i2) {
        return new BlockPos(vec3i1.func_177958_n() * -pos.func_177956_o() + vec3i2.func_177958_n() * pos.func_177952_p() + vec3i.func_177958_n() * pos.func_177958_n(), vec3i1.func_177956_o() * -pos.func_177956_o() + vec3i2.func_177956_o() * pos.func_177952_p() + vec3i.func_177956_o() * pos.func_177958_n(), vec3i1.func_177952_p() * -pos.func_177956_o() + vec3i2.func_177952_p() * pos.func_177952_p() + vec3i.func_177952_p() * pos.func_177958_n());
    }

    private static EnumFacing transform(EnumFacing facing, Vec3i vec3i, Vec3i vec3i1, Vec3i vec3i2) {
        BlockPos vec = StructureBuilder.transform(facing.func_176730_m(), vec3i, vec3i1, vec3i2);
        return EnumFacing.func_176737_a((float)vec.func_177958_n(), (float)vec.func_177956_o(), (float)vec.func_177952_p());
    }

    @Override
    public StructureBuilder rotateTowards(EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            throw new IllegalArgumentException("Must be horizontal facing: " + facing);
        }
        int idx = facing.func_176736_b() - (this.front.func_176740_k() == EnumFacing.Axis.Y ? this.top.func_176736_b() : this.front.func_176736_b()) - 1;
        idx = (idx % EnumFacing.field_176754_o.length + EnumFacing.field_176754_o.length) % EnumFacing.field_176754_o.length;
        return this.rotate(EnumFacing.field_176754_o[idx], EnumFacing.UP);
    }

    public StructureBuilder startComponent() {
        this.currentLayer = new ComponentInfo();
        this.blocks.clear();
        this.repeats.clear();
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        return this;
    }

    public StructureBuilder setOrientation(EnumFacing front, EnumFacing top) {
        this.currentLayer.front = front;
        this.currentLayer.top = top;
        return this;
    }

    public StructureBuilder endComponent() {
        this.currentLayer.blocks.putAll(this.blocks);
        this.currentLayer.repeats.addAll(this.repeats);
        this.components.add(this.currentLayer);
        return this;
    }

    public StructureBuilder setOffset(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public StructureBuilder translate(int x, int y, int z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
        return this;
    }

    public StructureBuilder setBlock(int x, int y, int z, Block block) {
        return this.setBlock(x, y, z, block.func_176223_P());
    }

    public StructureBuilder setBlock(int x, int y, int z, IBlockState block) {
        return this.setBlock(x, y, z, new BlockList(block));
    }

    public StructureBuilder setBlock(int x, int y, int z, BlockList list) {
        this.blocks.put(new BlockPos(x + this.offsetX, y + this.offsetY, z + this.offsetZ), list);
        return this;
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, IBlockState block) {
        return this.cube(startX, startY, startZ, width, height, depth, new BlockList(block));
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        if (depth > 1) {
            this.fillCube(startX, startY, startZ, width, height, 1, list);
            this.fillCube(startX, startY, startZ + depth - 1, width, height, 1, list);
        }
        if (width > 1) {
            this.fillCube(startX, startY, startZ, 1, height, depth, list);
            this.fillCube(startX + width - 1, startY, startZ, 1, height, depth, list);
        }
        if (height > 1) {
            this.fillCube(startX, startY, startZ, width, 1, depth, list);
            this.fillCube(startX, startY + height - 1, startZ, width, 1, depth, list);
        }
        return this;
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, IBlockState block) {
        return this.fillCube(startX, startY, startZ, width, height, depth, new BlockList(block));
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        for (int x = startX; x < startX + width; ++x) {
            for (int y = startY; y < startY + height; ++y) {
                for (int z = startZ; z < startZ + depth; ++z) {
                    this.setBlock(x, y, z, list);
                }
            }
        }
        return this;
    }

    public StructureBuilder repeat(int spacingX, int spacingY, int spacingZ, int times) {
        return this.repeat(spacingX, spacingY, spacingZ, new FixedRule(times));
    }

    public StructureBuilder repeat(int spacingX, int spacingY, int spacingZ, RepeatRule repeatRule) {
        repeatRule.setSpacing(spacingX, spacingY, spacingZ);
        return this.addBakedRepeatRule(repeatRule);
    }

    public StructureBuilder addBakedRepeatRule(RepeatRule repeatRule) {
        this.repeats.add(repeatRule);
        return this;
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.cube(startX, startY, startZ, width, height, depth, block.func_176223_P());
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.fillCube(startX, startY, startZ, width, height, depth, block.func_176223_P());
    }

    public StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.wireCube(startX, startY, startZ, width, height, depth, block.func_176223_P());
    }

    public StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, IBlockState state) {
        return this.wireCube(startX, startY, startZ, width, height, depth, new BlockList(state));
    }

    private StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        this.fillCube(startX, startY, startZ, 1, height, 1, list);
        this.fillCube(startX + width - 1, startY, startZ, 1, height, 1, list);
        this.fillCube(startX + width - 1, startY, startZ + depth - 1, 1, height, 1, list);
        this.fillCube(startX, startY, startZ + depth - 1, 1, height, 1, list);
        this.fillCube(startX, startY, startZ, width, 1, 1, list);
        this.fillCube(startX, startY + height, startZ, width, 1, 1, list);
        this.fillCube(startX, startY, startZ + depth - 1, width, 1, 1, list);
        this.fillCube(startX, startY + height, startZ + depth - 1, width, 1, 1, list);
        this.fillCube(startX, startY, startZ, 1, 1, depth, list);
        this.fillCube(startX, startY + height, startZ, 1, 1, depth, list);
        this.fillCube(startX + width - 1, startY, startZ, 1, 1, depth, list);
        this.fillCube(startX + width - 1, startY + height, startZ, 1, 1, depth, list);
        return this;
    }
}

