/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.item;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.core.ConfigTinyMobFarm;
import cn.davidma.tinymobfarm.core.util.EntityHelper;
import cn.davidma.tinymobfarm.core.util.Msg;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemLasso
extends Item {
    public ItemLasso() {
        this.setRegistryName("tinymobfarm:lasso");
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        this.func_77656_e(ConfigTinyMobFarm.LASSO_DURABILITY);
        this.func_77637_a(TinyMobFarm.creativeTabTinyMobFarm);
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (NBTHelper.hasMob(stack) || target.field_70128_L || !(target instanceof EntityLiving)) {
            return false;
        }
        NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
        if (!target.func_184222_aU()) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.cannot_capture_boss");
            }
            return true;
        }
        if (EntityHelper.isMobBlacklisted((EntityLiving)target)) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.blacklisted_mob");
            }
            return true;
        }
        if (!player.field_70170_p.field_72995_K) {
            NBTTagCompound mobData = target.serializeNBT();
            mobData.func_82580_o("Rotation");
            nbt.func_74782_a("mobData", (NBTBase)mobData);
            nbt.func_74778_a("mobName", target.func_70005_c_());
            nbt.func_74778_a("mobLootTableLocation", EntityHelper.getLootTableLocation((EntityLiving)target));
            nbt.func_74780_a("mobHealth", (double)Math.round(target.func_110143_aJ() * 10.0f) / 10.0);
            nbt.func_74780_a("mobMaxHealth", (double)target.func_110138_aP());
            nbt.func_74757_a("mobHostile", target.isCreatureType(EnumCreatureType.MONSTER, false));
            NBTHelper.setBaseTag(stack, nbt);
            if (player.func_184812_l_()) {
                ItemStack newLasso = new ItemStack((Item)this);
                NBTHelper.setBaseTag(newLasso, nbt);
                player.func_191521_c(newLasso);
            }
            target.func_70106_y();
            player.field_71071_by.func_70296_d();
        }
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!NBTHelper.hasMob(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
            NBTTagCompound mobData = nbt.func_74775_l("mobData");
            BlockPos newPos = pos.func_177972_a(facing);
            NBTTagDouble x = new NBTTagDouble((double)newPos.func_177958_n() + 0.5);
            NBTTagDouble y = new NBTTagDouble((double)newPos.func_177956_o());
            NBTTagDouble z = new NBTTagDouble((double)newPos.func_177952_p() + 0.5);
            NBTTagList mobPos = NBTHelper.createNBTList(new NBTBase[]{x, y, z});
            mobData.func_74782_a("Pos", (NBTBase)mobPos);
            mobData.func_74768_a("Dimension", world.field_73011_w.getDimension());
            Entity mob = EntityList.func_75615_a((NBTTagCompound)mobData, (World)world);
            if (mob != null) {
                world.func_72838_d(mob);
            }
            NBTHelper.getOrCreateTag(stack).func_82580_o("capturedMob");
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.field_71071_by.func_70296_d();
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (NBTHelper.hasMob(stack)) {
            NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
            String name = nbt.func_74779_i("mobName");
            double health = nbt.func_74769_h("mobHealth");
            double maxHealth = nbt.func_74769_h("mobMaxHealth");
            tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.release_mob", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.mob_name", (Object[])new Object[]{name}));
            tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.health", (Object[])new Object[]{health, maxHealth}));
            if (nbt.func_74767_n("mobHostile")) {
                tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.hostile", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.capture", (Object[])new Object[0]));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.hasMob(stack);
    }
}

