/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.core;

import cn.davidma.tinymobfarm.core.ConfigTinyMobFarm;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public enum EnumMobFarm {
    WOOD("wood_farm", Material.field_151575_d, 1.0f, false, new int[]{2, 3, 3}),
    STONE("stone_farm", Material.field_151576_e, 1.5f, false, new int[]{1, 2, 3}),
    IRON("iron_farm", Material.field_151573_f, 5.0f, true, new int[]{1, 2}),
    GOLD("gold_farm", Material.field_151573_f, 5.0f, true, new int[]{1, 1, 2}),
    DIAMOND("diamond_farm", Material.field_151573_f, 5.0f, true, new int[]{1}),
    EMERALD("emerald_farm", Material.field_151573_f, 5.0f, true, new int[]{0, 1, 1}),
    INFERNAL("inferno_farm", Material.field_151576_e, 50.0f, true, new int[]{0, 0, 1}),
    ULTIMATE("ultimate_farm", Material.field_151576_e, 75.0f, true, new int[]{0});

    private String registryName;
    private Material material;
    private float hardness;
    private boolean canFarmHostile;
    private int[] damageChance;
    private Map<Integer, Integer> normalizedChance;

    private EnumMobFarm(String registryName, Material material, float hardness, boolean canFarmHostile, int[] damageChance) {
        this.registryName = registryName;
        this.material = material;
        this.hardness = hardness;
        this.canFarmHostile = canFarmHostile;
        this.damageChance = damageChance;
        this.normalizedChance = new HashMap<Integer, Integer>();
        for (int i : this.damageChance) {
            if (!this.normalizedChance.containsKey(i)) {
                this.normalizedChance.put(i, 0);
            }
            this.normalizedChance.put(i, this.normalizedChance.get(i) + 1);
        }
        int denominator = this.damageChance.length;
        for (int i : this.normalizedChance.keySet()) {
            this.normalizedChance.put(i, (int)((double)this.normalizedChance.get(i).intValue() * 100.0 / (double)denominator));
        }
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getUnlocalizedName() {
        return String.format("tile.%s:%s.name", "tinymobfarm", this.registryName);
    }

    public Material getMaterial() {
        return this.material;
    }

    public float getHardness() {
        return this.hardness;
    }

    public boolean isLassoValid(ItemStack lasso) {
        return NBTHelper.hasMob(lasso) && (this.canFarmHostile || !NBTHelper.hasHostileMob(lasso));
    }

    public int getMaxProgress() {
        return (int)(ConfigTinyMobFarm.MOB_FARM_SPEED[this.ordinal()] * 20.0);
    }

    public int getRandomDamage(Random rand) {
        return this.damageChance[rand.nextInt(this.damageChance.length)];
    }

    public void addTooltip(List<String> tooltip) {
        if (!this.canFarmHostile) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tinymobfarm.tooltip.no_hostile", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.farm_rate", (Object[])new Object[]{ConfigTinyMobFarm.MOB_FARM_SPEED[this.ordinal()]}));
        tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.durability_info", (Object[])new Object[0]));
        for (int i : this.normalizedChance.keySet()) {
            if (i == 0) {
                tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.no_durability", (Object[])new Object[]{this.normalizedChance.get(i)}));
                continue;
            }
            tooltip.add(I18n.func_135052_a((String)"tinymobfarm.tooltip.default_durability", (Object[])new Object[]{this.normalizedChance.get(i), i}));
        }
    }
}

