/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.core.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static final String MOB = "capturedMob";
    public static final String MOB_NAME = "mobName";
    public static final String MOB_DATA = "mobData";
    public static final String MOB_HEALTH = "mobHealth";
    public static final String MOB_MAX_HEALTH = "mobMaxHealth";
    public static final String MOB_HOSTILE = "mobHostile";
    public static final String MOB_LOOTTABLE_LOCATION = "mobLootTableLocation";
    public static final String MOB_FARM_DATA = "mobFarmData";
    public static final String CURR_PROGRESS = "currProgress";
    public static final String INVENTORY = "inventory";

    public static NBTTagCompound getBaseTag(ItemStack stack) {
        return NBTHelper.getOrCreateTag(stack).func_74775_l(MOB);
    }

    public static void setBaseTag(ItemStack stack, NBTTagCompound nbt) {
        NBTHelper.getOrCreateTag(stack).func_74782_a(MOB, (NBTBase)nbt);
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static boolean hasMob(ItemStack stack) {
        return NBTHelper.getOrCreateTag(stack).func_74764_b(MOB);
    }

    public static boolean hasHostileMob(ItemStack stack) {
        if (!NBTHelper.hasMob(stack)) {
            return false;
        }
        NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
        return nbt.func_74767_n(MOB_HOSTILE);
    }

    public static NBTTagList createNBTList(NBTBase ... tags) {
        NBTTagList list = new NBTTagList();
        for (NBTBase i : tags) {
            list.func_74742_a(i);
        }
        return list;
    }
}

