/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.SlotTrash;
import net.blay09.mods.trashslot.client.TrashSlotGuiHandler;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiTrashSlot
extends AbstractGui {
    private static final ResourceLocation texture = new ResourceLocation("trashslot", "textures/gui/slot.png");
    private static final int SNAP_SIZE = 7;
    private final TrashSlotGuiHandler trashSlotGui;
    private final ContainerScreen<?> gui;
    private final IGuiContainerLayout layout;
    private final ContainerSettings settings;
    private final SlotTrash trashSlot;
    private SlotRenderStyle renderStyle = SlotRenderStyle.LONE;
    private boolean wasMouseDown;
    private boolean isDragging;
    private int dragStartX;
    private int dragStartY;

    public GuiTrashSlot(TrashSlotGuiHandler trashSlotGui, ContainerScreen<?> gui, IGuiContainerLayout layout, ContainerSettings settings, SlotTrash trashSlot) {
        this.trashSlotGui = trashSlotGui;
        this.gui = gui;
        this.layout = layout;
        this.settings = settings;
        this.trashSlot = trashSlot;
    }

    public boolean isInside(int mouseX, int mouseY) {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        return mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
    }

    public void update(int mouseX, int mouseY) {
        boolean isMouseOver;
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        boolean bl = isMouseOver = mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
        if (this.trashSlotGui.isLeftMouseDown()) {
            if (!(this.isDragging || !isMouseOver || this.wasMouseDown || !this.gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_190926_b() || this.trashSlot.func_75216_d() && this.gui.func_195362_a((Slot)this.trashSlot, (double)mouseX, (double)mouseY))) {
                this.dragStartX = renderX - mouseX;
                this.dragStartY = renderY - mouseY;
                this.isDragging = true;
            }
            this.wasMouseDown = true;
        } else {
            if (this.isDragging) {
                TrashSlotSaveState.save();
                this.isDragging = false;
            }
            this.wasMouseDown = false;
        }
        if (this.isDragging) {
            int targetX = mouseX + this.dragStartX;
            int targetY = mouseY + this.dragStartY;
            for (Rectangle collisionArea : this.layout.getCollisionAreas(this.gui)) {
                int targetRight = targetX + this.renderStyle.getWidth();
                int targetBottom = targetY + this.renderStyle.getHeight();
                int rectRight = collisionArea.x + collisionArea.width;
                int rectBottom = collisionArea.y + collisionArea.height;
                if (targetRight < collisionArea.x || targetX >= rectRight || targetBottom < collisionArea.y || targetY >= rectBottom) continue;
                int distLeft = targetRight - collisionArea.x;
                int distRight = rectRight - targetX;
                int distTop = targetBottom - collisionArea.y;
                int distBottom = rectBottom - targetY;
                if (anchoredX >= collisionArea.x && anchoredX < collisionArea.x + collisionArea.width) {
                    targetY = distTop < distBottom ? collisionArea.y - this.renderStyle.getHeight() : collisionArea.y + collisionArea.height;
                    continue;
                }
                targetX = distLeft < distRight ? collisionArea.x - this.renderStyle.getWidth() : collisionArea.x + collisionArea.width;
            }
            if (!Screen.func_231173_s_()) {
                int bestSnapDist = Integer.MAX_VALUE;
                Snap bestSnap = null;
                for (Snap snap : this.layout.getSnaps(this.gui, this.renderStyle)) {
                    int dist = Integer.MAX_VALUE;
                    switch (snap.getType()) {
                        case HORIZONTAL: {
                            dist = Math.abs(snap.getY() - targetY);
                            break;
                        }
                        case VERTICAL: {
                            dist = Math.abs(snap.getX() - targetX);
                            break;
                        }
                        case FIXED: {
                            int distX = snap.getX() - targetX;
                            int distY = snap.getY() - targetY;
                            dist = (int)Math.sqrt(distX * distX + distY * distY);
                        }
                    }
                    if (dist >= 7 || dist >= bestSnapDist) continue;
                    bestSnap = snap;
                    bestSnapDist = dist;
                }
                if (bestSnap != null) {
                    if (bestSnap.getType() == Snap.Type.VERTICAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetX = bestSnap.getX();
                    }
                    if (bestSnap.getType() == Snap.Type.HORIZONTAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetY = bestSnap.getY();
                    }
                }
            }
            targetX = MathHelper.func_76125_a((int)targetX, (int)0, (int)(this.gui.field_230708_k_ - this.renderStyle.getRenderWidth()));
            targetY = MathHelper.func_76125_a((int)targetY, (int)0, (int)(this.gui.field_230709_l_ - this.renderStyle.getRenderHeight()));
            this.settings.setSlotX(this.getUnanchoredX(targetX));
            this.settings.setSlotY(this.getUnanchoredY(targetY));
        }
    }

    public void drawBackground(MatrixStack matrixStack) {
        int renderX = this.getAnchoredX();
        int renderY = this.getAnchoredY();
        this.renderStyle = this.layout.getSlotRenderStyle(this.gui, renderX, renderY);
        this.trashSlot.field_75223_e = renderX - this.gui.getGuiLeft() + this.renderStyle.getSlotOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        this.trashSlot.field_75221_f = renderY - this.gui.getGuiTop() + this.renderStyle.getSlotOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        this.func_230926_e_(1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.getMinecraft().func_110434_K().func_110577_a(texture);
        renderX += this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        renderY += this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        int texOffsetX = 0;
        if (deletionProvider == null || !deletionProvider.canUndeleteLast()) {
            texOffsetX = 64;
        }
        switch (this.renderStyle) {
            case LONE: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 56, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                break;
            }
            case ATTACH_BOTTOM_CENTER: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_LEFT: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_RIGHT: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 50, 29, 4, 4);
                break;
            }
            case ATTACH_TOP_CENTER: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_LEFT: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_RIGHT: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                break;
            }
            case ATTACH_LEFT_CENTER: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_TOP: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_BOTTOM: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                break;
            }
            case ATTACH_RIGHT_CENTER: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 54, 33, 4, 4);
                this.func_238474_b_(matrixStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_TOP: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_BOTTOM: {
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_238474_b_(matrixStack, renderX, renderY, texOffsetX + 54, 33, 4, 4);
            }
        }
        this.func_230926_e_(0);
    }

    private int getAnchoredX() {
        return MathHelper.func_76125_a((int)(this.settings.getSlotX() + this.gui.getGuiLeft() + (int)((float)this.gui.getXSize() * this.settings.getAnchorX())), (int)0, (int)(this.gui.field_230708_k_ - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredX(int x) {
        return x - this.gui.getGuiLeft() - (int)((float)this.gui.getXSize() * this.settings.getAnchorX());
    }

    private int getAnchoredY() {
        return MathHelper.func_76125_a((int)(this.settings.getSlotY() + this.gui.getGuiTop() + (int)((float)this.gui.getYSize() * this.settings.getAnchorY())), (int)0, (int)(this.gui.field_230708_k_ - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredY(int y) {
        return y - this.gui.getGuiTop() - (int)((float)this.gui.getYSize() * this.settings.getAnchorY());
    }

    public boolean isVisible() {
        return this.settings.isEnabled();
    }

    public Rectangle2d getRectangle() {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        return new Rectangle2d(renderX, renderY, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
    }
}

