/*
 * Decompiled with CFR 0.152.
 */
package net.wazworld.vbe;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.wazworld.vbe.block.vbe_BlockDoubleSlab;
import net.wazworld.vbe.block.vbe_BlockFence;
import net.wazworld.vbe.block.vbe_BlockSlab;
import net.wazworld.vbe.block.vbe_BlockStairs;
import net.wazworld.vbe.block.vbe_BlockWall;
import net.wazworld.vbe.block.vbe_Fences;
import net.wazworld.vbe.block.vbe_Slabs;
import net.wazworld.vbe.block.vbe_Stairs;
import net.wazworld.vbe.block.vbe_Walls;
import net.wazworld.vbe.config.vbe_Configuration;
import net.wazworld.vbe.item.vbe_SlabsItems;

public class vbeColorManager {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void registerColorHandlers() {
        BlockColors blockColors = MINECRAFT.func_184125_al();
        ItemColors itemColors = MINECRAFT.getItemColors();
        vbeColorManager.registerBlockColorHandlers(blockColors);
        vbeColorManager.registerItemColorHandlers(blockColors, itemColors);
    }

    private static void registerBlockColorHandlers(BlockColors blockColors) {
        int i;
        IBlockColor grassColorHandler = new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, int tintIndex) {
                if (blockAccess != null && pos != null) {
                    return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
                }
                return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        };
        IBlockColor foliageColorHandler = new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, int tintIndex) {
                int metaType = 0;
                if (state.func_177230_c() instanceof vbe_BlockSlab) {
                    if (((vbe_BlockSlab)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockSlab)state.func_177230_c()).getMetaParent() == 2) {
                        metaType = 2;
                    }
                    if (((vbe_BlockSlab)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockSlab)state.func_177230_c()).getMetaParent() == 1) {
                        metaType = 1;
                    }
                } else if (state.func_177230_c() instanceof vbe_BlockDoubleSlab) {
                    if (((vbe_BlockDoubleSlab)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockDoubleSlab)state.func_177230_c()).getMetaParent() == 2) {
                        metaType = 2;
                    }
                    if (((vbe_BlockDoubleSlab)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockDoubleSlab)state.func_177230_c()).getMetaParent() == 1) {
                        metaType = 1;
                    }
                } else if (state.func_177230_c() instanceof vbe_BlockFence) {
                    if (((vbe_BlockFence)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockFence)state.func_177230_c()).getMetaParent() == 2) {
                        metaType = 2;
                    }
                    if (((vbe_BlockFence)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockFence)state.func_177230_c()).getMetaParent() == 1) {
                        metaType = 1;
                    }
                } else if (state.func_177230_c() instanceof vbe_BlockStairs) {
                    if (((vbe_BlockStairs)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockStairs)state.func_177230_c()).getMetaParent() == 2) {
                        metaType = 2;
                    }
                    if (((vbe_BlockStairs)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockStairs)state.func_177230_c()).getMetaParent() == 1) {
                        metaType = 1;
                    }
                } else if (state.func_177230_c() instanceof vbe_BlockWall) {
                    if (((vbe_BlockWall)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockWall)state.func_177230_c()).getMetaParent() == 2) {
                        metaType = 2;
                    }
                    if (((vbe_BlockWall)state.func_177230_c()).getBlockParent() == Blocks.field_150362_t && ((vbe_BlockWall)state.func_177230_c()).getMetaParent() == 1) {
                        metaType = 1;
                    }
                }
                if (metaType == 2) {
                    return ColorizerFoliage.func_77469_b();
                }
                if (metaType == 1) {
                    return ColorizerFoliage.func_77466_a();
                }
                if (blockAccess != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
        if (vbe_Configuration.includeSlabs && vbe_Configuration.slabGround) {
            blockColors.func_186722_a(grassColorHandler, new Block[]{vbe_Slabs.slabGrass});
            blockColors.func_186722_a(grassColorHandler, new Block[]{vbe_Slabs.slabDoubleGrass});
        }
        if (vbe_Configuration.includeStairs && vbe_Configuration.stairsGround) {
            blockColors.func_186722_a(grassColorHandler, new Block[]{vbe_Stairs.stairsGrass});
        }
        if (vbe_Configuration.includeSlabs && vbe_Configuration.slabLeaves) {
            for (i = 0; i < vbe_Slabs.blockList.size(); ++i) {
                if (vbe_Slabs.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                blockColors.func_186722_a(foliageColorHandler, new Block[]{(Block)vbe_Slabs.blockList.get(i)});
                blockColors.func_186722_a(foliageColorHandler, new Block[]{(Block)vbe_Slabs.blockListDouble.get(i)});
            }
        }
        if (vbe_Configuration.includeStairs && vbe_Configuration.stairsLeaves) {
            for (i = 0; i < vbe_Stairs.blockList.size(); ++i) {
                if (vbe_Stairs.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                blockColors.func_186722_a(foliageColorHandler, new Block[]{(Block)vbe_Stairs.blockList.get(i)});
            }
        }
        if (vbe_Configuration.includeFences && vbe_Configuration.fenceLeaves) {
            for (i = 0; i < vbe_Fences.blockList.size(); ++i) {
                if (vbe_Fences.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                blockColors.func_186722_a(foliageColorHandler, new Block[]{(Block)vbe_Fences.blockList.get(i)});
            }
        }
        if (vbe_Configuration.includeWalls && vbe_Configuration.wallLeaves) {
            for (i = 0; i < vbe_Walls.blockList.size(); ++i) {
                if (vbe_Walls.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                blockColors.func_186722_a(foliageColorHandler, new Block[]{(Block)vbe_Walls.blockList.get(i)});
            }
        }
    }

    private static void registerItemColorHandlers(final BlockColors blockColors, ItemColors itemColors) {
        int i;
        IItemColor itemBlockColorHandler = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!stack.func_190926_b()) {
                    try {
                        IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                        return blockColors.func_186724_a(state, null, null, tintIndex);
                    }
                    catch (ClassCastException e) {
                        return -1;
                    }
                }
                return -1;
            }
        };
        if (vbe_Configuration.includeSlabs && vbe_Configuration.slabGround) {
            itemColors.func_186730_a(itemBlockColorHandler, new Item[]{vbe_SlabsItems.slabGrass});
            itemColors.func_186731_a(itemBlockColorHandler, new Block[]{vbe_Slabs.slabGrass});
            itemColors.func_186731_a(itemBlockColorHandler, new Block[]{vbe_Slabs.slabDoubleGrass});
        }
        if (vbe_Configuration.includeStairs && vbe_Configuration.stairsGround) {
            itemColors.func_186731_a(itemBlockColorHandler, new Block[]{vbe_Stairs.stairsGrass});
        }
        if (vbe_Configuration.includeSlabs && vbe_Configuration.slabLeaves) {
            for (i = 0; i < vbe_Slabs.blockList.size(); ++i) {
                if (vbe_Slabs.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                itemColors.func_186730_a(itemBlockColorHandler, new Item[]{(Item)vbe_Slabs.itemList.get(i)});
                itemColors.func_186731_a(itemBlockColorHandler, new Block[]{(Block)vbe_Slabs.blockList.get(i)});
                itemColors.func_186731_a(itemBlockColorHandler, new Block[]{(Block)vbe_Slabs.blockListDouble.get(i)});
            }
        }
        if (vbe_Configuration.includeStairs && vbe_Configuration.stairsLeaves) {
            for (i = 0; i < vbe_Stairs.blockList.size(); ++i) {
                if (vbe_Stairs.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                itemColors.func_186731_a(itemBlockColorHandler, new Block[]{(Block)vbe_Stairs.blockList.get(i)});
            }
        }
        if (vbe_Configuration.includeFences && vbe_Configuration.fenceLeaves) {
            for (i = 0; i < vbe_Fences.blockList.size(); ++i) {
                if (vbe_Fences.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                itemColors.func_186731_a(itemBlockColorHandler, new Block[]{(Block)vbe_Fences.blockList.get(i)});
            }
        }
        if (vbe_Configuration.includeWalls && vbe_Configuration.wallLeaves) {
            for (i = 0; i < vbe_Walls.blockList.size(); ++i) {
                if (vbe_Walls.blockList.get(i).func_149688_o(null) != Material.field_151584_j) continue;
                itemColors.func_186731_a(itemBlockColorHandler, new Block[]{(Block)vbe_Walls.blockList.get(i)});
            }
        }
    }
}

