/*
 * Decompiled with CFR 0.152.
 */
package net.wazworld.vbe;

import java.util.Iterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.wazworld.vbe.block.vbe_BlockFence;
import net.wazworld.vbe.block.vbe_BlockFenceGate;
import net.wazworld.vbe.block.vbe_BlockSlab;
import net.wazworld.vbe.block.vbe_BlockStairs;
import net.wazworld.vbe.block.vbe_BlockWall;
import net.wazworld.vbe.block.vbe_Blocks;
import net.wazworld.vbe.block.vbe_Fences;
import net.wazworld.vbe.block.vbe_Gates;
import net.wazworld.vbe.block.vbe_Slabs;
import net.wazworld.vbe.block.vbe_Stairs;
import net.wazworld.vbe.block.vbe_Walls;
import net.wazworld.vbe.config.vbe_Configuration;
import net.wazworld.vbe.vbe;

public class vbeCraftingRecipes {
    public static void init() {
        Block quark_polished_stone;
        if (!vbe.quarkFound) {
            vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Blocks.blockPolishedStone, 2), " I", " I", Character.valueOf('I'), new ItemStack(Blocks.field_150348_b, 1, 0));
        }
        if (vbe.quarkFound && (quark_polished_stone = vbeCraftingRecipes.getQuarkPolishedStone()) != null) {
            String foundName;
            Object foundBlock;
            boolean bFound = false;
            if (vbe_Configuration.includeStairs) {
                System.out.println("Searching for polished stone stairs.");
                Iterator<vbe_BlockStairs> blockStairs = vbe_Stairs.blockList.iterator();
                bFound = false;
                while (blockStairs.hasNext() && !bFound) {
                    foundBlock = blockStairs.next();
                    foundName = foundBlock.getRegistryName().toString();
                    if (!Objects.equals(foundName, "vbe:stairspolishedstone")) continue;
                    bFound = true;
                    System.out.println("found vbe:stairspolishedstone, updating parents");
                    foundBlock.resetParent(quark_polished_stone, quark_polished_stone.func_176201_c(quark_polished_stone.func_176223_P()));
                }
                System.out.println("search complete");
            }
            if (vbe_Configuration.includeGates) {
                System.out.println("Searching for polished stone gate.");
                Iterator<vbe_BlockFenceGate> blockGate = vbe_Gates.blockList.iterator();
                bFound = false;
                while (blockGate.hasNext() && !bFound) {
                    foundBlock = blockGate.next();
                    foundName = foundBlock.getRegistryName().toString();
                    if (!Objects.equals(foundName, "vbe:gatepolishedstone")) continue;
                    bFound = true;
                    System.out.println("found vbe:gatepolishedstone, updating parents");
                    ((vbe_BlockFenceGate)((Object)foundBlock)).resetParent(quark_polished_stone, quark_polished_stone.func_176201_c(quark_polished_stone.func_176223_P()));
                }
                System.out.println("search complete");
            }
            if (vbe_Configuration.includeFences) {
                System.out.println("Searching for polished stone fence.");
                Iterator<vbe_BlockFence> blockFence = vbe_Fences.blockList.iterator();
                bFound = false;
                while (blockFence.hasNext() && !bFound) {
                    foundBlock = blockFence.next();
                    foundName = foundBlock.getRegistryName().toString();
                    if (!Objects.equals(foundName, "vbe:fencepolishedstone")) continue;
                    bFound = true;
                    System.out.println("found vbe:fencepolishedstone, updating parents");
                    ((vbe_BlockFence)((Object)foundBlock)).resetParent(quark_polished_stone, quark_polished_stone.func_176201_c(quark_polished_stone.func_176223_P()));
                }
                System.out.println("search complete");
            }
            if (vbe_Configuration.includeWalls) {
                System.out.println("Searching for polished stone wall.");
                Iterator<vbe_BlockWall> blockWall = vbe_Walls.blockList.iterator();
                bFound = false;
                while (blockWall.hasNext() && !bFound) {
                    foundBlock = blockWall.next();
                    foundName = foundBlock.getRegistryName().toString();
                    if (!Objects.equals(foundName, "vbe:wallpolishedstone")) continue;
                    bFound = true;
                    System.out.println("found vbe:wallpolishedstone, updating parents");
                    ((vbe_BlockWall)((Object)foundBlock)).resetParent(quark_polished_stone, quark_polished_stone.func_176201_c(quark_polished_stone.func_176223_P()));
                }
                System.out.println("search complete");
            }
        }
        if (vbe_Configuration.includeStairs) {
            vbeCraftingRecipes.addStairs();
        }
        if (vbe_Configuration.includeSlabs) {
            vbeCraftingRecipes.addSlabs();
        }
        if (vbe_Configuration.includeGates) {
            vbeCraftingRecipes.addGates();
        }
        if (vbe_Configuration.includeFences) {
            vbeCraftingRecipes.addFences();
        }
        if (vbe_Configuration.includeWalls) {
            vbeCraftingRecipes.addWalls();
        }
        if (vbe_Configuration.grassCrafting) {
            vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)Blocks.field_150349_c, 1), "G", "D", Character.valueOf('G'), Blocks.field_150329_H, Character.valueOf('D'), Blocks.field_150346_d);
            vbeCraftingRecipes.addShapedRecipe(new ItemStack(Blocks.field_185774_da, 1), "G", Character.valueOf('G'), Blocks.field_150349_c);
        }
        if (vbe_Configuration.grassSpecialCrafting) {
            if (vbe_Configuration.includeSlabs && vbe_Configuration.slabGround) {
                vbeCraftingRecipes.addShapedRecipe(new ItemStack(vbe_Slabs.slabGrass, 1), "G", "D", Character.valueOf('G'), Blocks.field_150329_H, Character.valueOf('D'), vbe_Slabs.slabDirt);
            }
            if (vbe_Configuration.includeStairs && vbe_Configuration.stairsGround) {
                vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Stairs.stairsGrass, 1), new Object[]{"G", "D", Character.valueOf('G'), Blocks.field_150329_H, Character.valueOf('D'), vbe_Stairs.stairsDirt});
            }
        }
        if (vbe_Configuration.mushroomCrafting) {
            vbeCraftingRecipes.addShapedRecipe(new ItemStack(Blocks.field_150420_aW), "II", "II", Character.valueOf('I'), Blocks.field_150338_P);
            vbeCraftingRecipes.addShapedRecipe(new ItemStack(Blocks.field_150419_aX), "II", "II", Character.valueOf('I'), Blocks.field_150337_Q);
        }
        if (vbe_Configuration.mushroomSpecialCrafting) {
            vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Blocks.blockMushroomStem, 2), " I", " I", Character.valueOf('I'), Blocks.field_150419_aX);
            vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Blocks.blockMushroomInside, 2), " I", " I", Character.valueOf('I'), Blocks.field_150420_aW);
        }
        if (vbe_Configuration.concreteCrafting) {
            vbeCraftingRecipes.addConcreteRecipe(15);
            vbeCraftingRecipes.addConcreteRecipe(11);
            vbeCraftingRecipes.addConcreteRecipe(12);
            vbeCraftingRecipes.addConcreteRecipe(9);
            vbeCraftingRecipes.addConcreteRecipe(7);
            vbeCraftingRecipes.addConcreteRecipe(13);
            vbeCraftingRecipes.addConcreteRecipe(3);
            vbeCraftingRecipes.addConcreteRecipe(5);
            vbeCraftingRecipes.addConcreteRecipe(2);
            vbeCraftingRecipes.addConcreteRecipe(1);
            vbeCraftingRecipes.addConcreteRecipe(6);
            vbeCraftingRecipes.addConcreteRecipe(10);
            vbeCraftingRecipes.addConcreteRecipe(14);
            vbeCraftingRecipes.addConcreteRecipe(8);
            vbeCraftingRecipes.addConcreteRecipe(0);
            vbeCraftingRecipes.addConcreteRecipe(4);
        }
        if (vbe_Configuration.overrideVanilla) {
            if (vbe_Configuration.includeWalls) {
                // empty if block
            }
            if (vbe_Configuration.includeSlabs && !vbe.quarkFound) {
                vbeCraftingRecipes.addVanillaShapedRecipe(new ResourceLocation("minecraft:stone_slab"), new ItemStack((Block)Blocks.field_150333_U, 6, 0), new Object[]{"   ", "   ", "III", Character.valueOf('I'), vbe_Blocks.blockPolishedStone});
            }
        }
    }

    private static Block getQuarkPolishedStone() {
        boolean bFound = false;
        Block blockPolishedStone = null;
        System.out.println("Quark found, searching for polished stone.");
        Iterator block = GameRegistry.findRegistry(Block.class).iterator();
        while (block.hasNext() && !bFound) {
            Block foundBlock = (Block)block.next();
            String foundName = foundBlock.getRegistryName().toString();
            if (!Objects.equals(foundName, "quark:polished_stone")) continue;
            System.out.println("found quark:polished_stone");
            bFound = true;
            blockPolishedStone = foundBlock;
        }
        System.out.println("search complete");
        return blockPolishedStone;
    }

    public static void addShapedRecipe(ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("vbe", output.func_77977_a().substring(5)), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)output, (Object[])params);
    }

    public static void addVanillaShapedRecipe(ResourceLocation resultItem, ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)resultItem, (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)output, (Object[])params);
    }

    public static void addShapelessRecipe(ItemStack output, Ingredient ... params) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("vbe", output.func_77977_a().substring(5)), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)output, (Ingredient[])params);
    }

    private static void addConcreteRecipe(int color) {
        vbeCraftingRecipes.addShapelessRecipe(new ItemStack(Blocks.field_192443_dR, 1, color), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151131_as}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_192444_dS, 1, color)}));
    }

    private static void addStairs() {
        for (int i = 0; i < vbe_Stairs.blockList.size(); ++i) {
            vbe_Stairs.blockList.get(i).initRecipe();
        }
        if (vbe_Configuration.stairsGround) {
            vbe_Stairs.stairsDirt.initRecipe();
            vbe_Stairs.stairsGrass.initRecipe();
            vbe_Stairs.stairsPath.initRecipe();
        }
    }

    private static void addSlabs() {
        for (int i = 0; i < vbe_Slabs.blockList.size(); ++i) {
            if (vbe_Slabs.blockList.get(i).func_149739_a() == "tile.slabStone") {
                if (vbe_Configuration.overrideVanilla) {
                    vbe_Slabs.blockList.get(i).initRecipe();
                    continue;
                }
                vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Slabs.blockList.get(i), 12), "III", "   ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150348_b, 1, 0));
                continue;
            }
            vbe_Slabs.blockList.get(i).initRecipe();
        }
        if (vbe_Configuration.slabGround) {
            ((vbe_BlockSlab)vbe_Slabs.slabDirt).initRecipe();
            ((vbe_BlockSlab)vbe_Slabs.slabGrass).initRecipe();
            ((vbe_BlockSlab)vbe_Slabs.slabPath).initRecipe();
        }
    }

    private static void addGates() {
        for (int i = 0; i < vbe_Gates.blockList.size(); ++i) {
            vbe_Gates.blockList.get(i).initRecipe();
        }
    }

    private static void addFences() {
        for (int i = 0; i < vbe_Fences.blockList.size(); ++i) {
            vbe_Fences.blockList.get(i).initRecipe();
        }
    }

    private static void addWalls() {
        for (int i = 0; i < vbe_Walls.blockList.size(); ++i) {
            if (vbe_Walls.blockList.get(i).func_149739_a() == "tile.wallNetherBrick") {
                if (vbe_Configuration.overrideVanilla) {
                    vbe_Walls.blockList.get(i).initRecipe();
                    continue;
                }
                vbeCraftingRecipes.addShapedRecipe(new ItemStack((Block)vbe_Walls.blockList.get(i), 6), "   ", "ISI", "ISI", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Blocks.field_150385_bj);
                continue;
            }
            vbe_Walls.blockList.get(i).initRecipe();
        }
    }

    public static void removeRecipes(RegistryEvent.Register<IRecipe> event) {
        if (vbe_Configuration.overrideVanilla) {
            if (vbe_Configuration.includeWalls) {
                vbeCraftingRecipes.replaceRecipe(event, Item.func_150898_a((Block)Blocks.field_150386_bk).getRegistryName(), new ItemStack(Blocks.field_150386_bk, 3), "   ", "ISI", "ISI", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('I'), Blocks.field_150385_bj);
            }
            if (vbe_Configuration.includeSlabs) {
                vbeCraftingRecipes.removeRecipe(event, new ItemStack((Block)Blocks.field_150333_U, 1, 0).func_77973_b().getRegistryName());
                if (vbe.quarkFound) {
                    // empty if block
                }
            }
        }
        if (vbe_Configuration.includeSlabs) {
            vbeCraftingRecipes.replaceRecipe(event, new ResourceLocation("minecraft:stone_brick_slab"), new ItemStack((Block)Blocks.field_150333_U, 6, 5), "   ", "   ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150417_aV, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, new ResourceLocation("minecraft:sandstone_slab"), new ItemStack((Block)Blocks.field_150333_U, 6, 1), "   ", "   ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150322_A, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, new ResourceLocation("minecraft:red_sandstone_slab"), new ItemStack((Block)Blocks.field_180389_cP, 6, 0), "   ", "   ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_180395_cM, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, new ResourceLocation("minecraft:quartz_slab"), new ItemStack((Block)Blocks.field_150333_U, 6, 7), "   ", "   ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150371_ca, 1, 0));
        }
        if (vbe_Configuration.includeStairs) {
            vbeCraftingRecipes.replaceRecipe(event, Item.func_150898_a((Block)Blocks.field_150390_bg).getRegistryName(), new ItemStack(Blocks.field_150390_bg, 4), "I  ", "II ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150417_aV, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, Item.func_150898_a((Block)Blocks.field_150372_bz).getRegistryName(), new ItemStack(Blocks.field_150372_bz, 4), "I  ", "II ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150322_A, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, Item.func_150898_a((Block)Blocks.field_180396_cN).getRegistryName(), new ItemStack(Blocks.field_180396_cN, 4), "I  ", "II ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_180395_cM, 1, 0));
            vbeCraftingRecipes.replaceRecipe(event, Item.func_150898_a((Block)Blocks.field_150370_cb).getRegistryName(), new ItemStack(Blocks.field_150370_cb, 4), "I  ", "II ", "III", Character.valueOf('I'), new ItemStack(Blocks.field_150371_ca, 1, 0));
        }
    }

    private static void removeRecipe(RegistryEvent.Register<IRecipe> event, ResourceLocation resultItem) {
        IForgeRegistryModifiable craftingRegistry = (IForgeRegistryModifiable)event.getRegistry();
        craftingRegistry.remove(resultItem);
    }

    private static void replaceRecipe(RegistryEvent.Register<IRecipe> event, ResourceLocation resultItem, ItemStack output, Object ... params) {
        IForgeRegistryModifiable craftingRegistry = (IForgeRegistryModifiable)event.getRegistry();
        craftingRegistry.remove(resultItem);
        vbeCraftingRecipes.addVanillaShapedRecipe(resultItem, output, params);
    }
}

