/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime;

import com.blamejared.waitingtime.api.Game;
import com.blamejared.waitingtime.games.pong.Pong;
import com.blamejared.waitingtime.util.SplashFontRenderer;
import com.blamejared.waitingtime.util.Texture;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class CustomThread {
    private static final Semaphore mutex = new Semaphore(1);
    private static final int TIMING_FRAME_COUNT = 200;
    private static final int TIMING_FRAME_THRESHOLD = 1000000000;
    private static boolean isDisplayVSyncForced = false;
    private static int backgroundColor = 0x111111;
    private static int angle = 0;
    private static boolean rotate = false;
    private static int logoOffset;
    private static Properties config;
    private static Texture logoTexture;
    private static Texture forgeTexture;
    public static final IResourcePack mcPack;
    public static final IResourcePack fmlPack;
    public static IResourcePack miscPack;
    private static final ResourceLocation logoLoc;
    private static final ResourceLocation forgeLoc;
    private static final ResourceLocation forgeFallbackLoc;
    public static SplashFontRenderer fontRenderer;
    private static final int barWidth = 400;
    private static final int barHeight = 20;
    private static final int textHeight2 = 20;
    private static final int barOffset = 55;
    private static float memoryColorPercent;
    private static long memoryColorChangeTime;
    private static int memoryGoodColor;
    private static int memoryWarnColor;
    private static int memoryLowColor;
    private static int barBackgroundColor;
    private static int barBorderColor;
    private static int barColor;
    public static int fps;
    public static int currentFPS;
    public static long lastFPS;
    private static int prevLeft;
    private static int prevRight;
    private static int prevBottom;
    private static int prevTop;
    public static Game game;
    private static boolean loadedReflection;
    private static Field lock;
    private static Field pause;
    private static Field done;

    public static long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public static Thread createNewThread() {
        File configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileReader r = new FileReader(configFile);){
            config.load(r);
        }
        catch (IOException e) {
            FMLLog.log.info("Could not load splash.properties, will create a default one");
        }
        boolean defaultEnabled = true;
        rotate = CustomThread.getBool("rotate", false);
        logoOffset = CustomThread.getInt("logoOffset", 0);
        barBorderColor = CustomThread.getHex("barBorder", 0xC0C0C0);
        barColor = CustomThread.getHex("bar", 13319477);
        barBackgroundColor = CustomThread.getHex("barBackground", 0xFFFFFF);
        memoryGoodColor = CustomThread.getHex("memoryGood", 7916340);
        memoryWarnColor = CustomThread.getHex("memoryWarn", 15132746);
        memoryLowColor = CustomThread.getHex("memoryLow", 14954287);
        File miscPackFile = new File(Minecraft.func_71410_x().field_71412_D, CustomThread.getString("resourcePackPath", "resources"));
        try (FileWriter w = new FileWriter(configFile);){
            config.store(w, "Splash screen properties");
        }
        catch (IOException e) {
            FMLLog.log.error("Could not save the splash.properties file", (Throwable)e);
        }
        miscPack = CustomThread.createResourcePack(miscPackFile);
        CustomThread.initReflection();
        return new Thread(new Runnable(){
            private long updateTiming;
            private long framecount;

            @Override
            public void run() {
                this.setGL();
                logoTexture = new Texture(logoLoc, null, false);
                forgeTexture = new Texture(forgeLoc, forgeFallbackLoc);
                GL11.glEnable((int)3553);
                fontRenderer = new SplashFontRenderer();
                GL11.glDisable((int)3553);
                int w = Display.getWidth();
                int h = Display.getHeight();
                int left = 320 - w / 2;
                int right = 320 + w / 2;
                int bottom = 240 + h / 2;
                int top = 240 - h / 2;
                game = new Pong();
                game.start(left, right, top, bottom);
                lastFPS = CustomThread.getTime();
                boolean repeatEventsEnabled = Keyboard.areRepeatEventsEnabled();
                Keyboard.enableRepeatEvents((boolean)true);
                while (!CustomThread.isDone()) {
                    CustomThread.updateFPS();
                    ++this.framecount;
                    ProgressManager.ProgressBar first = null;
                    ProgressManager.ProgressBar penult = null;
                    ProgressManager.ProgressBar last = null;
                    Iterator i = ProgressManager.barIterator();
                    while (i.hasNext()) {
                        if (first == null) {
                            first = (ProgressManager.ProgressBar)i.next();
                            continue;
                        }
                        penult = last;
                        last = (ProgressManager.ProgressBar)i.next();
                    }
                    GL11.glClear((int)16384);
                    w = Display.getWidth();
                    h = Display.getHeight();
                    GL11.glViewport((int)0, (int)0, (int)w, (int)h);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    left = 320 - w / 2;
                    right = 320 + w / 2;
                    bottom = 240 + h / 2;
                    top = 240 - h / 2;
                    if (prevLeft != left || prevRight != right || prevBottom != bottom || prevTop != top) {
                        game.resize(left, right, top, bottom);
                    }
                    prevLeft = left;
                    prevRight = right;
                    prevBottom = bottom;
                    prevTop = top;
                    GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)-1.0, (double)1.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    CustomThread.setColor(backgroundColor);
                    GL11.glEnable((int)3553);
                    logoTexture.bind();
                    GL11.glBegin((int)7);
                    logoTexture.texCoord(0, 0.0f, 0.0f);
                    GL11.glVertex2f((float)64.0f, (float)-16.0f);
                    logoTexture.texCoord(0, 0.0f, 1.0f);
                    GL11.glVertex2f((float)64.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 1.0f);
                    GL11.glVertex2f((float)576.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 0.0f);
                    GL11.glVertex2f((float)576.0f, (float)-16.0f);
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                    GL11.glTranslatef((float)120.0f, (float)(top + 10), (float)0.0f);
                    CustomThread.drawMemoryBar(255);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushAttrib((int)1048575);
                    if (first != null) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)120.0f, (float)310.0f, (float)0.0f);
                        CustomThread.drawBar(first);
                        if (penult != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            CustomThread.drawBar(penult);
                        }
                        if (last != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            CustomThread.drawBar(last);
                        }
                        GL11.glPopMatrix();
                    }
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    angle = angle + 1;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float fw = (float)forgeTexture.getWidth() / 2.0f;
                    float fh = (float)forgeTexture.getHeight() / 2.0f;
                    if (rotate) {
                        float sh = Math.max(fw, fh);
                        GL11.glTranslatef((float)((float)(320 + w / 2) - sh - (float)logoOffset), (float)((float)(240 + h / 2) - sh - (float)logoOffset), (float)0.0f);
                        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glTranslatef((float)((float)(320 + w / 2) - fw - (float)logoOffset), (float)((float)(240 + h / 2) - fh - (float)logoOffset), (float)0.0f);
                    }
                    int f = angle / 5 % forgeTexture.getFrames();
                    GL11.glEnable((int)3553);
                    forgeTexture.bind();
                    GL11.glBegin((int)7);
                    forgeTexture.texCoord(f, 0.0f, 0.0f);
                    GL11.glVertex2f((float)(-fw), (float)(-fh));
                    forgeTexture.texCoord(f, 0.0f, 1.0f);
                    GL11.glVertex2f((float)(-fw), (float)fh);
                    forgeTexture.texCoord(f, 1.0f, 1.0f);
                    GL11.glVertex2f((float)fw, (float)fh);
                    forgeTexture.texCoord(f, 1.0f, 0.0f);
                    GL11.glVertex2f((float)fw, (float)(-fh));
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    GL11.glPopMatrix();
                    game.update();
                    game.render();
                    CustomThread.drawString("FPS: " + currentFPS, left + 5, top + 5, 0xFFFFFF, 180);
                    mutex.acquireUninterruptibly();
                    long updateStart = System.nanoTime();
                    Display.update();
                    long dur = System.nanoTime() - updateStart;
                    if (this.framecount < 200L) {
                        this.updateTiming += dur;
                    }
                    mutex.release();
                    if (CustomThread.pause()) {
                        this.clearGL();
                        this.setGL();
                    }
                    if (this.framecount >= 200L && this.updateTiming > 1000000000L) {
                        if (isDisplayVSyncForced) continue;
                        isDisplayVSyncForced = true;
                        FMLLog.log.info("Using alternative sync timing : {} frames of Display.update took {} nanos", (Object)200, (Object)this.updateTiming);
                        continue;
                    }
                    if (this.framecount == 200L) {
                        FMLLog.log.info("Using sync timing. {} frames of Display.update took {} nanos", (Object)200, (Object)this.updateTiming);
                    }
                    Display.sync((int)100);
                }
                Keyboard.enableRepeatEvents((boolean)repeatEventsEnabled);
                this.clearGL();
            }

            private void setGL() {
                CustomThread.getLock().lock();
                try {
                    Display.getDrawable().makeCurrent();
                }
                catch (LWJGLException e) {
                    FMLLog.log.error("Error setting GL context:", (Throwable)e);
                    throw new RuntimeException(e);
                }
                GL11.glClearColor((float)((float)(backgroundColor >> 16 & 0xFF) / 255.0f), (float)((float)(backgroundColor >> 8 & 0xFF) / 255.0f), (float)((float)(backgroundColor & 0xFF) / 255.0f), (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }

            private void clearGL() {
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71443_c = Display.getWidth();
                mc.field_71440_d = Display.getHeight();
                mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2929);
                GL11.glDepthFunc((int)515);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                try {
                    Display.getDrawable().releaseContext();
                }
                catch (LWJGLException e) {
                    FMLLog.log.error("Error releasing GL context:", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    CustomThread.getLock().unlock();
                }
            }
        });
    }

    public static void drawLine(double x, double y, double x2, double y2, float red, float green, float blue, float alpha, float lineWidth) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glLineWidth((float)lineWidth);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        buff.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buff.func_181662_b(x2, y2, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tess.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawCircle(double radius) {
        GL11.glPushMatrix();
        GL11.glBegin((int)2);
        for (int i = 0; i < 360; ++i) {
            double degInRad = (double)i * 3.14159 / 180.0;
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)(Math.cos(degInRad) * radius), (double)(Math.sin(degInRad) * radius));
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private static void drawBar(ProgressManager.ProgressBar b) {
        GL11.glPushMatrix();
        CustomThread.setColor(0xFFFFFF);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b(b.getTitle() + " - " + b.getMessage(), 0, 0, 0xFFFFFF);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
        CustomThread.setColor(barBorderColor);
        CustomThread.drawBox(400.0, 20.0);
        CustomThread.setColor(barBackgroundColor);
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
        CustomThread.drawBox(398.0, 18.0);
        CustomThread.setColor(barColor);
        CustomThread.drawBox(398 * (b.getStep() + 1) / (b.getSteps() + 1), 18.0);
        String progress = "" + b.getStep() + "/" + b.getSteps();
        GL11.glTranslatef((float)(199.0f - (float)fontRenderer.func_78256_a(progress)), (float)2.0f, (float)0.0f);
        CustomThread.setColor(0);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b(progress, 0, 0, 0);
        GL11.glPopMatrix();
    }

    public static void updateFPS() {
        if (CustomThread.getTime() - lastFPS > 1000L) {
            currentFPS = fps;
            fps = 0;
            lastFPS += 1000L;
        }
        ++fps;
    }

    public static int bytesToMb(long bytes) {
        return (int)(bytes / 1024L / 1024L);
    }

    public static void drawString(String text, double x, double y, int color) {
        CustomThread.drawString(text, x, y, color, 255);
    }

    public static void drawString(String text, double x, double y, int color, int alpha) {
        GL11.glPushMatrix();
        CustomThread.setColor(color, alpha);
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b(text, 0, 0, 0);
        GL11.glDisable((int)3553);
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        GL11.glPopMatrix();
    }

    public static void setColor(int color, int alpha) {
        GL11.glColor4ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)), (byte)((byte)alpha));
    }

    public static void setColor(int color) {
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    public static void drawMemoryBar(int alpha) {
        int maxMemory = CustomThread.bytesToMb(Runtime.getRuntime().maxMemory());
        int totalMemory = CustomThread.bytesToMb(Runtime.getRuntime().totalMemory());
        int freeMemory = CustomThread.bytesToMb(Runtime.getRuntime().freeMemory());
        int usedMemory = totalMemory - freeMemory;
        float usedMemoryPercent = (float)usedMemory / (float)maxMemory;
        CustomThread.drawString("Memory Used / Total", 0.0, 0.0, 0xFFFFFF, 180);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
        CustomThread.setColor(barBorderColor, alpha);
        CustomThread.drawBox(400.0, 20.0);
        CustomThread.setColor(barBackgroundColor, alpha);
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
        CustomThread.drawBox(398.0, 18.0);
        long time = System.currentTimeMillis();
        if (usedMemoryPercent > memoryColorPercent || time - memoryColorChangeTime > 1000L) {
            memoryColorChangeTime = time;
            memoryColorPercent = usedMemoryPercent;
        }
        int memoryBarColor = memoryColorPercent < 0.75f ? memoryGoodColor : (memoryColorPercent < 0.85f ? memoryWarnColor : memoryLowColor);
        CustomThread.setColor(memoryLowColor, alpha);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(398 * totalMemory / maxMemory - 2), (float)0.0f, (float)0.0f);
        CustomThread.drawBox(2.0, 18.0);
        GL11.glPopMatrix();
        CustomThread.setColor(memoryBarColor, alpha);
        CustomThread.drawBox(398 * usedMemory / maxMemory, 18.0);
        String progress = CustomThread.getMemoryString(usedMemory) + " / " + CustomThread.getMemoryString(maxMemory);
        CustomThread.drawString(progress, 199.0f - (float)fontRenderer.func_78256_a(progress), 2.0, 0, alpha);
        GL11.glPopMatrix();
    }

    public static String getMemoryString(int memory) {
        return StringUtils.leftPad((String)Integer.toString(memory), (int)4, (char)' ') + " MB";
    }

    public static void drawBox(double w, double h) {
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)h);
        GL11.glVertex2d((double)w, (double)h);
        GL11.glVertex2d((double)w, (double)0.0);
        GL11.glEnd();
    }

    public static String getString(String name, String def) {
        String value = config.getProperty(name, def);
        config.setProperty(name, value);
        return value;
    }

    public static boolean getBool(String name, boolean def) {
        return Boolean.parseBoolean(CustomThread.getString(name, Boolean.toString(def)));
    }

    public static int getInt(String name, int def) {
        return Integer.decode(CustomThread.getString(name, Integer.toString(def)));
    }

    public static int getHex(String name, int def) {
        return Integer.decode(CustomThread.getString(name, "0x" + Integer.toString(def, 16).toUpperCase()));
    }

    private static void initReflection() {
        if (!loadedReflection) {
            Class<SplashProgress> progressClass = SplashProgress.class;
            try {
                lock = progressClass.getDeclaredField("lock");
                pause = progressClass.getDeclaredField("pause");
                done = progressClass.getDeclaredField("done");
                lock.setAccessible(true);
                pause.setAccessible(true);
                done.setAccessible(true);
                CustomThread.getProperties();
                CustomThread.setFakeTextures();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to setup custom launch screen", e);
            }
            loadedReflection = true;
        }
    }

    private static void setFakeTextures() throws NoSuchFieldException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<SplashProgress> progressClass = SplashProgress.class;
        CustomThread.setNullTexture(progressClass.getDeclaredField("fontTexture"));
        CustomThread.setNullTexture(progressClass.getDeclaredField("logoTexture"));
        CustomThread.setNullTexture(progressClass.getDeclaredField("forgeTexture"));
    }

    private static void setNullTexture(Field field) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        field.setAccessible(true);
        field.set(null, CustomThread.getNullTexture());
    }

    private static Object getNullTexture() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> textureClass = Class.forName("net.minecraftforge.fml.client.SplashProgress$Texture");
        Constructor<?> constructor = textureClass.getDeclaredConstructor(ResourceLocation.class, ResourceLocation.class);
        constructor.setAccessible(true);
        return constructor.newInstance(new ResourceLocation("fml:textures/gui/forge.png"), new ResourceLocation("fml:textures/gui/forge.png"));
    }

    private static void getProperties() throws NoSuchFieldException, IllegalAccessException {
        Class<SplashProgress> progressClass = SplashProgress.class;
    }

    private static Lock getLock() {
        try {
            return (Lock)lock.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get field", e);
        }
    }

    private static boolean isDone() {
        try {
            return (Boolean)done.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get field", e);
        }
    }

    private static boolean pause() {
        try {
            return (Boolean)pause.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get field", e);
        }
    }

    private static IResourcePack createResourcePack(File file) {
        if (file.isDirectory()) {
            return new FolderResourcePack(file);
        }
        return new FileResourcePack(file);
    }

    static {
        config = new Properties();
        mcPack = Minecraft.func_71410_x().field_110450_ap;
        fmlPack = CustomThread.createResourcePack(FMLSanityChecker.fmlLocation);
        logoLoc = new ResourceLocation("textures/gui/title/mojang.png");
        forgeLoc = new ResourceLocation(CustomThread.getString("forgeTexture", "fml:textures/gui/forge.png"));
        forgeFallbackLoc = new ResourceLocation("fml:textures/gui/forge.png");
        memoryGoodColor = 65280;
        memoryWarnColor = 0xFFFF00;
        memoryLowColor = 0xFF0000;
        barBackgroundColor = 0;
        barBorderColor = 0;
        loadedReflection = false;
    }
}

