/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime.api;

import java.util.Random;

public abstract class Game {
    protected double canvasLeft;
    protected double canvasRight;
    protected double canvasTop;
    protected double canvasBottom;
    protected double width;
    protected double height;
    protected double prevWidth;
    protected Random random;

    public void start(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        this.random = new Random();
        this.canvasLeft = canvasLeft;
        this.canvasRight = canvasRight;
        this.canvasTop = canvasTop;
        this.canvasBottom = canvasBottom;
        this.width = canvasRight - canvasLeft;
        this.height = canvasBottom - canvasTop;
        this.prevWidth = this.width;
    }

    public abstract void update();

    public abstract void render();

    public void resize(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        this.canvasLeft = canvasLeft;
        this.canvasRight = canvasRight;
        this.canvasTop = canvasTop;
        this.canvasBottom = canvasBottom;
        if (this.prevWidth != canvasRight - canvasLeft) {
            this.prevWidth = canvasRight - canvasLeft;
        }
        this.width = canvasRight - canvasLeft;
        this.height = canvasBottom - canvasTop;
    }

    public double getCanvasLeft() {
        return this.canvasLeft;
    }

    public void setCanvasLeft(double canvasLeft) {
        this.canvasLeft = canvasLeft;
    }

    public double getCanvasRight() {
        return this.canvasRight;
    }

    public void setCanvasRight(double canvasRight) {
        this.canvasRight = canvasRight;
    }

    public double getCanvasTop() {
        return this.canvasTop;
    }

    public void setCanvasTop(double canvasTop) {
        this.canvasTop = canvasTop;
    }

    public double getCanvasBottom() {
        return this.canvasBottom;
    }

    public void setCanvasBottom(double canvasBottom) {
        this.canvasBottom = canvasBottom;
    }

    public Random getRandom() {
        return this.random;
    }
}

