/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime.games.breakout;

import com.blamejared.waitingtime.CustomThread;
import com.blamejared.waitingtime.api.Game;
import com.blamejared.waitingtime.games.breakout.Brick;
import java.awt.MouseInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Breakout
extends Game {
    private double paddleX;
    private double paddleY;
    private double paddleWidth;
    private double paddleHeight;
    private double ballX;
    private double ballY;
    private double ballDiam;
    private double ballVelX;
    private double ballVelY;
    private double ballVelDefault;
    private boolean running;
    private List<Brick> bricks = new LinkedList<Brick>();
    private List<Brick> bricksToRemove = new LinkedList<Brick>();
    private double score;

    @Override
    public void start(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        this.random = new Random();
        this.paddleWidth = this.width / 4.0;
        this.paddleHeight = this.height / this.width * 20.0;
        this.paddleX = canvasLeft + this.width / 2.0 + this.paddleWidth;
        this.paddleY = canvasBottom - 40.0;
        this.ballX = canvasLeft + this.width / 2.0;
        this.ballY = canvasBottom - this.height / 3.0;
        this.ballDiam = 40.0;
        this.ballVelX = this.ballVelDefault = 2.0;
        this.ballVelY = this.ballVelDefault;
        if (this.random.nextBoolean()) {
            this.ballVelX = -this.ballVelDefault;
        }
        if (this.random.nextBoolean()) {
            this.ballVelY = -this.ballVelDefault;
        }
        this.running = true;
        this.bricksToRemove.clear();
        this.bricks.clear();
        this.score = 0.0;
        int x = 0;
        while ((double)x < this.width) {
            int y = 20;
            while ((double)y < 5.0 * (this.height / 10.0)) {
                this.bricks.add(new Brick(canvasLeft + (double)x, canvasTop + 20.0 + (double)y, this.width / 10.0, this.height / 10.0, this));
                y = (int)((double)y + this.height / 10.0);
            }
            x = (int)((double)x + this.width / 10.0);
        }
    }

    @Override
    public void resize(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        super.resize(canvasLeft, canvasRight, canvasTop, canvasBottom);
        this.start(canvasLeft, canvasRight, canvasTop, canvasBottom);
        this.ballVelDefault *= this.width / this.prevWidth;
    }

    @Override
    public void update() {
        int x = MouseInfo.getPointerInfo().getLocation().x;
        int y = MouseInfo.getPointerInfo().getLocation().y;
        if (this.running) {
            if (x > Display.getX() && x < Display.getX() + Display.getWidth()) {
                this.paddleX = this.canvasLeft + (double)(x - Display.getX()) - this.paddleWidth / 2.0;
            }
            if (this.paddleX < this.canvasLeft) {
                this.paddleX = this.canvasLeft;
            }
            if (this.paddleX + this.paddleWidth > this.canvasRight) {
                this.paddleX = this.canvasRight - this.paddleWidth;
            }
            if (this.isCollided()) {
                this.handleCollision();
            }
            this.ballX += this.ballVelX;
            this.ballY += this.ballVelY;
            if (this.ballY + this.ballDiam > this.paddleY && this.ballY + this.ballDiam < this.paddleY + this.paddleHeight && this.ballX + this.ballDiam > this.paddleX && this.ballX + this.ballDiam < this.paddleX + this.paddleWidth) {
                this.ballVelY = -this.ballVelDefault;
                this.ballY = this.paddleY - this.ballDiam;
            }
            if (!this.bricksToRemove.isEmpty()) {
                this.bricks.removeAll(this.bricksToRemove);
                this.bricksToRemove.clear();
            }
            if (this.bricks.isEmpty()) {
                int x1 = 0;
                while ((double)x1 < this.width) {
                    int y1 = 20;
                    while ((double)y1 < 5.0 * (this.height / 10.0)) {
                        this.bricks.add(new Brick(this.canvasLeft + (double)x1, this.canvasTop + 20.0 + (double)y1, this.width / 10.0, this.height / 10.0, this));
                        y1 = (int)((double)y1 + this.height / 10.0);
                    }
                    x1 = (int)((double)x1 + this.width / 10.0);
                }
            }
        } else if (this.canvasLeft + (double)x - (double)Display.getX() > this.canvasLeft && this.canvasLeft + (double)x - (double)Display.getX() < this.canvasLeft + 160.0 && this.canvasTop + (double)y - (double)Display.getY() > this.canvasTop + 80.0 + this.height / 2.0 - this.height / 6.0 / 2.0 && this.canvasTop + (double)y - (double)Display.getY() < this.canvasTop + 80.0 + this.height / 2.0 - this.height / 6.0 / 2.0 + 160.0) {
            this.start(this.canvasLeft, this.canvasRight, this.canvasTop, this.canvasBottom);
        }
    }

    public boolean isCollided() {
        boolean coll = false;
        for (Brick brick : this.bricks) {
            if (!brick.isCollided(this.ballX, this.ballY, this.ballDiam, this.ballDiam)) continue;
            coll = true;
        }
        if (this.ballX < this.canvasLeft || this.ballX + this.ballDiam > this.canvasRight || this.ballY < this.canvasTop || this.ballY + this.ballDiam > this.canvasBottom) {
            return true;
        }
        return coll;
    }

    public void handleCollision() {
        if (this.ballX < this.canvasLeft) {
            this.ballVelX = this.ballVelDefault;
            this.ballX = this.canvasLeft;
        }
        if (this.ballX + this.ballDiam > this.canvasRight) {
            this.ballVelX = -this.ballVelDefault;
            this.ballX = this.canvasRight - this.ballDiam;
        }
        if (this.ballY < this.canvasTop) {
            this.ballVelY = this.ballVelDefault;
            this.ballY = this.canvasTop;
        }
        if (this.ballY + this.ballDiam > this.canvasBottom) {
            this.running = false;
        }
        for (Brick brick : this.bricks) {
            if (!brick.isCollided(this.ballX, this.ballY, this.ballDiam, this.ballDiam)) continue;
            brick.collide(this.ballX, this.ballY, this.ballDiam, this.ballDiam);
        }
    }

    public void drawCircle(double radius) {
        GL11.glBegin((int)2);
        for (int i = 0; i < 360; ++i) {
            double degInRad = (double)i * 3.14159 / 180.0;
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)(Math.cos(degInRad) * radius), (double)(Math.sin(degInRad) * radius));
        }
        GL11.glEnd();
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)this.paddleX, (double)this.paddleY, (double)0.0);
        CustomThread.drawBox(this.paddleWidth, this.paddleHeight);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        CustomThread.drawString("Score: " + this.getScore(), this.canvasLeft + this.width / 2.0, this.canvasTop, 0);
        GL11.glPopMatrix();
        for (Brick brick : this.bricks) {
            GL11.glPushMatrix();
            GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)brick.getX(), (double)brick.getY(), (double)0.0);
            CustomThread.drawBox(brick.getWidth(), brick.getHeight());
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glTranslated((double)(brick.getX() + 1.0), (double)(brick.getY() + 1.0), (double)0.0);
            CustomThread.drawBox(brick.getWidth() - 2.0, brick.getHeight() - 2.0);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(this.ballX + this.ballDiam / 2.0), (double)(this.ballY + this.ballDiam / 2.0), (double)0.0);
        this.drawCircle(this.ballDiam / 2.0);
        GL11.glPopMatrix();
        if (!this.running) {
            GL11.glPushMatrix();
            CustomThread.drawString("GAME OVER", (float)(this.canvasLeft + this.width / 2.0) - (float)(CustomThread.fontRenderer.func_78256_a("GAME OVER") / 2), (float)(this.canvasTop + this.height / 2.0), 0xFF0000);
            CustomThread.drawString("MOVE MOUSE TO INSIDE SQUARE TO RESTART", (float)(this.canvasLeft + this.width / 2.0) - (float)(CustomThread.fontRenderer.func_78256_a("MOVE MOUSE TO INSIDE SQUARE TO RESTART") / 2), (float)(this.canvasTop + this.height / 2.0 + (double)CustomThread.fontRenderer.field_78288_b + 10.0), 0xFF0000);
            CustomThread.setColor(0);
            GL11.glTranslated((double)this.canvasLeft, (double)(this.canvasTop + 80.0 + this.height / 2.0 - this.height / 6.0 / 2.0), (double)0.0);
            CustomThread.drawBox(160.0, 160.0);
            GL11.glPopMatrix();
        }
    }

    public double getPaddleX() {
        return this.paddleX;
    }

    public void setPaddleX(double paddleX) {
        this.paddleX = paddleX;
    }

    public double getPaddleY() {
        return this.paddleY;
    }

    public void setPaddleY(double paddleY) {
        this.paddleY = paddleY;
    }

    public double getPaddleWidth() {
        return this.paddleWidth;
    }

    public void setPaddleWidth(double paddleWidth) {
        this.paddleWidth = paddleWidth;
    }

    public double getPaddleHeight() {
        return this.paddleHeight;
    }

    public void setPaddleHeight(double paddleHeight) {
        this.paddleHeight = paddleHeight;
    }

    public double getBallX() {
        return this.ballX;
    }

    public void setBallX(double ballX) {
        this.ballX = ballX;
    }

    public double getBallY() {
        return this.ballY;
    }

    public void setBallY(double ballY) {
        this.ballY = ballY;
    }

    public double getBallDiam() {
        return this.ballDiam;
    }

    public void setBallDiam(double ballDiam) {
        this.ballDiam = ballDiam;
    }

    public double getBallVelX() {
        return this.ballVelX;
    }

    public void setBallVelX(double ballVelX) {
        this.ballVelX = ballVelX;
    }

    public double getBallVelY() {
        return this.ballVelY;
    }

    public void setBallVelY(double ballVelY) {
        this.ballVelY = ballVelY;
    }

    public double getBallVelDefault() {
        return this.ballVelDefault;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public List<Brick> getBricks() {
        return this.bricks;
    }

    public void setBricks(List<Brick> bricks) {
        this.bricks = bricks;
    }

    public List<Brick> getBricksToRemove() {
        return this.bricksToRemove;
    }

    public void setBricksToRemove(List<Brick> bricksToRemove) {
        this.bricksToRemove = bricksToRemove;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }
}

