/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime.games.breakout;

import com.blamejared.waitingtime.games.breakout.Breakout;
import java.awt.Rectangle;

public class Brick {
    private double x;
    private double y;
    private double width;
    private double height;
    private Breakout game;

    public Brick(double x, double y, double width, double height, Breakout game) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.game = game;
    }

    public boolean isCollided(double x, double y, double width, double height) {
        Rectangle rect1 = new Rectangle((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        Rectangle rect2 = new Rectangle((int)x, (int)y, (int)width, (int)height);
        return rect1.intersects(rect2);
    }

    public void collide(double x, double y, double width, double height) {
        if (x > this.x && x < this.x + this.width) {
            double newVel = this.game.getBallVelX();
            double newX = this.x;
            if (newVel > 0.0) {
                newX += this.width;
                newVel = -this.game.getBallVelDefault();
            } else {
                newVel = this.game.getBallVelDefault();
            }
            this.game.setBallVelX(newVel);
            this.game.setBallX(newX);
        } else if (y > this.y && y < this.y + this.height) {
            double newVel = this.game.getBallVelY();
            double newY = this.y;
            if (newVel > 0.0) {
                newVel = -this.game.getBallVelDefault();
            } else {
                newY += this.height;
                newVel = this.game.getBallVelDefault();
            }
            this.game.setBallVelY(newVel);
            this.game.setBallY(newY);
        }
        this.game.setScore(this.game.getScore() + 50.0);
        this.game.getBricksToRemove().add(this);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Breakout getGame() {
        return this.game;
    }

    public void setGame(Breakout game) {
        this.game = game;
    }
}

