/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime.games.pong;

import com.blamejared.waitingtime.CustomThread;
import com.blamejared.waitingtime.api.Game;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Pong
extends Game {
    private double paddleX;
    private double paddleY;
    private double paddleAIX;
    private double paddleAIY;
    private double paddleWidth;
    private double paddleHeight;
    private double ballX;
    private double ballY;
    private double ballSize;
    private double ballVelX;
    private double ballVelY;
    private double ballVelDefault;
    private int scorePlayer = 0;
    private int scoreAI = 0;

    @Override
    public void start(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        super.start(canvasLeft, canvasRight, canvasTop, canvasBottom);
        this.paddleWidth = this.height / this.width * 20.0;
        this.paddleHeight = this.width / 10.0;
        this.paddleX = canvasRight - this.paddleWidth - 20.0;
        this.paddleY = canvasBottom - 40.0;
        this.paddleAIX = canvasLeft + 20.0;
        this.paddleAIY = canvasBottom - 40.0;
        this.ballX = canvasLeft + this.width / 2.0;
        this.ballY = canvasBottom - this.height / 3.0;
        this.ballSize = this.paddleHeight / 8.0;
        this.ballVelX = this.ballVelDefault = 2.0;
        this.ballVelY = this.ballVelDefault;
        if (this.random.nextBoolean()) {
            this.ballVelX = -this.ballVelDefault;
        }
        if (this.random.nextBoolean()) {
            this.ballVelY = -this.ballVelDefault;
        }
    }

    @Override
    public void resize(double canvasLeft, double canvasRight, double canvasTop, double canvasBottom) {
        super.resize(canvasLeft, canvasRight, canvasTop, canvasBottom);
        this.start(canvasLeft, canvasRight, canvasTop, canvasBottom);
        this.ballVelDefault *= this.width / this.prevWidth;
    }

    @Override
    public void update() {
        int x = MouseInfo.getPointerInfo().getLocation().x;
        int y = MouseInfo.getPointerInfo().getLocation().y;
        if (y > Display.getY() && y < Display.getY() + Display.getHeight()) {
            this.paddleY = this.canvasTop + (double)(y - Display.getY()) - this.paddleHeight;
        }
        if (this.paddleY < this.canvasTop) {
            this.paddleY = this.canvasTop;
        }
        if (this.paddleY + this.paddleHeight > this.canvasBottom) {
            this.paddleY = this.canvasBottom - this.paddleHeight;
        }
        int dir = 0;
        if (this.paddleAIY + this.paddleHeight / 2.0 > this.ballY + this.ballSize / 2.0) {
            dir = -2;
        } else if (this.paddleAIY + this.paddleHeight / 2.0 < this.ballY + this.ballSize / 2.0) {
            dir = 2;
        }
        this.paddleAIY += (double)dir;
        if (this.paddleAIY < this.canvasTop) {
            this.paddleAIY = this.canvasTop;
        }
        if (this.paddleAIY + this.paddleHeight > this.canvasBottom) {
            this.paddleAIY = this.canvasBottom - this.paddleHeight;
        }
        if (this.isCollided()) {
            this.handleCollision();
        }
        this.ballX += this.ballVelX;
        this.ballY += this.ballVelY;
        Rectangle paddleAI = new Rectangle((int)this.paddleAIX, (int)this.paddleAIY, (int)this.paddleWidth, (int)this.paddleHeight);
        Rectangle ball = new Rectangle((int)this.ballX, (int)this.ballY, (int)this.ballSize, (int)this.ballSize);
        Rectangle paddle = new Rectangle((int)this.paddleX, (int)this.paddleY, (int)this.paddleWidth, (int)this.paddleHeight);
        if (ball.intersects(paddle)) {
            this.ballVelX = -this.ballVelDefault - Math.random();
            this.ballX = this.paddleX - this.ballSize;
        }
        if (ball.intersects(paddleAI)) {
            this.ballVelX = this.ballVelDefault + Math.random();
            this.ballX = this.paddleAIX + this.paddleWidth;
        }
    }

    public boolean isCollided() {
        return this.ballX < this.canvasLeft || this.ballX + this.ballSize > this.canvasRight || this.ballY < this.canvasTop || this.ballY + this.ballSize > this.canvasBottom;
    }

    public void handleCollision() {
        if (this.ballX < this.canvasLeft) {
            this.ballX = this.canvasLeft + this.width / 2.0;
            this.ballY = this.canvasTop + this.height / 2.0;
            this.ballVelX = this.ballVelDefault + Math.random();
            ++this.scorePlayer;
        }
        if (this.ballX + this.ballSize > this.canvasRight) {
            this.ballX = this.canvasLeft + this.width / 2.0;
            this.ballY = this.canvasTop + this.height / 2.0;
            this.ballVelX = -this.ballVelDefault - Math.random();
            ++this.scoreAI;
        }
        if (this.ballY < this.canvasTop) {
            this.ballVelY = this.ballVelDefault + Math.random();
            this.ballY = this.canvasTop;
        }
        if (this.ballY + this.ballSize > this.canvasBottom) {
            this.ballVelY = -this.ballVelDefault - Math.random();
            this.ballY = this.canvasBottom - this.ballSize;
        }
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        CustomThread.setColor(0xAAAAAA);
        int counter = 0;
        int y = (int)this.canvasTop + 20;
        while ((double)y < this.height) {
            if (counter++ % 2 != 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(this.canvasLeft + this.width / 2.0 - 2.5), (double)y, (double)0.0);
                CustomThread.drawBox(5.0, 10.0);
                GL11.glPopMatrix();
            }
            y += 10;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        CustomThread.setColor(0xFFFFFF);
        GL11.glTranslated((double)this.paddleX, (double)this.paddleY, (double)0.0);
        CustomThread.drawBox(this.paddleWidth, this.paddleHeight);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        CustomThread.setColor(0xFFFFFF);
        GL11.glTranslated((double)this.paddleAIX, (double)this.paddleAIY, (double)0.0);
        CustomThread.drawBox(this.paddleWidth, this.paddleHeight);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        CustomThread.drawString("AI: " + this.scoreAI, this.canvasLeft + this.width / 4.0 - (double)CustomThread.fontRenderer.func_78256_a("AI: " + this.scoreAI), this.canvasBottom - (double)(CustomThread.fontRenderer.field_78288_b * 2), 0xFFFFFF);
        CustomThread.drawString("Player: " + this.scorePlayer, this.canvasRight - this.width / 4.0 - (double)CustomThread.fontRenderer.func_78256_a("Player: " + this.scoreAI), this.canvasBottom - (double)(CustomThread.fontRenderer.field_78288_b * 2), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        CustomThread.setColor(0xFFFFFF);
        GL11.glTranslated((double)this.ballX, (double)this.ballY, (double)0.0);
        CustomThread.drawBox(this.ballSize, this.ballSize);
        GL11.glPopMatrix();
    }

    public double getPaddleX() {
        return this.paddleX;
    }

    public void setPaddleX(double paddleX) {
        this.paddleX = paddleX;
    }

    public double getPaddleY() {
        return this.paddleY;
    }

    public void setPaddleY(double paddleY) {
        this.paddleY = paddleY;
    }

    public double getPaddleWidth() {
        return this.paddleWidth;
    }

    public void setPaddleWidth(double paddleWidth) {
        this.paddleWidth = paddleWidth;
    }

    public double getPaddleHeight() {
        return this.paddleHeight;
    }

    public void setPaddleHeight(double paddleHeight) {
        this.paddleHeight = paddleHeight;
    }

    public double getBallX() {
        return this.ballX;
    }

    public void setBallX(double ballX) {
        this.ballX = ballX;
    }

    public double getBallY() {
        return this.ballY;
    }

    public void setBallY(double ballY) {
        this.ballY = ballY;
    }

    public double getBallVelX() {
        return this.ballVelX;
    }

    public void setBallVelX(double ballVelX) {
        this.ballVelX = ballVelX;
    }

    public double getBallVelY() {
        return this.ballVelY;
    }

    public void setBallVelY(double ballVelY) {
        this.ballVelY = ballVelY;
    }

    public double getBallVelDefault() {
        return this.ballVelDefault;
    }
}

