/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.waitingtime.util;

import com.blamejared.waitingtime.CustomThread;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class Texture {
    private final ResourceLocation location;
    private final int name;
    private final int width;
    private final int height;
    private final int frames;
    private final int size;
    private static final IntBuffer buf = BufferUtils.createIntBuffer((int)0x400000);

    public Texture(ResourceLocation location, @Nullable ResourceLocation fallback) {
        this(location, fallback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Texture(ResourceLocation location, @Nullable ResourceLocation fallback, boolean allowRP) {
        InputStream s = null;
        try {
            this.location = location;
            s = Texture.open(location, fallback, allowRP);
            ImageInputStream stream = ImageIO.createImageInputStream(s);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new IOException("No suitable reader found for image" + location);
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            int frames = reader.getNumImages(true);
            BufferedImage[] images = new BufferedImage[frames];
            for (int i = 0; i < frames; ++i) {
                images[i] = reader.read(i);
            }
            reader.dispose();
            this.width = images[0].getWidth();
            int height = images[0].getHeight();
            if (height > this.width && height % this.width == 0) {
                frames = height / this.width;
                BufferedImage original = images[0];
                height = this.width;
                images = new BufferedImage[frames];
                for (int i = 0; i < frames; ++i) {
                    images[i] = original.getSubimage(0, i * height, this.width, height);
                }
            }
            this.frames = frames;
            this.height = height;
            int size = 1;
            while (size / this.width * (size / height) < frames) {
                size *= 2;
            }
            this.size = size;
            GL11.glEnable((int)3553);
            Class<CustomThread> i = CustomThread.class;
            synchronized (CustomThread.class) {
                this.name = GL11.glGenTextures();
                GL11.glBindTexture((int)3553, (int)this.name);
                // ** MonitorExit[i] (shouldn't be in output)
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)size, (int)size, (int)0, (int)32993, (int)33639, (IntBuffer)null);
                Texture.checkGLError("Texture creation");
                int i2 = 0;
                while (i2 * (size / this.width) < frames) {
                    for (int j = 0; i2 * (size / this.width) + j < frames && j < size / this.width; ++j) {
                        buf.clear();
                        BufferedImage image = images[i2 * (size / this.width) + j];
                        for (int k = 0; k < height; ++k) {
                            for (int l = 0; l < this.width; ++l) {
                                buf.put(image.getRGB(l, k));
                            }
                        }
                        buf.position(0).limit(this.width * height);
                        GL11.glTexSubImage2D((int)3553, (int)0, (int)(j * this.width), (int)(i2 * height), (int)this.width, (int)height, (int)32993, (int)33639, (IntBuffer)buf);
                        Texture.checkGLError("Texture uploading");
                    }
                    ++i2;
                }
                GL11.glBindTexture((int)3553, (int)0);
                GL11.glDisable((int)3553);
            }
        }
        catch (IOException e) {
            try {
                FMLLog.log.error("Error reading texture from file: {}", (Object)location, (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(s);
                throw throwable;
            }
        }
        {
            IOUtils.closeQuietly((InputStream)s);
            return;
        }
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public int getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getSize() {
        return this.size;
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.name);
    }

    public void delete() {
        GL11.glDeleteTextures((int)this.name);
    }

    public float getU(int frame, float u) {
        return (float)this.width * ((float)(frame % (this.size / this.width)) + u) / (float)this.size;
    }

    public float getV(int frame, float v) {
        return (float)this.height * ((float)(frame / (this.size / this.width)) + v) / (float)this.size;
    }

    public void texCoord(int frame, float u, float v) {
        GL11.glTexCoord2f((float)this.getU(frame, u), (float)this.getV(frame, v));
    }

    private static InputStream open(ResourceLocation loc, @Nullable ResourceLocation fallback, boolean allowResourcePack) throws IOException {
        if (!allowResourcePack) {
            return CustomThread.mcPack.func_110590_a(loc);
        }
        if (CustomThread.miscPack.func_110589_b(loc)) {
            return CustomThread.miscPack.func_110590_a(loc);
        }
        if (CustomThread.fmlPack.func_110589_b(loc)) {
            return CustomThread.fmlPack.func_110590_a(loc);
        }
        if (!CustomThread.mcPack.func_110589_b(loc) && fallback != null) {
            return Texture.open(fallback, null, true);
        }
        return CustomThread.mcPack.func_110590_a(loc);
    }

    public static void checkGLError(String where) {
        int err = GL11.glGetError();
        if (err != 0) {
            throw new IllegalStateException(where + ": " + GLU.gluErrorString((int)err));
        }
    }
}

