/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.albedo;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static boolean beacon;
    public static boolean beaconSegments;
    public static boolean furnace;
    public static boolean creeperCharged;
    public static boolean creeperExplosion;
    public static boolean burningEntities;
    public static String CATEGORY_TILES;
    public static String CATEGORY_ENTITY;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadCofiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("weissalbedo")) {
            ConfigurationHandler.loadCofiguration();
        }
    }

    private static void loadCofiguration() {
        beacon = configuration.getBoolean("bacon", CATEGORY_TILES, true, "Beacon");
        beaconSegments = configuration.getBoolean("baconSegments", CATEGORY_TILES, true, "Beacon Segments");
        furnace = configuration.getBoolean("furnace", CATEGORY_TILES, true, "Furnace");
        creeperCharged = configuration.getBoolean("creeperCharged", CATEGORY_ENTITY, true, "Charged Creeper");
        creeperExplosion = configuration.getBoolean("creeperExplosion", CATEGORY_ENTITY, true, "Creeper Explosion");
        burningEntities = configuration.getBoolean("burningEntities", CATEGORY_ENTITY, true, "Burning Entities");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        CATEGORY_TILES = "tiles";
        CATEGORY_ENTITY = "entity";
    }
}

