/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigManager {
    public static Configuration config;
    public static int maxLights;
    public static boolean enableLights;
    public static boolean eightBitNightmare;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        config.addCustomCategoryComment("light", "Settings related to lighting.");
        config.addCustomCategoryComment("misc", "Settings related to random effects.");
        maxLights = config.getInt("maxLights", "light", 10, 0, 100, "The maximum number of lights allowed to render in a scene. Lights are sorted nearest-first, so further-away lights will be culled after nearer lights.");
        enableLights = config.getBoolean("enableLights", "light", true, "Enables lighting in general.");
        eightBitNightmare = config.getBoolean("eightBitNightmare", "misc", false, "Enables retro mode.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("albedo")) {
            ConfigManager.load();
        }
    }
}

