/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo.lighting;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Light {
    public float x;
    public float y;
    public float z;
    public float r;
    public float g;
    public float b;
    public float a;
    public float radius;

    public Light(float x, float y, float z, float r, float g, float b, float a, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.radius = radius;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float x = Float.NaN;
        private float y = Float.NaN;
        private float z = Float.NaN;
        private float r = Float.NaN;
        private float g = Float.NaN;
        private float b = Float.NaN;
        private float a = Float.NaN;
        private float radius = Float.NaN;

        public Builder pos(BlockPos pos) {
            return this.pos((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        }

        public Builder pos(Vec3d pos) {
            return this.pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }

        public Builder pos(Entity e) {
            return this.pos(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        }

        public Builder pos(double x, double y, double z) {
            return this.pos((float)x, (float)y, (float)z);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder color(int c, boolean hasAlpha) {
            return this.color(this.extract(c, 2), this.extract(c, 1), this.extract(c, 0), hasAlpha ? this.extract(c, 3) : 1.0f);
        }

        private float extract(int i, int idx) {
            return (float)(i >> idx * 8 & 0xFF) / 255.0f;
        }

        public Builder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public Builder color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Light build() {
            if (Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z) && Float.isFinite(this.r) && Float.isFinite(this.g) && Float.isFinite(this.b) && Float.isFinite(this.a) && Float.isFinite(this.radius)) {
                return new Light(this.x, this.y, this.z, this.r, this.g, this.b, this.a, this.radius);
            }
            throw new IllegalArgumentException("Position, color, and radius must be set, and cannot be infinite");
        }
    }
}

