/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo.lighting;

import elucent.albedo.ConfigManager;
import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import elucent.albedo.util.ShaderUtil;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL20;

public class LightManager {
    public static ArrayList<Light> lights = new ArrayList();
    public static DistComparator distComparator = new DistComparator();

    public static void addLight(Light l) {
        if (l != null) {
            lights.add(l);
        }
    }

    public static void uploadLights() {
        int max = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)"lightCount");
        GL20.glUniform1i((int)max, (int)lights.size());
        for (int i = 0; i < Math.min(ConfigManager.maxLights, lights.size()); ++i) {
            if (i < lights.size()) {
                Light l = lights.get(i);
                int pos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].position"));
                GL20.glUniform3f((int)pos, (float)l.x, (float)l.y, (float)l.z);
                int color = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].color"));
                GL20.glUniform4f((int)color, (float)l.r, (float)l.g, (float)l.b, (float)l.a);
                int radius = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].radius"));
                GL20.glUniform1f((int)radius, (float)l.radius);
                continue;
            }
            int pos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].position"));
            GL20.glUniform3f((int)pos, (float)0.0f, (float)0.0f, (float)0.0f);
            int color = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].color"));
            GL20.glUniform4f((int)color, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            int radius = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)("lights[" + i + "].radius"));
            GL20.glUniform1f((int)radius, (float)0.0f);
        }
    }

    public static void update(World world) {
        GatherLightsEvent event = new GatherLightsEvent(lights);
        MinecraftForge.EVENT_BUS.post((Event)event);
        for (Entity e : world.func_72910_y()) {
            if (!(e instanceof ILightProvider)) continue;
            LightManager.addLight(((ILightProvider)e).provideLight());
        }
        for (TileEntity t : world.field_147482_g) {
            if (!(t instanceof ILightProvider)) continue;
            LightManager.addLight(((ILightProvider)t).provideLight());
        }
        lights.sort(distComparator);
    }

    public static void clear() {
        lights.clear();
    }

    public static double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static class DistComparator
    implements Comparator<Light> {
        @Override
        public int compare(Light arg0, Light arg1) {
            double dist1 = LightManager.distanceSquared(arg0.x, arg0.y, arg0.z, Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            double dist2 = LightManager.distanceSquared(arg1.x, arg1.y, arg1.z, Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            return Double.compare(dist1, dist2);
        }
    }
}

