/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo.util;

import elucent.albedo.ConfigManager;
import elucent.albedo.EventManager;
import elucent.albedo.event.RenderChunkUniformsEvent;
import elucent.albedo.item.ItemRenderRegistry;
import elucent.albedo.util.ShaderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL20;

public class RenderUtil {
    public static boolean lightingEnabled = false;
    public static int previousShader = 0;
    public static boolean enabledLast = false;
    public static ItemCameraTransforms.TransformType itemTransformType = ItemCameraTransforms.TransformType.NONE;

    public static void renderChunkUniforms(RenderChunk c) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderChunkUniformsEvent(c));
    }

    public static void enableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.enableLights) {
            if (enabledLast) {
                ShaderUtil.useProgram(previousShader);
                enabledLast = false;
            }
            if (ShaderUtil.currentProgram == ShaderUtil.entityLightProgram) {
                int lightPos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)"lightingEnabled");
                GL20.glUniform1i((int)lightPos, (int)1);
            }
        }
    }

    public static void disableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.enableLights) {
            if (ShaderUtil.currentProgram == ShaderUtil.entityLightProgram) {
                int lightPos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)"lightingEnabled");
                GL20.glUniform1i((int)lightPos, (int)0);
            }
            if (!enabledLast) {
                previousShader = ShaderUtil.currentProgram;
                enabledLast = true;
                ShaderUtil.useProgram(0);
            }
        }
    }

    public static void enableFogUniforms() {
        if (ShaderUtil.currentProgram == ShaderUtil.entityLightProgram && ConfigManager.enableLights) {
            int lightPos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)"fogIntensity");
            GL20.glUniform1f((int)lightPos, (float)(Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 0.015625f : 1.0f));
        }
    }

    public static void disableFogUniforms() {
        if (ShaderUtil.currentProgram == ShaderUtil.entityLightProgram && ConfigManager.enableLights) {
            int lightPos = GL20.glGetUniformLocation((int)ShaderUtil.currentProgram, (CharSequence)"fogIntensity");
            GL20.glUniform1f((int)lightPos, (float)0.0f);
        }
    }

    public static void setTransform(ItemCameraTransforms.TransformType t) {
        itemTransformType = t;
    }

    public static void setTransformGUI() {
        itemTransformType = ItemCameraTransforms.TransformType.GUI;
    }

    public static void renderItem(ItemStack stack) {
        if (ItemRenderRegistry.itemRenderMap.containsKey(stack.func_77973_b())) {
            ItemRenderRegistry.itemRenderMap.get(stack.func_77973_b()).render(stack, itemTransformType);
        }
    }
}

