/*
 * Decompiled with CFR 0.152.
 */
package com.locydragon.abf.api;

import com.locydragon.abf.AudioBuffer;
import com.locydragon.abf.AudioInput;
import com.locydragon.abf.QueueJob;
import com.locydragon.abf.listener.core.LoopThread;
import com.locydragon.abf.listener.core.PlayerLoopThreadAche;
import com.locydragon.abf.util.AudioReaderUtil;
import com.locydragon.abf.util.NetworkHelper;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AudioBufferAPI {
    private static Integer warningTimes = 5;
    private static Executor pool = Executors.newCachedThreadPool();

    public static boolean playFor(Player who, String musicName) {
        return AudioBufferAPI.playForByParam(who, AudioBuffer.config.getString("MusicList." + musicName + ".param", null));
    }

    public static boolean playForByParam(Player who, String param) {
        if (param == null) {
            return false;
        }
        if (param.startsWith("[Net]")) {
            pool.execute(() -> {
                String message = AudioBufferAPI.realURL(param.replace("[Net]", ""));
                who.sendPluginMessage((Plugin)AudioBuffer.buffer, "AudioBuffer", ("[Net]" + message).getBytes());
            });
            return true;
        }
        if (param.startsWith("[Local]")) {
            QueueJob job = new QueueJob();
            QueueJob.nowID.add(new BigInteger("1"));
            job.queueId = QueueJob.nowID.toString();
            job.fileName = param.replace("[Local]", "");
            AudioInput.jobQueue.add(job);
            String outputMsg = "[Has]" + job.queueId + "*" + job.fileName;
            who.sendPluginMessage((Plugin)AudioBuffer.buffer, "AudioBuffer", outputMsg.getBytes());
            return true;
        }
        return false;
    }

    public static void stopPlaying(Player who) {
        if (PlayerLoopThreadAche.loopThreadAche.get(who.getName()) != null) {
            LoopThread thread = PlayerLoopThreadAche.loopThreadAche.get(who.getName());
            thread.stopSafely();
            PlayerLoopThreadAche.loopThreadAche.remove(who.getName());
        }
        who.sendPluginMessage((Plugin)AudioBuffer.buffer, "AudioBuffer", "[Stop]".getBytes());
    }

    public static void setVolume(Player who, float volume) {
        String output = "[Volume]" + volume;
        who.sendPluginMessage((Plugin)AudioBuffer.buffer, "AudioBuffer", output.getBytes());
    }

    private static int getAudioLengthByParam(String param) {
        if (param.startsWith("[Local]")) {
            String message = param.replace("[Local]", "");
            File audioFile = new File(".//plugins//AudioBuffer//Music//" + message);
            return AudioReaderUtil.getAudioPlayTime(audioFile.getAbsolutePath());
        }
        if (param.startsWith("[Net]")) {
            String message = AudioBufferAPI.realURL(param.replace("[Net]", ""));
            String downloadCacheName = new Random().nextInt(Integer.MAX_VALUE) + ".mp3";
            NetworkHelper.downloadHttpUrl(message, ".//plugins//AudioBuffer//Music//Download//", downloadCacheName);
            File downloadedFile = new File(".//plugins//AudioBuffer//Music//Download//" + downloadCacheName);
            int audioTime = AudioReaderUtil.getAudioPlayTime(downloadedFile.getAbsolutePath());
            if (!AudioBufferAPI.forceDelete(downloadedFile)) {
                downloadedFile.delete();
            }
            return audioTime;
        }
        return -1;
    }

    private static boolean forceDelete(File file) {
        boolean result = file.delete();
        int tryCount = 0;
        while (!result && tryCount++ < 10) {
            System.gc();
            result = file.delete();
        }
        return result;
    }

    public static boolean loopPlayer(Player who, String musicName) {
        if (PlayerLoopThreadAche.loopThreadAche.get(who.getName()) != null) {
            LoopThread thread = PlayerLoopThreadAche.loopThreadAche.get(who.getName());
            thread.stopSafely();
            PlayerLoopThreadAche.loopThreadAche.remove(who.getName());
            AudioBufferAPI.stopPlaying(who);
        }
        LoopThread targetThread = new LoopThread(musicName, AudioBufferAPI.getAudioLengthByParamQuickly(AudioBuffer.config.getString("MusicList." + musicName + ".param", null)), who);
        targetThread.start();
        PlayerLoopThreadAche.loopThreadAche.put(who.getName(), targetThread);
        return true;
    }

    public static int getAudioLengthByParamQuickly(String param) {
        int cacheParam = AudioBuffer.save.getInt(param, -1);
        if (cacheParam != -1) {
            return cacheParam;
        }
        int newAudioLength = AudioBufferAPI.getAudioLengthByParam(param);
        AudioBuffer.save.set(param, (Object)newAudioLength);
        try {
            AudioBuffer.save.save(".//plugins//AudioBuffer//Cache//Cache.abf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newAudioLength;
    }

    private static String realURL(String path) {
        URLConnection connection = null;
        try {
            String urlNameString = path;
            URL realUrl = new URL(urlNameString);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            connection.getContent();
            return connection.getURL().toString();
        }
        catch (IOException exc) {
            if (connection == null) {
                exc.printStackTrace();
                return null;
            }
            if (warningTimes > 0) {
                Integer n = warningTimes;
                Integer n2 = warningTimes = Integer.valueOf(warningTimes - 1);
                AudioBuffer.buffer.getLogger().warning("> \u8b66\u544a: \u7f51\u9875\u8bf7\u6c42\u53cd\u9988\u51fa\u9519.\u6211\u4eec\u81ea\u52a8\u4fee\u590d\u4e86\u8fd9\u4e2a\u95ee\u9898.\u5982\u679c\u53cd\u590d\u51fa\u73b0\u8fd9\u4e2a\u63d0\u9192,\u8bf7\u8054\u7cfb\u4f5c\u8005.");
            }
            return connection.getURL().toString();
        }
    }

    public static boolean hasMusic(String musicName) {
        return AudioBuffer.config.getString("MusicList." + musicName + ".param", null) != null;
    }
}

