/*
 * Decompiled with CFR 0.152.
 */
package com.locydragon.abf.commands;

import com.locydragon.abf.AudioBuffer;
import com.locydragon.abf.api.AudioBufferAPI;
import com.locydragon.abf.listener.WorldChangeListener;
import com.locydragon.abf.listener.core.PlayerLoopThreadAche;
import com.locydragon.abf.util.NpcUtils;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AudioCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (!sender.hasPermission("AudioBuffer.use")) {
            sender.sendMessage(ChatColor.RED + "\u4f60\u6ca1\u6709\u6743\u9650.");
            return false;
        }
        if (args.length <= 0) {
            sender.sendMessage(ChatColor.RED + "\u53c2\u6570\u4e0d\u8db3.");
            return false;
        }
        if (args[0].equalsIgnoreCase("play")) {
            if (args.length == 3) {
                String playerName = args[1];
                String musicName = args[2];
                Player target = Bukkit.getPlayer((String)playerName);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                    return false;
                }
                if (!AudioBufferAPI.playFor(target, musicName)) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u97f3\u4e50\u540d\u79f0\u4e0d\u5b58\u5728\u6216\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303!");
                    return false;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf play [\u73a9\u5bb6\u540d\u5b57] [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u6765\u4e3a\u67d0\u4e2a\u73a9\u5bb6\u64ad\u653e\u4e00\u4e2a\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("volume")) {
            if (args.length == 3) {
                String playerName = args[1];
                String volume = args[2];
                Player target = Bukkit.getPlayer((String)playerName);
                if (!AudioCommand.isNumber(volume)) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u8f93\u5165\u7684\u5185\u5bb9\u4e0d\u662f\u4e00\u4e2a\u6570\u5b57.");
                    return false;
                }
                if (PlayerLoopThreadAche.loopThreadAche.containsKey(playerName)) {
                    sender.sendMessage(ChatColor.RED + "\u5faa\u73af\u64ad\u653e\u65f6\u65e0\u6cd5\u6539\u53d8\u97f3\u91cf.");
                    return false;
                }
                AudioBufferAPI.stopPlaying(target);
                AudioBufferAPI.setVolume(target, Float.valueOf(volume).floatValue());
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf volume [\u73a9\u5bb6\u540d\u5b57] [\u97f3\u91cf] \u2014\u2014\u4e3a\u67d0\u4e2a\u73a9\u5bb6\u8c03\u8282\u97f3\u91cf.");
            }
        } else if (args[0].equalsIgnoreCase("stop")) {
            if (args.length == 2) {
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                    return false;
                }
                AudioBufferAPI.stopPlaying(target);
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf stop [\u73a9\u5bb6\u540d\u5b57] \u2014\u2014\u6765\u4e3a\u67d0\u4e2a\u73a9\u5bb6\u505c\u6b62\u64ad\u653e\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("AudioBuffer.admin")) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                AudioBufferAPI.stopPlaying(online);
            }
            AudioBuffer.reloadConfiguration();
            sender.sendMessage(ChatColor.GREEN + "\u91cd\u8f7d\u63d2\u4ef6\u6210\u529f!");
        } else if (args[0].equalsIgnoreCase("stopAll") && sender.hasPermission("AudioBuffer.admin")) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                AudioBufferAPI.stopPlaying(online);
            }
        } else if (args[0].equalsIgnoreCase("playAll")) {
            if (args.length == 2) {
                String musicName = args[1];
                for (Player online : Bukkit.getOnlinePlayers()) {
                    AudioBufferAPI.playFor(online, musicName);
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf playAll [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u6765\u4e3a\u6240\u6709\u73a9\u5bb6\u64ad\u653e\u4e00\u4e2a\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("playInWorld")) {
            if (args.length == 3) {
                World targetWorld = Bukkit.getWorld((String)args[1]);
                if (targetWorld == null) {
                    sender.sendMessage(ChatColor.RED + "\u4e16\u754c\u4e0d\u5b58\u5728!");
                    return false;
                }
                for (Player inWorld : targetWorld.getPlayers()) {
                    AudioBufferAPI.stopPlaying(inWorld);
                    AudioBufferAPI.playFor(inWorld, args[2]);
                }
                WorldChangeListener.playInWorld.put(targetWorld.getName(), args[2]);
                AudioBuffer.worldMusic.set(targetWorld.getName(), (Object)args[2]);
                try {
                    AudioBuffer.worldMusic.save(".//plugins//AudioBuffer//Cache//WorldMusic.abf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf playInWorld [\u4e16\u754c\u540d\u79f0] [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u5728\u4e00\u4e2a\u4e16\u754c\u91cc\u64ad\u653e\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("stopInWorld")) {
            if (args.length == 2) {
                String worldName = args[1];
                World targetWorld = Bukkit.getWorld((String)worldName);
                if (targetWorld == null) {
                    sender.sendMessage(ChatColor.RED + "\u4e16\u754c\u4e0d\u5b58\u5728!");
                    return false;
                }
                for (Player inWorld : targetWorld.getPlayers()) {
                    AudioBufferAPI.stopPlaying(inWorld);
                }
                WorldChangeListener.playInWorld.remove(worldName);
                AudioBuffer.worldMusic.set(targetWorld.getName(), null);
                try {
                    AudioBuffer.worldMusic.save(".//plugins//AudioBuffer//Cache//WorldMusic.abf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf stopInWorld [\u4e16\u754c\u540d\u79f0] \u2014\u2014\u5728\u4e00\u4e2a\u4e16\u754c\u91cc\u505c\u6b62\u64ad\u653e\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("nearBy")) {
            if (args.length == 6) {
                String who = args[1];
                String musicType = args[2];
                if (AudioCommand.isInt(args[3]) && AudioCommand.isInt(args[4]) && AudioCommand.isInt(args[5])) {
                    int x = Integer.valueOf(args[3]);
                    int y = Integer.valueOf(args[4]);
                    int z = Integer.valueOf(args[5]);
                    Player target = Bukkit.getPlayer((String)who);
                    if (target == null) {
                        sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                        return false;
                    }
                    for (Entity entity : target.getNearbyEntities((double)x, (double)y, (double)z)) {
                        if (!(entity instanceof Player) || entity.equals(target) || NpcUtils.isNPC(entity)) continue;
                        Player instance = (Player)entity;
                        AudioBufferAPI.playFor(instance, musicType);
                    }
                    AudioBufferAPI.playFor(target, musicType);
                } else {
                    sender.sendMessage(ChatColor.RED + "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6570\u5b57.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf nearBy [\u73a9\u5bb6\u540d] [\u97f3\u4e50\u540d] [x] [y] [z] \u2014\u2014\u4e00\u4e00\u4e2a\u73a9\u5bb6\u4e3a\u7acb\u4f53\u56fe\u5f62\u7684\u4e2d\u5fc3,xyz\u4e3a\u957f\u5bbd\u9ad8,\u5728\u8fd9\u4e2a\u8303\u56f4\u5185\u7684\u73a9\u5bb6\u90fd\u4f1a\u64ad\u653e\u97f3\u6548(\u5305\u62ec\u8be5\u73a9\u5bb6)");
            }
        } else if (args[0].equalsIgnoreCase("playSelf")) {
            if (args.length == 2) {
                Player target = (Player)sender;
                AudioBufferAPI.playFor(target, args[1]);
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf playSelf [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u7ed9\u81ea\u5df1\u64ad\u653e\u4e00\u4e2a\u97f3\u4e50");
            }
        } else if (args[0].equalsIgnoreCase("cleanCache") && sender.hasPermission("AudioBuffer.admin")) {
            if (args.length == 2) {
                String musicName = args[1];
                String param = AudioBuffer.config.getString("MusicList." + musicName + ".param", null);
                AudioBuffer.save.set(param, (Object)-1);
                sender.sendMessage(ChatColor.GREEN + "\u6e05\u9664\u7f13\u5b58\u6210\u529f\u4e86.");
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf cleanCache [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u6e05\u7406\u4e00\u4e2a\u97f3\u4e50\u7684\u7f13\u5b58");
            }
        } else if (args[0].equalsIgnoreCase("loopFor")) {
            if (args.length == 3) {
                String playerName = args[1];
                String musicName = args[2];
                Player target = Bukkit.getPlayer((String)playerName);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                    return false;
                }
                AudioBufferAPI.loopPlayer(target, musicName);
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf loopFor [\u73a9\u5bb6\u540d\u79f0] [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u4e3a\u4e00\u4e2a\u73a9\u5bb6\u5faa\u73af\u64ad\u653e\u97f3\u4e50.");
            }
        } else if (args[0].equalsIgnoreCase("stopAndPlay")) {
            if (args.length == 3) {
                String playerName = args[1];
                String musicName = args[2];
                Player target = Bukkit.getPlayer((String)playerName);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                    return false;
                }
                AudioBufferAPI.stopPlaying(target);
                if (!AudioBufferAPI.playFor(target, musicName)) {
                    sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u97f3\u4e50\u540d\u79f0\u4e0d\u5b58\u5728\u6216\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303!");
                    return false;
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf stopAndPlay [\u73a9\u5bb6\u540d\u5b57] [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u6765\u4e3a\u67d0\u4e2a\u73a9\u5bb6\u64ad\u653e(\u5148\u6682\u505c)\u4e00\u4e2a\u97f3\u4e50!");
            }
        } else if (args[0].equalsIgnoreCase("stopAndPlaySelf")) {
            if (args.length == 2) {
                Player target = (Player)sender;
                AudioBufferAPI.stopPlaying(target);
                AudioBufferAPI.playFor(target, args[1]);
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf stopAndPlaySelf [\u97f3\u4e50\u540d\u79f0] \u2014\u2014\u7ed9\u81ea\u5df1\u64ad\u653e(\u505c\u4e0b\u540e)\u4e00\u4e2a\u97f3\u4e50");
            }
        } else if (args[0].equalsIgnoreCase("stopNearBy")) {
            if (args.length == 5) {
                String who = args[1];
                if (AudioCommand.isInt(args[2]) && AudioCommand.isInt(args[3]) && AudioCommand.isInt(args[4])) {
                    int x = Integer.valueOf(args[2]);
                    int y = Integer.valueOf(args[3]);
                    int z = Integer.valueOf(args[4]);
                    Player target = Bukkit.getPlayer((String)who);
                    if (target == null) {
                        sender.sendMessage(ChatColor.RED + "\u4f60\u6307\u5b9a\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728!");
                        return false;
                    }
                    for (Entity entity : target.getNearbyEntities((double)x, (double)y, (double)z)) {
                        if (!(entity instanceof Player) || entity.equals(target) || NpcUtils.isNPC(entity)) continue;
                        Player instance = (Player)entity;
                        AudioBufferAPI.stopPlaying(instance);
                    }
                    AudioBufferAPI.stopPlaying(target);
                } else {
                    sender.sendMessage(ChatColor.RED + "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6570\u5b57.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "\u8bf7\u4f7f\u7528/abf stopNearBy [\u73a9\u5bb6\u540d] [x] [y] [z] \u2014\u2014\u4e00\u4e00\u4e2a\u73a9\u5bb6\u4e3a\u7acb\u4f53\u56fe\u5f62\u7684\u4e2d\u5fc3,xyz\u4e3a\u957f\u5bbd\u9ad8,\u5728\u8fd9\u4e2a\u8303\u56f4\u5185\u7684\u73a9\u5bb6\u90fd\u4f1a\u64ad\u653e\u97f3\u6548(\u5305\u62ec\u8be5\u73a9\u5bb6)");
            }
        }
        return false;
    }

    public static boolean isNumber(String number) {
        try {
            Float.valueOf(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInt(String number) {
        try {
            Integer.valueOf(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

