/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.api;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.ZMusicBukkit;
import cn.iqianye.mc.zmusic.api.Version;
import cn.iqianye.mc.zmusic.config.Config;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.v1_12_R1.Advancement;
import net.minecraft.server.v1_13_R2.Advancement;
import net.minecraft.server.v1_14_R1.Advancement;
import net.minecraft.server.v1_14_R1.ChatDeserializer;
import net.minecraft.server.v1_15_R1.Advancement;
import net.minecraft.server.v1_16_R1.Advancement;
import net.minecraft.server.v1_16_R1.Advancements;
import net.minecraft.server.v1_16_R2.Advancement;
import net.minecraft.server.v1_16_R2.AdvancementDataWorld;
import net.minecraft.server.v1_16_R2.DedicatedServer;
import net.minecraft.server.v1_16_R3.Advancement;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancementAPI {
    private NamespacedKey id;
    private String icon;
    private String title;
    private String description;
    private String frame = "task";
    private boolean announce = false;
    private boolean toast = true;
    private JavaPlugin pl;
    private String[] icons;
    private String ver = Bukkit.getServer().getClass().getPackage().getName().split("org.bukkit.craftbukkit.v")[1];

    public AdvancementAPI(String title) {
        this(new NamespacedKey((Plugin)ZMusicBukkit.plugin, String.valueOf(System.currentTimeMillis())), title);
    }

    public AdvancementAPI(NamespacedKey id, String title) {
        ZMusic.log.sendDebugMessage("[\u8fdb\u5ea6] NMS\u7248\u672c: " + this.ver);
        Version version = new Version();
        this.icons = version.isHigherThan("1.12") ? new String[]{"minecraft:music_disc_13", "minecraft:music_disc_cat", "minecraft:music_disc_blocks", "minecraft:music_disc_chirp", "minecraft:music_disc_far", "minecraft:music_disc_mall", "minecraft:music_disc_mellohi", "minecraft:music_disc_strad", "minecraft:music_disc_ward", "minecraft:music_disc_wait"} : new String[]{"minecraft:record_13", "minecraft:record_cat", "minecraft:record_blocks", "minecraft:record_chirp", "minecraft:record_far", "minecraft:record_mall", "minecraft:record_mellohi", "minecraft:record_strad", "minecraft:record_ward", "minecraft:record_wait"};
        Random random = new Random();
        int r = random.nextInt(this.icons.length);
        this.icon = this.icons[r];
        if (Config.debug) {
            ZMusic.log.sendDebugMessage("[\u8fdb\u5ea6] \u968f\u673a\u56fe\u6807: " + this.icon);
        }
        this.id = id;
        this.title = title;
        this.description = "Zmusic \u4e13\u7528\u6210\u5c31";
        this.pl = ZMusicBukkit.plugin;
    }

    public AdvancementAPI(NamespacedKey id, String title, String frame) {
        ZMusic.log.sendDebugMessage("[\u8fdb\u5ea6] NMS\u7248\u672c: " + this.ver);
        Version version = new Version();
        this.icons = version.isHigherThan("1.12") ? new String[]{"minecraft:music_disc_13", "minecraft:music_disc_cat", "minecraft:music_disc_blocks", "minecraft:music_disc_chirp", "minecraft:music_disc_far", "minecraft:music_disc_mall", "minecraft:music_disc_mellohi", "minecraft:music_disc_strad", "minecraft:music_disc_ward", "minecraft:music_disc_wait"} : new String[]{"minecraft:record_13", "minecraft:record_cat", "minecraft:record_blocks", "minecraft:record_chirp", "minecraft:record_far", "minecraft:record_mall", "minecraft:record_mellohi", "minecraft:record_strad", "minecraft:record_ward", "minecraft:record_wait"};
        Random random = new Random();
        int r = random.nextInt(this.icons.length);
        this.icon = this.icons[r];
        if (Config.debug) {
            ZMusic.log.sendDebugMessage("[\u8fdb\u5ea6] \u968f\u673a\u56fe\u6807: " + this.icon);
        }
        this.id = id;
        this.title = title;
        this.description = "Zmusic \u4e13\u7528\u6210\u5c31";
        this.frame = frame;
        this.pl = ZMusicBukkit.plugin;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public org.bukkit.advancement.Advancement getAdvancement() {
        return Bukkit.getAdvancement((NamespacedKey)this.id);
    }

    private void add() {
        switch (this.ver) {
            case "1_12_R1": {
                this.loadAdvancement_1_12_R1(this.id, this.getJson());
                break;
            }
            case "1_13_R2": {
                this.loadadvancement_1_13_R2(this.id, this.getJson());
                break;
            }
            case "1_14_R1": {
                this.loadAdvancement_1_14_R1(this.id, this.getJson());
                break;
            }
            case "1_15_R1": {
                this.loadAdvancement_1_15_R1(this.id, this.getJson());
                break;
            }
            case "1_16_R1": {
                this.loadAdvancement_1_16_R1(this.id, this.getJson());
                break;
            }
            case "1_16_R2": {
                this.loadAdvancement_1_16_R2(this.id, this.getJson());
                break;
            }
            case "1_16_R3": {
                this.loadAdvancement_1_16_R3(this.id, this.getJson());
                break;
            }
            case "1_17_R1": {
                this.loadAdvancement_1_17_R1(this.id, this.getJson());
            }
        }
    }

    private void remove() {
        switch (this.ver) {
            case "1_12_R1": {
                this.removeAdvancement_1_12_R1(this.getAdvancement());
                break;
            }
            case "1_13_R2": {
                this.removeAdvancement_1_13_R2(this.getAdvancement());
                break;
            }
            case "1_14_R1": {
                this.removeAdvancement_1_14_R1(this.getAdvancement());
                break;
            }
            case "1_15_R1": {
                this.removeAdvancement_1_15_R1(this.getAdvancement());
                break;
            }
            case "1_16_R1": {
                this.removeAdvancement_1_16_R1(this.getAdvancement());
                break;
            }
            case "1_16_R2": {
                this.removeAdvancement_1_16_R2(this.getAdvancement());
                break;
            }
            case "1_16_R3": {
                this.removeAdvancement_1_16_R3(this.getAdvancement());
                break;
            }
            case "1_17_R1": {
                this.removeAdvancement_1_17_R1(this.getAdvancement());
            }
        }
    }

    public void loadAdvancement_1_12_R1(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        Advancement.SerializedAdvancement serializedAdvancement = (Advancement.SerializedAdvancement)net.minecraft.server.v1_12_R1.ChatDeserializer.a((Gson)net.minecraft.server.v1_12_R1.AdvancementDataWorld.DESERIALIZER, (String)json, Advancement.SerializedAdvancement.class);
        if (serializedAdvancement != null) {
            net.minecraft.server.v1_12_R1.AdvancementDataWorld.REGISTRY.a(new HashMap<net.minecraft.server.v1_12_R1.MinecraftKey, Advancement.SerializedAdvancement>(Collections.singletonMap(org.bukkit.craftbukkit.v1_12_R1.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key), serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_12_R1(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(this.id);
        for (Map.Entry entry : net.minecraft.server.v1_12_R1.AdvancementDataWorld.REGISTRY.advancements.entrySet()) {
            if (!((net.minecraft.server.v1_12_R1.Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
            net.minecraft.server.v1_12_R1.AdvancementDataWorld.REGISTRY.advancements.remove(entry.getKey());
            break;
        }
    }

    public void loadadvancement_1_13_R2(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        Advancement.SerializedAdvancement serializedAdvancement = (Advancement.SerializedAdvancement)net.minecraft.server.v1_13_R2.ChatDeserializer.a((Gson)net.minecraft.server.v1_13_R2.AdvancementDataWorld.DESERIALIZER, (String)json, Advancement.SerializedAdvancement.class);
        if (serializedAdvancement != null) {
            net.minecraft.server.v1_13_R2.AdvancementDataWorld.REGISTRY.a(new HashMap<net.minecraft.server.v1_13_R2.MinecraftKey, Advancement.SerializedAdvancement>(Collections.singletonMap(org.bukkit.craftbukkit.v1_13_R2.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key), serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_13_R2(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(this.id);
        for (Map.Entry entry : net.minecraft.server.v1_13_R2.AdvancementDataWorld.REGISTRY.advancements.entrySet()) {
            if (!((net.minecraft.server.v1_13_R2.Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
            net.minecraft.server.v1_12_R1.AdvancementDataWorld.REGISTRY.advancements.remove(entry.getKey());
            break;
        }
    }

    public void loadAdvancement_1_14_R1(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        Advancement.SerializedAdvancement serializedAdvancement = (Advancement.SerializedAdvancement)ChatDeserializer.a((Gson)net.minecraft.server.v1_14_R1.AdvancementDataWorld.DESERIALIZER, (String)json, Advancement.SerializedAdvancement.class);
        if (serializedAdvancement != null) {
            try {
                net.minecraft.server.v1_14_R1.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_14_R1.CraftServer)Bukkit.getServer()).getServer();
                net.minecraft.server.v1_14_R1.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
                advancements.a(new HashMap<net.minecraft.server.v1_14_R1.MinecraftKey, Advancement.SerializedAdvancement>(Collections.singletonMap(org.bukkit.craftbukkit.v1_14_R1.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key), serializedAdvancement)));
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAdvancement_1_14_R1(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(this.id);
        try {
            net.minecraft.server.v1_14_R1.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_14_R1.CraftServer)Bukkit.getServer()).getServer();
            net.minecraft.server.v1_14_R1.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
            for (Map.Entry entry : advancements.advancements.entrySet()) {
                if (!((net.minecraft.server.v1_14_R1.Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
                advancements.advancements.remove(entry.getKey());
                break;
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAdvancement_1_15_R1(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        Advancement.SerializedAdvancement serializedAdvancement = (Advancement.SerializedAdvancement)net.minecraft.server.v1_15_R1.ChatDeserializer.a((Gson)net.minecraft.server.v1_15_R1.AdvancementDataWorld.DESERIALIZER, (String)json, Advancement.SerializedAdvancement.class);
        if (serializedAdvancement != null) {
            try {
                net.minecraft.server.v1_15_R1.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_15_R1.CraftServer)Bukkit.getServer()).getServer();
                net.minecraft.server.v1_15_R1.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
                advancements.a(new HashMap<net.minecraft.server.v1_15_R1.MinecraftKey, Advancement.SerializedAdvancement>(Collections.singletonMap(CraftNamespacedKey.toMinecraft((NamespacedKey)key), serializedAdvancement)));
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAdvancement_1_15_R1(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(this.id);
        try {
            net.minecraft.server.v1_15_R1.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_15_R1.CraftServer)Bukkit.getServer()).getServer();
            net.minecraft.server.v1_15_R1.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
            for (Map.Entry entry : advancements.advancements.entrySet()) {
                if (!((net.minecraft.server.v1_15_R1.Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
                advancements.advancements.remove(entry.getKey());
                break;
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAdvancement_1_16_R1(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        net.minecraft.server.v1_16_R1.MinecraftKey minecraftKey = org.bukkit.craftbukkit.v1_16_R1.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        JsonElement jsonElement = (JsonElement)net.minecraft.server.v1_16_R1.AdvancementDataWorld.DESERIALIZER.fromJson(json, JsonElement.class);
        JsonObject jsonObject = net.minecraft.server.v1_16_R1.ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (net.minecraft.server.v1_16_R1.LootDeserializationContext)new net.minecraft.server.v1_16_R1.LootDeserializationContext(minecraftKey, net.minecraft.server.v1_16_R1.MinecraftServer.getServer().aI()));
        if (serializedAdvancement != null) {
            net.minecraft.server.v1_16_R1.MinecraftServer.getServer().getAdvancementData().REGISTRY.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_16_R1(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(advancement.getKey());
        try {
            net.minecraft.server.v1_16_R1.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_16_R1.CraftServer)Bukkit.getServer()).getServer();
            Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
            Iterator iterator = advancements.advancements.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((net.minecraft.server.v1_16_R1.Advancement)entry.getValue()).getName().equals((Object)advancement.getKey().getKey().toLowerCase())) {
                    // empty if block
                }
                advancements.advancements.remove(entry.getKey());
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAdvancement_1_16_R2(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        net.minecraft.server.v1_16_R2.MinecraftKey minecraftKey = org.bukkit.craftbukkit.v1_16_R2.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        JsonElement jsonElement = (JsonElement)AdvancementDataWorld.DESERIALIZER.fromJson(json, JsonElement.class);
        JsonObject jsonObject = net.minecraft.server.v1_16_R2.ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (net.minecraft.server.v1_16_R2.LootDeserializationContext)new net.minecraft.server.v1_16_R2.LootDeserializationContext(minecraftKey, net.minecraft.server.v1_16_R2.MinecraftServer.getServer().getLootPredicateManager()));
        if (serializedAdvancement != null) {
            net.minecraft.server.v1_16_R2.MinecraftServer.getServer().getAdvancementData().REGISTRY.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_16_R2(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(advancement.getKey());
        try {
            DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_16_R2.CraftServer)Bukkit.getServer()).getServer();
            net.minecraft.server.v1_16_R2.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
            Iterator iterator = advancements.advancements.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((net.minecraft.server.v1_16_R2.Advancement)entry.getValue()).getName().equals((Object)advancement.getKey().getKey().toLowerCase())) {
                    // empty if block
                }
                advancements.advancements.remove(entry.getKey());
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAdvancement_1_16_R3(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        net.minecraft.server.v1_16_R3.MinecraftKey minecraftKey = org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        JsonElement jsonElement = (JsonElement)net.minecraft.server.v1_16_R3.AdvancementDataWorld.DESERIALIZER.fromJson(json, JsonElement.class);
        JsonObject jsonObject = net.minecraft.server.v1_16_R3.ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (net.minecraft.server.v1_16_R3.LootDeserializationContext)new net.minecraft.server.v1_16_R3.LootDeserializationContext(minecraftKey, MinecraftServer.getServer().getLootPredicateManager()));
        if (serializedAdvancement != null) {
            MinecraftServer.getServer().getAdvancementData().REGISTRY.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_16_R3(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(advancement.getKey());
        try {
            net.minecraft.server.v1_16_R3.DedicatedServer dedicatedServer = ((org.bukkit.craftbukkit.v1_16_R3.CraftServer)Bukkit.getServer()).getServer();
            net.minecraft.server.v1_16_R3.Advancements advancements = dedicatedServer.getAdvancementData().REGISTRY;
            for (Map.Entry entry : advancements.advancements.entrySet()) {
                if (!((net.minecraft.server.v1_16_R3.Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
                advancements.advancements.remove(entry.getKey());
                break;
            }
        }
        catch (Error | Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadAdvancement_1_17_R1(NamespacedKey key, String json) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            return;
        }
        MinecraftKey minecraftKey = org.bukkit.craftbukkit.v1_17_R1.util.CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        JsonElement jsonElement = (JsonElement)net.minecraft.server.AdvancementDataWorld.b.fromJson(json, JsonElement.class);
        JsonObject jsonObject = net.minecraft.util.ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (LootDeserializationContext)new LootDeserializationContext(minecraftKey, net.minecraft.server.MinecraftServer.getServer().getLootPredicateManager()));
        if (serializedAdvancement != null) {
            net.minecraft.server.MinecraftServer.getServer().getAdvancementData().c.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        }
    }

    public void removeAdvancement_1_17_R1(org.bukkit.advancement.Advancement advancement) {
        Bukkit.getUnsafe().removeAdvancement(advancement.getKey());
        try {
            net.minecraft.server.dedicated.DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            net.minecraft.advancements.Advancements advancements = dedicatedServer.getAdvancementData().c;
            for (Map.Entry entry : advancements.b.entrySet()) {
                if (!((Advancement)entry.getValue()).getName().getKey().equals(advancement.getKey().getKey().toLowerCase())) continue;
                advancements.b.remove(entry.getKey());
                break;
            }
        }
        catch (Error | Exception exception) {
            exception.printStackTrace();
        }
    }

    public AdvancementAPI grant(Player ... p) {
        org.bukkit.advancement.Advancement advancement = this.getAdvancement();
        Player[] players = p;
        int i = p.length;
        for (int b = 0; b < i; b = (int)((byte)(b + 1))) {
            Player player = players[b];
            if (player.getAdvancementProgress(advancement).isDone()) continue;
            Collection collection = player.getAdvancementProgress(advancement).getRemainingCriteria();
            for (String str : collection) {
                player.getAdvancementProgress(this.getAdvancement()).awardCriteria(str);
            }
        }
        return this;
    }

    public AdvancementAPI revoke(Player ... p) {
        org.bukkit.advancement.Advancement advancement = this.getAdvancement();
        if (advancement == null) {
            return this;
        }
        Player[] players = p;
        int i = p.length;
        for (int b = 0; b < i; b = (int)((byte)(b + 1))) {
            Player player = players[b];
            if (player.getAdvancementProgress(advancement) == null || !player.getAdvancementProgress(advancement).isDone()) continue;
            Collection collection = player.getAdvancementProgress(advancement).getAwardedCriteria();
            for (String str : collection) {
                player.getAdvancementProgress(this.getAdvancement()).revokeCriteria(str);
            }
        }
        return this;
    }

    public String getJson() {
        JsonObject json = new JsonObject();
        JsonObject icon = new JsonObject();
        icon.addProperty("item", this.icon);
        JsonObject display = new JsonObject();
        display.add("icon", (JsonElement)icon);
        display.addProperty("title", this.title);
        display.addProperty("description", this.description);
        display.addProperty("background", "minecraft:textures/gui/advancements/backgrounds/adventure.png");
        display.addProperty("frame", this.frame);
        display.addProperty("announce_to_chat", Boolean.valueOf(this.announce));
        display.addProperty("show_toast", Boolean.valueOf(this.toast));
        display.addProperty("hidden", Boolean.valueOf(true));
        JsonObject criteria = new JsonObject();
        JsonObject trigger = new JsonObject();
        trigger.addProperty("trigger", "minecraft:impossible");
        criteria.add("impossible", (JsonElement)trigger);
        json.add("criteria", (JsonElement)criteria);
        json.add("display", (JsonElement)display);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    public void sendAdvancement(Object p) {
        Player player = (Player)p;
        this.add();
        this.grant(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.pl, () -> {
            this.revoke(player);
            this.remove();
        }, 20L);
    }
}

