/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.api;

public class ProgressBar {
    final int length = 25;
    char finish;
    char unFinish;
    double progress;
    double maxnumber = 100.0;

    public ProgressBar(char finish, char unFinish) {
        this.finish = finish;
        this.unFinish = unFinish;
    }

    public ProgressBar(char finish, char unFinish, long maxnumber) {
        this.finish = finish;
        this.unFinish = unFinish;
        this.maxnumber = maxnumber;
    }

    public void setMaxnumber(double maxnumber) {
        this.maxnumber = maxnumber;
    }

    public char getFinish() {
        return this.finish;
    }

    public void setFinish(char finish) {
        this.finish = finish;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        if (progress < 0.0 && progress > this.maxnumber) {
            throw new ArithmeticException();
        }
        this.progress = progress;
    }

    public char getUnFinish() {
        return this.unFinish;
    }

    public void setUnFinish(char unFinish) {
        this.unFinish = unFinish;
    }

    public String toString() {
        int i;
        double f = this.maxnumber / 25.0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int prog = this.getProgress() != 0.0 ? (int)((double)((int)this.getProgress()) / f) : 0;
        for (i = 0; i < prog; ++i) {
            stringBuilder.append(this.getFinish());
        }
        for (i = 0; i < 25 - prog; ++i) {
            stringBuilder.append(this.getUnFinish());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getString() {
        return this.toString();
    }
}

