/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.api.bossbar;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.api.bossbar.BarColor;
import cn.iqianye.mc.zmusic.api.bossbar.BarStyle;
import cn.iqianye.mc.zmusic.api.bossbar.BossBar;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.DefinedPacket;

public class BossBarBC
implements BossBar {
    private static final AtomicInteger barID = new AtomicInteger(1);
    private final UUID uuid;
    private final Object player;
    private final double seconds;
    private final Set<ProxiedPlayer> players = Sets.newHashSet();
    private String title;
    private double progress = 0.0;
    private BarColor barColor;
    private BarStyle barStyle;
    private String compiledTitle;
    private boolean visible = false;

    public BossBarBC(Object palyer, String title, BarColor barColor, BarStyle barStyle, float seconds) {
        this.uuid = UUID.nameUUIDFromBytes(("BBB:" + barID.getAndIncrement()).getBytes(StandardCharsets.UTF_8));
        this.player = palyer;
        this.title = title;
        this.compiledTitle = ComponentSerializer.toString((BaseComponent)new TextComponent(this.title));
        this.barColor = barColor;
        this.barStyle = barStyle;
        this.seconds = seconds;
    }

    @Override
    public void showTitle() {
        this.addPlayer(this.player);
        this.setVisible(true);
        this.setProgress(0.0);
        ZMusic.runTask.runAsync(() -> {
            double step = 1.0 / this.seconds;
            double prog = this.getProgress();
            while ((prog >= 0.0 || prog <= 1.0) && !((prog += step) > 1.0)) {
                this.setProgress(prog);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.setVisible(false);
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.compiledTitle = ComponentSerializer.toString((BaseComponent)new TextComponent(this.title));
        if (this.visible) {
            net.md_5.bungee.protocol.packet.BossBar packet = new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 3);
            packet.setTitle(this.compiledTitle);
            this.players.forEach(player -> player.unsafe().sendPacket((DefinedPacket)packet));
        }
    }

    @Override
    public BarColor getBarColor() {
        return this.barColor;
    }

    @Override
    public void setBarColor(BarColor barColor) {
        this.barColor = barColor;
        if (this.visible) {
            net.md_5.bungee.protocol.packet.BossBar packet = new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 4);
            packet.setColor(this.barColor.ordinal());
            packet.setDivision(this.barStyle.ordinal());
            this.players.forEach(player -> player.unsafe().sendPacket((DefinedPacket)packet));
        }
    }

    @Override
    public BarStyle getBarStyle() {
        return this.barStyle;
    }

    @Override
    public void setBarStyle(BarStyle barStyle) {
        this.barStyle = barStyle;
        if (this.visible) {
            net.md_5.bungee.protocol.packet.BossBar packet = new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 4);
            packet.setColor(this.barColor.ordinal());
            packet.setDivision(this.barStyle.ordinal());
            this.players.forEach(player -> player.unsafe().sendPacket((DefinedPacket)packet));
        }
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(double progress) {
        this.progress = progress;
        if (this.visible) {
            net.md_5.bungee.protocol.packet.BossBar packet = new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 2);
            packet.setHealth((float)this.progress);
            this.players.forEach(player -> player.unsafe().sendPacket((DefinedPacket)packet));
        }
    }

    @Override
    public boolean hasPlayer(Object playerObj) {
        ProxiedPlayer player = (ProxiedPlayer)playerObj;
        return this.players.contains(player);
    }

    @Override
    public void addPlayer(Object playerObj) {
        ProxiedPlayer player = (ProxiedPlayer)playerObj;
        this.players.add(player);
        if (this.visible && player.isConnected()) {
            player.unsafe().sendPacket((DefinedPacket)this.getAddPacket());
        }
    }

    @Override
    public void removePlayer(Object playerObj) {
        ProxiedPlayer player = (ProxiedPlayer)playerObj;
        this.players.remove(player);
        if (this.visible && player.isConnected()) {
            player.unsafe().sendPacket((DefinedPacket)this.getRemovePacket());
        }
    }

    @Override
    public void removeAll() {
        this.players.stream().collect(Collectors.toSet()).forEach(this::removePlayer);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        net.md_5.bungee.protocol.packet.BossBar packet = visible ? this.getAddPacket() : this.getRemovePacket();
        this.players.forEach(player -> player.unsafe().sendPacket((DefinedPacket)packet));
    }

    private net.md_5.bungee.protocol.packet.BossBar getAddPacket() {
        net.md_5.bungee.protocol.packet.BossBar packet = new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 0);
        packet.setTitle(this.compiledTitle);
        packet.setColor(this.barColor.ordinal());
        packet.setDivision(this.barStyle.ordinal());
        packet.setHealth((float)this.progress);
        return packet;
    }

    private net.md_5.bungee.protocol.packet.BossBar getRemovePacket() {
        return new net.md_5.bungee.protocol.packet.BossBar(this.uuid, 1);
    }
}

