/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.api.bossbar;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.api.bossbar.BarColor;
import cn.iqianye.mc.zmusic.api.bossbar.BarStyle;
import cn.iqianye.mc.zmusic.api.bossbar.BossBar;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarFlag;
import org.bukkit.entity.Player;

public class BossBarBukkit
implements BossBar {
    private final Player p;
    private final String title;
    private final double seconds;
    private final org.bukkit.boss.BossBar bar;

    public BossBarBukkit(Object p, String title, BarColor color, BarStyle style, float seconds) {
        Player player = (Player)p;
        this.bar = Bukkit.getServer().createBossBar(title, org.bukkit.boss.BarColor.valueOf((String)color.name()), org.bukkit.boss.BarStyle.valueOf((String)style.name()), new BarFlag[0]);
        this.p = player;
        this.title = title;
        this.seconds = seconds;
    }

    @Override
    public void showTitle() {
        this.bar.setVisible(true);
        this.bar.setProgress(0.0);
        this.bar.addPlayer(this.p);
        ZMusic.runTask.runAsync(() -> {
            double step = 1.0 / this.seconds;
            double prog = this.bar.getProgress();
            while ((prog >= 0.0 || prog <= 1.0) && !((prog += step) > 1.0)) {
                this.bar.setProgress(prog);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.bar.setVisible(false);
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.bar.setTitle(title);
    }

    @Override
    public void removePlayer(Object player) {
        Player p = (Player)player;
        this.bar.removePlayer(p);
    }

    @Override
    public void removeAll() {
        this.bar.removeAll();
    }

    @Override
    public boolean isVisible() {
        return this.bar.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.bar.setVisible(visible);
    }

    @Override
    public BarColor getBarColor() {
        return BarColor.valueOf(this.bar.getColor().name());
    }

    @Override
    public void setBarColor(BarColor barColor) {
        this.bar.setColor(org.bukkit.boss.BarColor.valueOf((String)barColor.name()));
    }

    @Override
    public BarStyle getBarStyle() {
        return BarStyle.valueOf(this.bar.getStyle().name());
    }

    @Override
    public void setBarStyle(BarStyle barStyle) {
        this.bar.setStyle(org.bukkit.boss.BarStyle.valueOf((String)barStyle.name()));
    }

    @Override
    public double getProgress() {
        return (float)this.bar.getProgress();
    }

    @Override
    public void setProgress(double progress) {
        this.bar.setProgress(progress);
    }

    @Override
    public boolean hasPlayer(Object playerObj) {
        List players = this.bar.getPlayers();
        for (Player player : players) {
            if (player != playerObj) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addPlayer(Object playerObj) {
        this.bar.addPlayer((Player)playerObj);
    }
}

