/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.config;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.utils.NetUtils;
import cn.iqianye.mc.zmusic.utils.OtherUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class LoadConfig {
    public void load() {
        JsonObject configJson;
        File config;
        File reToOld;
        File oldConfig = new File(ZMusic.dataFolder.getPath(), "config.yml");
        if (oldConfig.exists() && !oldConfig.renameTo(reToOld = new File(ZMusic.dataFolder.getPath(), "config.yml.old"))) {
            reToOld.delete();
            oldConfig.renameTo(reToOld);
        }
        if (!(config = new File(ZMusic.dataFolder.getPath(), "config.json")).exists()) {
            ZMusic.log.sendErrorMessage("\u65e0\u6cd5\u627e\u5230\u914d\u7f6e\u6587\u4ef6,\u6b63\u5728\u521b\u5efa!");
            this.saveDefaultConfig();
        }
        String json = OtherUtils.readFileToString(config);
        try {
            configJson = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            ZMusic.log.sendErrorMessage("\u914d\u7f6e\u6587\u4ef6\u51fa\u9519,\u6b63\u5728\u91cd\u7f6e!");
            File configErrBak = new File(ZMusic.dataFolder.getPath(), System.currentTimeMillis() + "_error-config.json");
            config.renameTo(configErrBak);
            config.delete();
            this.saveDefaultConfig();
            this.load();
            return;
        }
        Config.version = configJson.get("version").getAsInt();
        if (Config.version != Config.latestVersion) {
            ZMusic.log.sendNormalMessage("-- \u6b63\u5728\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6...");
            config = new File(ZMusic.dataFolder.getPath(), "config.json");
            File configBak = new File(ZMusic.dataFolder.getPath(), "config.json.v" + Config.version + ".bak");
            ZMusic.log.sendNormalMessage("-- \u6b63\u5728\u5907\u4efd\u539f\u914d\u7f6e\u6587\u4ef6...");
            config.renameTo(configBak);
            ZMusic.log.sendNormalMessage("-- \u6b63\u5728\u91ca\u653e\u65b0\u914d\u7f6e\u6587\u4ef6...");
            this.saveDefaultConfig();
            ZMusic.log.sendNormalMessage("-- \u66f4\u65b0\u5b8c\u6bd5.");
            this.load();
            return;
        }
        this.init(configJson);
    }

    private void init(JsonObject config) {
        Config.version = config.get("version").getAsInt();
        Config.debug = config.get("debug").getAsBoolean();
        Config.update = config.get("update").getAsBoolean();
        Config.prefix = config.get("prefix").getAsString().replaceAll("&", "\u00a7");
        JsonObject api = config.get("api").getAsJsonObject();
        Config.neteaseApiRoot = api.get("netease").getAsString();
        Config.qqMusicApiRoot = api.get("qq").getAsString();
        JsonObject account = config.get("account").getAsJsonObject();
        JsonObject netease = account.get("netease").getAsJsonObject();
        Config.neteaseloginType = netease.get("loginType").getAsString();
        Config.neteaseAccount = netease.get("account").getAsString();
        Config.neteasePasswordType = netease.get("passwordType").getAsString();
        if (Config.neteasePasswordType.equalsIgnoreCase("normal")) {
            Config.neteasePassword = OtherUtils.getMD5String(netease.get("password").getAsString());
        } else if (Config.neteasePasswordType.equalsIgnoreCase("md5")) {
            Config.neteasePassword = netease.get("password").getAsString();
        }
        Config.neteaseFollow = netease.get("follow").getAsBoolean();
        JsonObject bilibili = account.get("bilibili").getAsJsonObject();
        Config.bilibiliQQ = bilibili.get("qq").getAsString();
        Config.bilibiliKey = bilibili.get("key").getAsString();
        if (!Config.bilibiliKey.equalsIgnoreCase("none")) {
            ZMusic.runTask.runAsync(() -> {
                Gson gson = new GsonBuilder().create();
                String jsonText = NetUtils.getNetString("https://api.zhenxin.xyz/minecraft/plugins/ZMusic/bilibili/checkVIP.php", null, "qq=" + Config.bilibiliQQ + "&key=" + Config.bilibiliKey);
                JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
                ZMusic.bilibiliIsVIP = json.get("isVIP").getAsBoolean();
            });
        }
        JsonObject music = config.get("music").getAsJsonObject();
        Config.money = music.get("money").getAsInt();
        Config.cooldown = music.get("cooldown").getAsInt();
        JsonObject lyric = config.get("lyric").getAsJsonObject();
        Config.lyricEnable = lyric.get("enable").getAsBoolean();
        Config.showLyricTr = lyric.get("showLyricTr").getAsBoolean();
        Config.lyricColor = lyric.get("color").getAsString().replaceAll("&", "\u00a7");
        if (Config.realSupportBossBar) {
            Config.supportBossBar = lyric.get("bossBar").getAsBoolean();
        }
        if (Config.realSupportActionBar) {
            Config.supportActionBar = lyric.get("actionBar").getAsBoolean();
        }
        if (Config.realSupportTitle) {
            Config.supportTitle = lyric.get("subTitle").getAsBoolean();
        }
        Config.supportChat = lyric.get("chatMessage").getAsBoolean();
        if (Config.realSupportHud) {
            JsonObject hud = lyric.get("hud").getAsJsonObject();
            Config.supportHud = hud.get("enable").getAsBoolean();
            Config.hudInfoX = hud.get("infoX").getAsInt();
            Config.hudInfoY = hud.get("infoY").getAsInt();
            Config.hudLyricX = hud.get("lyricX").getAsInt();
            Config.hudLyricY = hud.get("lyricY").getAsInt();
        }
    }

    private void saveDefaultConfig() {
        File config = new File(ZMusic.dataFolder.getPath(), "config.json");
        try {
            Files.copy(this.getClass().getResourceAsStream("/config.json"), config.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload(Object sender) {
        this.load();
        ZMusic.message.sendNormalMessage("\u914d\u7f6e\u6587\u4ef6\u91cd\u8f7d\u5b8c\u6bd5!", sender);
    }
}

