/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.api.ProgressBar;
import cn.iqianye.mc.zmusic.api.bossbar.BarColor;
import cn.iqianye.mc.zmusic.api.bossbar.BarStyle;
import cn.iqianye.mc.zmusic.api.bossbar.BossBar;
import cn.iqianye.mc.zmusic.api.bossbar.BossBarBC;
import cn.iqianye.mc.zmusic.api.bossbar.BossBarBukkit;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.data.PlayerData;
import cn.iqianye.mc.zmusic.music.PlayListPlayer;
import cn.iqianye.mc.zmusic.nms.ActionBar;
import cn.iqianye.mc.zmusic.utils.OtherUtils;
import com.google.gson.JsonObject;
import net.md_5.bungee.api.chat.TextComponent;

public class LyricSender
extends Thread {
    public Object player;
    public JsonObject lyric;
    public long maxTime;
    public String name;
    public String singer;
    public String fullName;
    public String url;
    public String platform;
    public String src;
    public boolean isPlayList = false;
    public String nextMusicName;
    public PlayListPlayer playListPlayer;
    BossBar bossBar;
    long time = -1L;
    ActionBar actionBar = null;
    boolean is1_8 = false;
    StringBuilder hudInfo = new StringBuilder();
    ProgressBar progressBar;
    private boolean isStop = false;

    public void init() {
        PlayerData.setPlayerPlayStatus(this.player, true);
        PlayerData.setPlayerMusicName(this.player, this.name);
        PlayerData.setPlayerMusicSinger(this.player, this.singer);
        PlayerData.setPlayerPlaySource(this.player, this.src);
        PlayerData.setPlayerPlatform(this.player, this.platform);
        PlayerData.setPlayerMaxTime(this.player, this.maxTime);
        PlayerData.setPlayerCurrentTime(this.player, 0L);
        this.progressBar = new ProgressBar('\u25a0', '\u25a1', this.maxTime);
        if (Config.supportBossBar) {
            this.bossBar = PlayerData.getPlayerBoosBar(this.player);
            if (this.bossBar == null) {
                this.initBossBar();
            } else {
                this.bossBar.removePlayer(this.player);
                this.initBossBar();
            }
        }
        if (Config.supportHud) {
            ZMusic.send.sendAM(this.player, Config.hudInfoX, Config.hudInfoY, Config.hudLyricX, Config.hudLyricY);
            this.hudInfo.append("\u6b4c\u540d: ").append(this.name).append("\n");
            this.hudInfo.append("\u6b4c\u624b: ").append(this.singer).append("\n");
            this.hudInfo.append("\u5e73\u53f0: ").append(this.platform).append("\n");
            this.hudInfo.append("\u6765\u6e90: ").append(this.src).append("\n");
            this.hudInfo.append("\u8fdb\u5ea6: 00:00/").append(OtherUtils.formatTime(this.maxTime / 100L));
            if (this.isPlayList) {
                this.hudInfo.append("\n\u4e0b\u4e00\u9996: ").append(this.nextMusicName);
            }
        }
    }

    private void initBossBar() {
        this.bossBar = ZMusic.isBC ? new BossBarBC(this.player, Config.lyricColor + this.fullName, BarColor.BLUE, BarStyle.SEGMENTED_20, this.maxTime) : new BossBarBukkit(this.player, Config.lyricColor + this.fullName, BarColor.BLUE, BarStyle.SEGMENTED_20, this.maxTime);
        this.bossBar.showTitle();
        PlayerData.setPlayerBoosBar(this.player, this.bossBar);
    }

    @Override
    public void run() {
        while (!this.isStop) {
            if (ZMusic.player.isOnline(this.player)) {
                ++this.time;
                if (PlayerData.getPlayerPlayStatus(this.player).booleanValue()) {
                    PlayerData.setPlayerCurrentTime(this.player, this.time);
                    if (Config.supportHud) {
                        this.updateHudTime(this.time);
                    }
                    if (this.time <= this.maxTime) {
                        if (Config.lyricEnable) {
                            ZMusic.runTask.runAsync(() -> {
                                JsonObject j;
                                if (this.lyric != null && (j = this.lyric.getAsJsonObject(String.valueOf(this.time))) != null) {
                                    this.sendLyric(j);
                                    if (Config.supportHud) {
                                        this.sendHud(j);
                                    }
                                }
                            });
                        }
                    } else {
                        OtherUtils.resetPlayerStatus(this.player);
                        if (Config.supportHud) {
                            ZMusic.send.sendAM(this.player, "[Lyric]");
                            ZMusic.send.sendAM(this.player, "[Info]");
                            this.hudInfo = new StringBuilder();
                        }
                        if (!this.isPlayList) {
                            ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u975e\u6b4c\u5355\u6a21\u5f0f \u68c0\u6d4b\u5faa\u73af\u64ad\u653e\u72b6\u6001");
                            Boolean loop = PlayerData.getPlayerLoopPlay(this.player);
                            if (loop != null && loop.booleanValue()) {
                                ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u5faa\u73af\u64ad\u653e\u5f00\u542f \u91cd\u65b0\u64ad\u653e\u5f53\u524d\u97f3\u4e50");
                                this.time = -1L;
                                ZMusic.music.play(this.url, this.player);
                                this.init();
                            } else {
                                ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u5faa\u73af\u64ad\u653e\u5173\u95ed \u7ebf\u7a0b\u505c\u6b62");
                                this.stopThis();
                            }
                        } else {
                            ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u6b4c\u5355\u6a21\u5f0f \u7ebf\u7a0b\u505c\u6b62");
                            this.playListPlayer.singleIsPlayEd = true;
                            this.stopThis();
                        }
                    }
                } else {
                    ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u64ad\u653e\u72b6\u6001\u6539\u53d8\uff0c\u7ebf\u7a0b\u505c\u6b62");
                    this.stopThis();
                }
            } else {
                ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u73a9\u5bb6\u79bb\u7ebf\uff0c\u7ebf\u7a0b\u505c\u6b62");
                this.stopThis();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ZMusic.log.sendDebugMessage("[\u64ad\u653e\u5668](ID:" + this.getId() + ") \u7ebf\u7a0b\u5df2\u505c\u6b62");
    }

    private void sendHud(JsonObject j) {
        String l = j.get("lrc").getAsString();
        String lT = j.get("lrcTr").getAsString();
        StringBuilder sb = new StringBuilder();
        if (!l.isEmpty()) {
            l = Config.lyricColor + l;
            sb.append(l);
            if (Config.showLyricTr && !lT.isEmpty()) {
                lT = Config.lyricColor + lT;
                sb.append("\n").append(lT);
            }
            String data = sb.toString().replaceAll("\n", "\n" + Config.lyricColor);
            ZMusic.send.sendAM(this.player, "[Lyric]" + data);
        }
    }

    private void sendLyric(JsonObject j) {
        String lrc = j.get("lrc").getAsString();
        String lrcTr = j.get("lrcTr").getAsString();
        String[] lrcs = lrc.split("\n");
        String[] lrcTrs = new String[]{""};
        if (!lrcTr.isEmpty()) {
            lrcTrs = lrcTr.split("\n");
        }
        for (int i = 0; i < lrcs.length; ++i) {
            String lyricTr;
            String lyric = lrcs[i];
            try {
                lyricTr = lrcTrs[i];
            }
            catch (Exception e) {
                lyricTr = "";
            }
            String lyricToInOne = lyric;
            if (Config.showLyricTr && !lyricTr.isEmpty()) {
                lyricToInOne = lyric + "(" + lyricTr + ")";
            }
            if (!lyricToInOne.isEmpty()) {
                PlayerData.setPlayerLyric(this.player, lyricToInOne);
            }
            if (Config.supportBossBar && !lyricToInOne.isEmpty()) {
                this.bossBar.setTitle(Config.lyricColor + lyricToInOne);
            }
            if (Config.supportActionBar && !lyricToInOne.isEmpty()) {
                if (!this.is1_8) {
                    ZMusic.message.sendActionBarMessage(new TextComponent(Config.lyricColor + lyricToInOne), this.player);
                } else {
                    this.actionBar.sendActionBar(this.player, Config.lyricColor + lyricToInOne);
                }
            }
            if (Config.supportTitle && !lyricToInOne.isEmpty()) {
                ZMusic.message.sendTitleMessage("", Config.lyricColor + lyricToInOne, this.player);
            }
            if (!Config.supportChat) continue;
            ZMusic.message.sendNormalMessage(Config.lyricColor + lyric, this.player);
            if (!Config.showLyricTr || lyricTr.isEmpty()) continue;
            ZMusic.message.sendNormalMessage(Config.lyricColor + lyricTr, this.player);
        }
    }

    void updateHudTime(long time) {
        String str = this.hudInfo.toString();
        String[] strs = str.split("\n");
        this.progressBar.setProgress(time);
        strs[4] = "\u8fdb\u5ea6: " + OtherUtils.formatTime(time) + "/" + OtherUtils.formatTime(this.maxTime) + " " + this.progressBar.toString();
        StringBuilder sb = new StringBuilder();
        this.hudInfo = new StringBuilder();
        for (String s : strs) {
            this.hudInfo.append(s).append("\n");
            sb.append(Config.lyricColor).append(s).append("\n");
        }
        String info = sb.substring(0, sb.length() - 1);
        ZMusic.send.sendAM(this.player, "[Info]" + info);
    }

    public void stopThis() {
        OtherUtils.resetPlayerStatus(this.player);
        this.isStop = true;
    }
}

