/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.data.PlayerData;
import cn.iqianye.mc.zmusic.music.PlayListPlayer;
import cn.iqianye.mc.zmusic.music.searchSource.NeteaseCloudMusic;
import cn.iqianye.mc.zmusic.music.searchSource.QQMusic;
import cn.iqianye.mc.zmusic.utils.HelpUtils;
import cn.iqianye.mc.zmusic.utils.OtherUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class PlayList {
    public static void subCommand(String[] args, Object player) {
        switch (args[1]) {
            case "next": {
                ZMusic.message.sendNormalMessage("\u6b63\u5728\u5207\u6362\u5230\u4e0b\u4e00\u9996\u6b4c\u66f2,\u8bf7\u7a0d\u540e...", player);
                PlayListPlayer plp = PlayerData.getPlayerPlayListPlayer(player);
                if (plp != null) {
                    plp.nextMusic = true;
                } else {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5f53\u524d\u672a\u5728\u64ad\u653e\u6b4c\u5355", player);
                }
                return;
            }
            case "prev": {
                ZMusic.message.sendNormalMessage("\u6b63\u5728\u5207\u6362\u5230\u4e0a\u4e00\u9996\u6b4c\u66f2,\u8bf7\u7a0d\u540e...", player);
                PlayListPlayer plp2 = PlayerData.getPlayerPlayListPlayer(player);
                if (plp2 != null) {
                    plp2.prevMusic = true;
                } else {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5f53\u524d\u672a\u5728\u64ad\u653e\u6b4c\u5355", player);
                }
                return;
            }
            case "jump": {
                int jumpSong = 1;
                String id = "";
                try {
                    jumpSong = Integer.parseInt(args[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ZMusic.message.sendNormalMessage("\u6b63\u5728\u8df3\u8f6c\u5230\u5f53\u524d\u6b4c\u5355\u4e2dID\u4e3a\u00a7r[\u00a7e" + jumpSong + "\u00a7r]\u00a7a\u7684\u6b4c\u66f2,\u8bf7\u7a0d\u540e...", player);
                PlayListPlayer plp3 = PlayerData.getPlayerPlayListPlayer(player);
                if (plp3 != null) {
                    try {
                        id = args[3];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!id.isEmpty() && !id.equals(plp3.id)) {
                        ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5f53\u524d\u672a\u5728\u64ad\u653e\u6b64\u6b4c\u5355", player);
                        return;
                    }
                    plp3.jumpSong = jumpSong;
                    plp3.jumpMusic = true;
                } else {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5f53\u524d\u672a\u5728\u64ad\u653e\u6b4c\u5355", player);
                }
                return;
            }
            case "type": {
                switch (args[2]) {
                    case "normal": {
                        PlayerData.setPlayerPlayListType(player, args[2]);
                        ZMusic.message.sendNormalMessage("\u6210\u529f\u5c06\u6b4c\u5355\u64ad\u653e\u7c7b\u578b\u8bbe\u7f6e\u4e3a[\u00a7e\u987a\u5e8f\u64ad\u653e\u00a7a].", player);
                        break;
                    }
                    case "loop": {
                        PlayerData.setPlayerPlayListType(player, args[2]);
                        ZMusic.message.sendNormalMessage("\u6210\u529f\u5c06\u6b4c\u5355\u64ad\u653e\u7c7b\u578b\u8bbe\u7f6e\u4e3a[\u00a7e\u5faa\u73af\u64ad\u653e\u00a7a].", player);
                        break;
                    }
                    case "random": {
                        PlayerData.setPlayerPlayListType(player, args[2]);
                        ZMusic.message.sendNormalMessage("\u6210\u529f\u5c06\u6b4c\u5355\u64ad\u653e\u7c7b\u578b\u8bbe\u7f6e\u4e3a[\u00a7e\u968f\u673a\u64ad\u653e\u00a7a].", player);
                        break;
                    }
                    default: {
                        ZMusic.message.sendErrorMessage("\u9519\u8bef: \u672a\u77e5\u7684\u64ad\u653e\u7c7b\u578b", player);
                        ZMusic.message.sendErrorMessage("/zm playlist type normal - \u987a\u5e8f\u64ad\u653e", player);
                        ZMusic.message.sendErrorMessage("/zm playlist type loop - \u5faa\u73af\u64ad\u653e", player);
                        ZMusic.message.sendErrorMessage("/zm playlist type random - \u968f\u673a\u64ad\u653e", player);
                    }
                }
                return;
            }
            case "global": {
                String platform = "";
                if (args.length >= 3) {
                    switch (platform = args[2]) {
                        case "163": 
                        case "netease": {
                            platform = "netease";
                            break;
                        }
                        case "qq": {
                            break;
                        }
                        default: {
                            ZMusic.message.sendErrorMessage("\u9519\u8bef\uff1a\u672a\u77e5\u7684\u5e73\u53f0", player);
                            return;
                        }
                    }
                } else {
                    HelpUtils.sendHelp("playlist", player);
                    return;
                }
                if (args.length >= 4) {
                    switch (args[3]) {
                        case "import": {
                            if (ZMusic.player.hasPermission(player, "zmusic.admin")) {
                                PlayList.importPlayList(args[4], platform, player, true);
                                break;
                            }
                            ZMusic.message.sendErrorMessage("\u6743\u9650\u4e0d\u8db3\uff0c\u4f60\u9700\u8981 zmusic.admin \u6743\u9650\u6b64\u4f7f\u7528\u547d\u4ee4.", player);
                            break;
                        }
                        case "list": {
                            PlayList.showPlayListList(platform, player, true);
                            break;
                        }
                        case "show": {
                            int start = 0;
                            try {
                                start = Integer.parseInt(args[5]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            PlayList.showPlayList(args[4], platform, player, true, start);
                            break;
                        }
                        case "play": {
                            OtherUtils.resetPlayerStatus(player);
                            PlayList.playPlayList(args[4], platform, player, new ArrayList<Object>(), true);
                            break;
                        }
                        case "playall": {
                            List<Object> players = ZMusic.player.getOnlinePlayerList();
                            for (Object p : players) {
                                OtherUtils.resetPlayerStatus(p);
                            }
                            PlayList.playPlayList(args[4], platform, null, players, true);
                            break;
                        }
                        case "update": {
                            if (ZMusic.player.hasPermission(player, "zmusic.admin")) {
                                PlayList.updatePlayListInfo(platform, player, true);
                                break;
                            }
                            ZMusic.message.sendErrorMessage("\u6743\u9650\u4e0d\u8db3\uff0c\u4f60\u9700\u8981 zmusic.admin \u6743\u9650\u6b64\u4f7f\u7528\u547d\u4ee4.", player);
                            break;
                        }
                        default: {
                            HelpUtils.sendHelp("playlist", player);
                            break;
                        }
                    }
                } else {
                    HelpUtils.sendHelp("playlist", player);
                    return;
                }
                return;
            }
        }
        if (args.length >= 3) {
            String platform;
            switch (platform = args[1]) {
                case "163": 
                case "netease": {
                    platform = "netease";
                    break;
                }
                case "qq": {
                    break;
                }
                default: {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef\uff1a\u672a\u77e5\u7684\u5e73\u53f0", player);
                    return;
                }
            }
            switch (args[2]) {
                case "import": {
                    PlayList.importPlayList(args[3], platform, player, false);
                    break;
                }
                case "list": {
                    PlayList.showPlayListList(platform, player, false);
                    break;
                }
                case "show": {
                    int start = 0;
                    try {
                        start = Integer.parseInt(args[4]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PlayList.showPlayList(args[3], platform, player, false, start);
                    break;
                }
                case "play": {
                    OtherUtils.resetPlayerStatus(player);
                    PlayList.playPlayList(args[3], platform, player, new ArrayList<Object>(), false);
                    break;
                }
                case "update": {
                    PlayList.updatePlayListInfo(platform, player, false);
                    break;
                }
                default: {
                    HelpUtils.sendHelp("playlist", player);
                    break;
                }
            }
        } else {
            HelpUtils.sendHelp("playlist", player);
        }
    }

    private static void importPlayList(String url, String platform, Object player, boolean isGlobal) {
        ZMusic.message.sendNormalMessage("\u6b63\u5728\u5bfc\u5165\u6b4c\u5355\uff0c\u53ef\u80fd\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85...", player);
        try {
            String platformName;
            JsonObject json;
            String id;
            switch (platform) {
                case "netease": {
                    id = url.split("playlist\\?id=")[1].split("&")[0];
                    json = NeteaseCloudMusic.getMusicSongList(id);
                    platformName = "\u7f51\u6613\u4e91\u97f3\u4e50";
                    break;
                }
                case "qq": {
                    id = url.split("playlist/")[1].split("\\.html")[0];
                    json = QQMusic.getMusicSongList(id);
                    platformName = "QQ\u97f3\u4e50";
                    break;
                }
                default: {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef\uff1a\u672a\u77e5\u7684\u5e73\u53f0", player);
                    return;
                }
            }
            String name = json.get("name").getAsString();
            int songs = json.get("songs").getAsInt();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String data = gson.toJson((JsonElement)json);
            String filePath = isGlobal ? ZMusic.dataFolder + "/playlist/global/" + platform : ZMusic.dataFolder + "/playlist/" + platform + "/" + ZMusic.player.getName(player);
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            File file = new File(filePath, id + ".json");
            OtherUtils.saveStringToLocal(file, data);
            ZMusic.log.sendDebugMessage(file.getAbsolutePath());
            ZMusic.message.sendNormalMessage("\u6210\u529f\u5728" + platformName + "\u5bfc\u5165(\u00a7e" + name + "\u00a7a)\u5171\u8ba1\u00a7e" + songs + "\u00a7a\u9996\u3002", player);
            ZMusic.message.sendNormalMessage("\u5176\u4e2d\u53ef\u80fd\u5305\u542b\u65e0\u7248\u6743\u6216VIP\u97f3\u4e50\u3002", player);
        }
        catch (Exception e) {
            e.printStackTrace();
            ZMusic.message.sendErrorMessage("\u5bfc\u5165\u5931\u8d25,\u8bf7\u68c0\u67e5\u94fe\u63a5\u683c\u5f0f\u662f\u5426\u6b63\u786e.", player);
            ZMusic.message.sendErrorMessage("QQ\u97f3\u4e50: https://y.qq.com/n/yqq/playlist/1937967578.html", player);
            ZMusic.message.sendErrorMessage("\u7f51\u6613\u4e91\u97f3\u4e50: https://music.163.com/#/my/m/music/playlist?id=363046232", player);
        }
    }

    private static void showPlayListList(String platform, Object player, boolean isGlobal) {
        String filePath = "";
        filePath = isGlobal ? ZMusic.dataFolder + "/playlist/global/" + platform : ZMusic.dataFolder + "/playlist/" + platform + "/" + ZMusic.player.getName(player);
        ArrayList<String> files = OtherUtils.queryFileNames(filePath);
        try {
            ZMusic.message.sendNormalMessage("\u00a76=========================================", player);
            if (files != null) {
                int i = 0;
                for (String s : files) {
                    ++i;
                    Gson gson = new GsonBuilder().create();
                    File file = new File(filePath, s);
                    String id = s.split(".json")[0];
                    JsonObject j = (JsonObject)gson.fromJson(OtherUtils.readFileToString(file), JsonObject.class);
                    String name = j.get("name").getAsString();
                    String songs = j.get("songs").getAsString();
                    TextComponent message = new TextComponent(Config.prefix + "\u00a7a" + i + "." + id + " : " + name + "(\u00a7e\u5171" + songs + "\u9996\u00a7a)");
                    TextComponent play = new TextComponent("\u00a7r[\u00a7e\u64ad\u653e\u00a7r]\u00a7r");
                    TextComponent show = new TextComponent("\u00a7r[\u00a7e\u67e5\u770b\u00a7r]\u00a7r");
                    if (isGlobal) {
                        play.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " play " + id));
                        show.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " show " + id));
                    } else {
                        play.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist " + platform + " play " + id));
                        show.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist " + platform + " show " + id));
                    }
                    play.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u64ad\u653e\u6b64\u6b4c\u5355").create()));
                    show.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u67e5\u770b\u6b64\u6b4c\u5355").create()));
                    message.addExtra(" ");
                    message.addExtra((BaseComponent)play);
                    message.addExtra(" ");
                    message.addExtra((BaseComponent)show);
                    if (ZMusic.player.hasPermission(player, "zmusic.admin")) {
                        TextComponent playAll = new TextComponent("\u00a7r[\u00a7e\u5168\u670d\u64ad\u653e\u00a7r]\u00a7r");
                        if (isGlobal) {
                            playAll.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " playall " + id));
                            playAll.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u4e3a\u5168\u4f53\u73a9\u5bb6\u64ad\u653e\u6b64\u6b4c\u5355").create()));
                            message.addExtra(" ");
                            message.addExtra((BaseComponent)playAll);
                        }
                    }
                    ZMusic.message.sendJsonMessage(message, player);
                }
            } else {
                ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5728\u5f53\u524d\u5e73\u53f0\u672a\u5bfc\u5165\u8fc7\u4efb\u4f55\u6b4c\u5355", player);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TextComponent message = new TextComponent(Config.prefix + "\u00a7c\u9519\u8bef: \u8bfb\u53d6\u6587\u4ef6\u9519\u8bef,\u8bf7\u5c1d\u8bd5");
            TextComponent update = new TextComponent("\u00a7r[\u00a7e\u66f4\u65b0\u6b4c\u5355\u00a7r]\u00a7r");
            if (isGlobal) {
                update.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " update"));
            } else {
                update.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist " + platform + " update"));
            }
            update.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u66f4\u65b0\u6b64\u5e73\u53f0\u7684\u5168\u90e8\u6b4c\u5355").create()));
            message.addExtra((BaseComponent)update);
            ZMusic.message.sendJsonMessage(message, player);
        }
        ZMusic.message.sendNormalMessage("\u00a76=========================================", player);
    }

    private static void showPlayList(String id, String platform, Object player, boolean isGlobal, int start) {
        Gson gson = new GsonBuilder().create();
        String filePath = "";
        filePath = isGlobal ? ZMusic.dataFolder + "/playlist/global/" + platform + "/" + id + ".json" : ZMusic.dataFolder + "/playlist/" + platform + "/" + ZMusic.player.getName(player) + "/" + id + ".json";
        File file = new File(filePath);
        JsonObject json = (JsonObject)gson.fromJson(OtherUtils.readFileToString(file), JsonObject.class);
        JsonArray list = json.get("list").getAsJsonArray();
        TextComponent messageStart = new TextComponent(Config.prefix + "\u00a76================");
        TextComponent messageEnd = new TextComponent("\u00a76=================");
        TextComponent prev = new TextComponent("\u00a7r[\u00a7e\u4e0a\u4e00\u9875\u00a7r]\u00a7r");
        if (start - 10 >= 0) {
            if (isGlobal) {
                prev.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " show " + id + " " + (start - 10)));
            } else {
                prev.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist " + platform + " show " + id + " " + (start - 10)));
            }
            prev.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u8fd4\u56de\u4e0a\u4e00\u9875").create()));
        } else {
            prev.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u5df2\u7ecf\u5230\u8fbe\u7b2c\u4e00\u9875").create()));
        }
        TextComponent next = new TextComponent("\u00a7r[\u00a7e\u4e0b\u4e00\u9875\u00a7r]\u00a7r");
        if (start + 10 < list.size()) {
            if (isGlobal) {
                next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist global " + platform + " show " + id + " " + (start + 10)));
            } else {
                next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist " + platform + " show " + id + " " + (start + 10)));
            }
            next.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u524d\u5f80\u4e0b\u4e00\u9875").create()));
        } else {
            next.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u5df2\u7ecf\u5230\u8fbe\u6700\u540e\u4e00\u9875").create()));
        }
        TextComponent hr = new TextComponent();
        hr.addExtra((BaseComponent)messageStart);
        hr.addExtra((BaseComponent)prev);
        hr.addExtra((BaseComponent)messageEnd);
        ZMusic.message.sendJsonMessage(hr, player);
        for (int i = start; i < list.size() && i != start + 10; ++i) {
            JsonObject info = list.get(i).getAsJsonObject();
            String name = info.get("name").getAsString();
            String singer = info.get("singer").getAsString();
            String mid = info.get("id").getAsString();
            TextComponent message = new TextComponent(Config.prefix + "\u00a7a" + (i + 1) + "." + name + " - " + singer);
            TextComponent play = new TextComponent("\u00a7r[\u00a7e\u64ad\u653e\u00a7r]\u00a7r");
            TextComponent music = new TextComponent("\u00a7r[\u00a7e\u70b9\u6b4c\u00a7r]\u00a7r");
            TextComponent jump = new TextComponent("\u00a7r[\u00a7e\u8df3\u8f6c\u00a7r]\u00a7r");
            play.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm play " + platform + " -id:" + mid));
            play.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u64ad\u653e").create()));
            music.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm music " + platform + " -id:" + mid));
            music.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u70b9\u6b4c").create()));
            jump.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist jump " + (i + 1) + " " + id));
            jump.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b\u70b9\u51fb\u8df3\u8f6c").create()));
            message.addExtra(" ");
            message.addExtra((BaseComponent)play);
            message.addExtra(" ");
            message.addExtra((BaseComponent)music);
            message.addExtra(" ");
            message.addExtra((BaseComponent)jump);
            ZMusic.message.sendJsonMessage(message, player);
        }
        hr = new TextComponent();
        hr.addExtra((BaseComponent)messageStart);
        hr.addExtra((BaseComponent)next);
        hr.addExtra((BaseComponent)messageEnd);
        ZMusic.message.sendJsonMessage(hr, player);
    }

    private static void playPlayList(String id, String platform, Object p, List<Object> players, boolean isGlobal) {
        if (p != null) {
            players.add(p);
        }
        for (Object player : players) {
            String filePath = "";
            filePath = isGlobal ? ZMusic.dataFolder + "/playlist/global/" + platform : ZMusic.dataFolder + "/playlist/" + platform + "/" + ZMusic.player.getName(player);
            File file = new File(filePath, id + ".json");
            Gson gson = new GsonBuilder().create();
            if (!file.exists()) {
                ZMusic.message.sendErrorMessage("\u9519\u8bef: \u6307\u5b9a\u6b4c\u5355\u4e0d\u5b58\u5728", player);
                return;
            }
            JsonObject json = (JsonObject)gson.fromJson(OtherUtils.readFileToString(file), JsonObject.class);
            String name = json.get("name").getAsString();
            JsonArray list = json.get("list").getAsJsonArray();
            ArrayList<JsonObject> playList = new ArrayList<JsonObject>();
            for (JsonElement j : list) {
                playList.add(j.getAsJsonObject());
            }
            PlayListPlayer plp = PlayerData.getPlayerPlayListPlayer(player);
            if (plp != null) {
                plp.isStop = true;
                PlayerData.setPlayerPlayListPlayer(player, null);
                OtherUtils.resetPlayerStatus(player);
                ZMusic.music.stop(player);
            }
            PlayListPlayer playListPlayer = new PlayListPlayer();
            String type = PlayerData.getPlayerPlayListType(player);
            if (type == null || type.isEmpty()) {
                type = "normal";
            }
            playListPlayer.id = id;
            playListPlayer.playListName = name;
            playListPlayer.type = type;
            playListPlayer.playList = playList;
            playListPlayer.platform = platform;
            playListPlayer.player = player;
            playListPlayer.init();
            ZMusic.runTask.runAsync(playListPlayer);
            PlayerData.setPlayerPlayListPlayer(player, playListPlayer);
        }
    }

    private static void updatePlayListInfo(String platform, Object player, boolean isGlobal) {
        String filePath = "";
        filePath = isGlobal ? ZMusic.dataFolder + "/playlist/global/" + platform : ZMusic.dataFolder + "/playlist/" + platform + "/" + ZMusic.player.getName(player);
        ArrayList<String> files = OtherUtils.queryFileNames(filePath);
        if (files != null) {
            for (String s : files) {
                ZMusic.message.sendNormalMessage("\u00a76=========================================", player);
                switch (platform) {
                    case "qq": {
                        PlayList.importPlayList("playlist/" + s.split("\\.json")[0] + ".html", platform, player, isGlobal);
                        break;
                    }
                    case "netease": {
                        PlayList.importPlayList("playlist?id=" + s.split("\\.json")[0], platform, player, isGlobal);
                        break;
                    }
                }
            }
            ZMusic.message.sendNormalMessage("\u00a76=========================================", player);
        } else {
            ZMusic.message.sendErrorMessage("\u9519\u8bef: \u5728\u5f53\u524d\u5e73\u53f0\u672a\u5bfc\u5165\u8fc7\u4efb\u4f55\u6b4c\u5355", player);
        }
    }
}

