/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.data.PlayerData;
import cn.iqianye.mc.zmusic.language.Lang;
import cn.iqianye.mc.zmusic.music.LyricSender;
import cn.iqianye.mc.zmusic.utils.NetUtils;
import cn.iqianye.mc.zmusic.utils.OtherUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class PlayListPlayer
extends Thread {
    public List<JsonObject> playList;
    public String type = "normal";
    public String id;
    public boolean isStop = false;
    public boolean singleIsPlayEd = true;
    public boolean nextMusic = false;
    public boolean prevMusic = false;
    public boolean jumpMusic = false;
    public int jumpSong = 0;
    public String platform;
    public String playListName;
    public Object player;
    String searchSourceName = "";
    int songs = 0;
    int maxSongs;

    public void init() {
        this.searchSourceName = "";
        switch (this.platform) {
            case "netease": {
                this.searchSourceName = "\u7f51\u6613\u4e91\u97f3\u4e50";
                break;
            }
            case "qq": {
                this.searchSourceName = "QQ\u97f3\u4e50";
            }
        }
        this.maxSongs = this.playList.size();
        --this.maxSongs;
    }

    @Override
    public void run() {
        while (!this.isStop) {
            if (ZMusic.player.isOnline(this.player)) {
                if (this.nextMusic) {
                    if (this.songs != this.maxSongs) {
                        this.singleIsPlayEd = true;
                        this.nextMusic = false;
                    } else {
                        ZMusic.message.sendErrorMessage("\u5207\u6362\u5931\u8d25: \u5df2\u7ecf\u662f\u6700\u540e\u4e00\u9996\u6b4c\u66f2\u4e86", this.player);
                        this.nextMusic = false;
                    }
                }
                if (this.prevMusic) {
                    if (this.songs > 1) {
                        --this.songs;
                        --this.songs;
                        this.singleIsPlayEd = true;
                        this.prevMusic = false;
                    } else {
                        ZMusic.message.sendErrorMessage("\u5207\u6362\u5931\u8d25: \u5df2\u7ecf\u662f\u7b2c\u4e00\u9996\u6b4c\u66f2\u4e86", this.player);
                        this.prevMusic = false;
                    }
                }
                if (this.jumpMusic) {
                    if (this.jumpSong < this.maxSongs) {
                        this.songs = this.jumpSong - 1;
                        this.singleIsPlayEd = true;
                        this.jumpMusic = false;
                    } else {
                        ZMusic.message.sendErrorMessage("\u8df3\u8f6c\u5931\u8d25: \u6307\u5b9a\u7684\u6b4c\u66f2\u4e0d\u5b58\u5728", this.player);
                        this.jumpMusic = false;
                    }
                }
                if (this.singleIsPlayEd) {
                    String id;
                    String nextfullName;
                    long successTime = System.currentTimeMillis();
                    if (!ZMusic.player.isOnline(this.player)) {
                        ZMusic.log.sendDebugMessage("[\u6b4c\u5355] \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")\u68c0\u6d4b\u5230\u73a9\u5bb6[" + ZMusic.player.getName(this.player) + "] \u79bb\u7ebf,\u505c\u6b62\u7ebf\u7a0b\u3002");
                        break;
                    }
                    switch (this.type) {
                        case "normal": {
                            if (this.songs > this.maxSongs) break;
                            ZMusic.log.sendDebugMessage("[\u6b4c\u5355] \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")\u6a21\u5f0f\u4e3a[" + this.type + "],\u5f53\u524d\u97f3\u4e50ID: " + this.songs);
                            break;
                        }
                        case "loop": {
                            if (this.songs > this.maxSongs) {
                                this.songs = 0;
                            }
                            ZMusic.log.sendDebugMessage("[\u6b4c\u5355] \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")\u6a21\u5f0f\u4e3a[" + this.type + "],\u5f53\u524d\u97f3\u4e50ID: " + this.songs);
                            break;
                        }
                        case "random": {
                            Random random = new Random();
                            this.songs = random.nextInt(this.maxSongs);
                            ZMusic.log.sendDebugMessage("[\u6b4c\u5355] \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")\u6a21\u5f0f\u4e3a[" + this.type + "],\u5f53\u524d\u97f3\u4e50ID: " + this.songs);
                            break;
                        }
                        case "stop": {
                            this.isStop = true;
                        }
                    }
                    String name = this.playList.get(this.songs).get("name").getAsString();
                    String singer = this.playList.get(this.songs).get("singer").getAsString();
                    String fullName = name + " - " + singer;
                    switch (this.type) {
                        case "loop": {
                            String nextSinger;
                            String nextName;
                            if (this.songs + 1 > this.maxSongs) {
                                nextName = this.playList.get(0).get("name").getAsString();
                                nextSinger = this.playList.get(0).get("singer").getAsString();
                                nextfullName = nextName + " - " + nextSinger;
                                break;
                            }
                            nextName = this.playList.get(this.songs + 1).get("name").getAsString();
                            nextSinger = this.playList.get(this.songs + 1).get("singer").getAsString();
                            nextfullName = nextName + " - " + nextSinger;
                            break;
                        }
                        case "random": {
                            nextfullName = "\u968f\u673a";
                            break;
                        }
                        default: {
                            String nextSinger;
                            String nextName;
                            if (this.songs + 1 < this.maxSongs) {
                                nextName = this.playList.get(this.songs + 1).get("name").getAsString();
                                nextSinger = this.playList.get(this.songs + 1).get("singer").getAsString();
                                nextfullName = nextName + " - " + nextSinger;
                                break;
                            }
                            nextfullName = "\u5df2\u662f\u6700\u540e\u4e00\u9996";
                        }
                    }
                    long time = this.playList.get(this.songs).get("time").getAsInt();
                    String url = "";
                    JsonObject lyric = null;
                    Gson gson = new GsonBuilder().create();
                    if (this.platform.equalsIgnoreCase("qq")) {
                        id = this.playList.get(this.songs).get("id").getAsString();
                        String mid = this.playList.get(this.songs).get("mid").getAsString();
                        String getMp3Url = Config.qqMusicApiRoot + "song/url?id=" + id + "&mediaId=" + mid;
                        String getMp3JsonText = NetUtils.getNetString(getMp3Url, null);
                        JsonObject getMp3Json = (JsonObject)gson.fromJson(getMp3JsonText, JsonObject.class);
                        try {
                            url = getMp3Json.get("data").getAsString();
                        }
                        catch (Exception e) {
                            ZMusic.message.sendErrorMessage("\u64ad\u653e[\u00a7e" + fullName + "\u00a7c]\u5931\u8d25.", this.player);
                            ZMusic.message.sendErrorMessage("\u65e0\u6cd5\u83b7\u53d6\u64ad\u653e\u94fe\u63a5, \u53ef\u80fd\u65e0\u7248\u6743\u6216\u4e3aVIP\u97f3\u4e50.", this.player);
                            ++this.songs;
                            continue;
                        }
                        String getLyricUrl = Config.qqMusicApiRoot + "lyric?songmid=" + id;
                        String lyricJsonText = NetUtils.getNetString(getLyricUrl, null);
                        JsonObject lyricJson = (JsonObject)gson.fromJson(lyricJsonText, JsonObject.class);
                        String lyricText = lyricJson.get("data").getAsJsonObject().get("lyric").getAsString();
                        lyricText = lyricText.replaceAll("&apos;", "'");
                        lyricText = lyricText.replaceAll("\r", "");
                        String lyricTrText = lyricJson.get("data").getAsJsonObject().get("trans").getAsString();
                        lyricTrText = lyricTrText.replaceAll("&apos;", "'");
                        lyricTrText = lyricTrText.replaceAll("\r", "");
                        if (lyricText.isEmpty()) {
                            ZMusic.message.sendErrorMessage("\u672a\u627e\u5230\u6b4c\u8bcd\u4fe1\u606f", this.player);
                        }
                        if (lyricTrText.isEmpty()) {
                            ZMusic.message.sendErrorMessage("\u672a\u627e\u5230\u6b4c\u8bcd\u7ffb\u8bd1", this.player);
                        }
                        lyric = OtherUtils.formatLyric(lyricText, lyricTrText);
                    } else if (this.platform.equalsIgnoreCase("netease")) {
                        id = this.playList.get(this.songs).get("id").getAsString();
                        String getMp3Url = Config.neteaseApiRoot + "song/url?id=" + id + "&br=320000";
                        String getMp3JsonText = NetUtils.getNetString(getMp3Url, null);
                        JsonObject getMp3Json = (JsonObject)gson.fromJson(getMp3JsonText, JsonObject.class);
                        try {
                            url = getMp3Json.get("data").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString();
                        }
                        catch (Exception e) {
                            for (String s : Lang.playListPlayError) {
                                ZMusic.message.sendErrorMessage(s.replaceAll("%musicName%", fullName), this.player);
                            }
                            ++this.songs;
                            continue;
                        }
                        String lyricJsonText = NetUtils.getNetString(Config.neteaseApiRoot + "lyric?id=" + id, null);
                        JsonObject lyricJson = (JsonObject)gson.fromJson(lyricJsonText, JsonObject.class);
                        String lyricText = "";
                        String lyricTrText = "";
                        try {
                            lyricText = lyricJson.get("lrc").getAsJsonObject().get("lyric").getAsString();
                            lyricText = lyricText.replaceAll("\r", "");
                            lyricTrText = lyricJson.get("tlyric").getAsJsonObject().get("lyric").getAsString();
                            lyricTrText = lyricTrText.replaceAll("\r", "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        lyric = OtherUtils.formatLyric(lyricText, lyricTrText);
                    }
                    OtherUtils.resetPlayerStatus(this.player);
                    LyricSender lyricSender = PlayerData.getPlayerLyricSender(this.player);
                    if (lyricSender != null) {
                        lyricSender.stopThis();
                    }
                    lyricSender = new LyricSender();
                    PlayerData.setPlayerLyricSender(this.player, lyricSender);
                    lyricSender.player = this.player;
                    lyricSender.lyric = lyric;
                    lyricSender.maxTime = time;
                    lyricSender.name = name;
                    lyricSender.singer = singer;
                    lyricSender.fullName = fullName;
                    lyricSender.platform = this.searchSourceName;
                    lyricSender.src = "\u6b4c\u5355<" + this.playListName + ">";
                    lyricSender.url = url;
                    lyricSender.isPlayList = true;
                    lyricSender.nextMusicName = nextfullName;
                    lyricSender.playListPlayer = this;
                    lyricSender.init();
                    ZMusic.runTask.runAsync(lyricSender);
                    ZMusic.music.play(url, this.player);
                    this.singleIsPlayEd = false;
                    successTime = System.currentTimeMillis() - successTime;
                    ZMusic.log.sendDebugMessage("[\u6b4c\u5355] \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")\u4e3a[" + ZMusic.player.getName(this.player) + "]\u64ad\u653e\u6b4c\u5355<" + this.playListName + ">\u4e2d\u7684" + fullName);
                    TextComponent message = new TextComponent(Config.prefix + "\u00a7a" + Lang.playSuccess.replaceAll("%source%", this.searchSourceName).replaceAll("%fullName%", fullName).replaceAll("%time%", String.valueOf(successTime)));
                    TextComponent prev = new TextComponent("\u00a7r[\u00a7e" + Lang.clickPrev + "\u00a7r]\u00a7r");
                    prev.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist prev"));
                    prev.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b" + Lang.clickPrevText).create()));
                    TextComponent next = new TextComponent("\u00a7r[\u00a7e" + Lang.clickNext + "\u00a7r]\u00a7r");
                    next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm playlist next"));
                    next.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b" + Lang.clickNextText).create()));
                    message.addExtra(" ");
                    message.addExtra((BaseComponent)prev);
                    message.addExtra(" ");
                    message.addExtra((BaseComponent)next);
                    ZMusic.message.sendJsonMessage(message, this.player);
                    String title = "\u00a7a" + Lang.playing + "\n\u00a7e" + fullName;
                    OtherUtils.sendAdv(this.player, title);
                    ++this.songs;
                }
            } else {
                ZMusic.log.sendDebugMessage("[\u6b4c\u5355]\u73a9\u5bb6\u79bb\u7ebf \u6b4c\u5355\u64ad\u653e\u5668(ID:" + this.getId() + ")[" + ZMusic.player.getName(this.player) + "]<" + this.playListName + ">\u7ebf\u7a0b\u5df2\u505c\u6b62\u3002");
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

