/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.data.PlayerData;
import cn.iqianye.mc.zmusic.language.Lang;
import cn.iqianye.mc.zmusic.music.LyricSender;
import cn.iqianye.mc.zmusic.music.PlayListPlayer;
import cn.iqianye.mc.zmusic.music.searchSource.BiliBiliMusic;
import cn.iqianye.mc.zmusic.music.searchSource.KuGouMusic;
import cn.iqianye.mc.zmusic.music.searchSource.KuwoMusic;
import cn.iqianye.mc.zmusic.music.searchSource.NeteaseCloudMusic;
import cn.iqianye.mc.zmusic.music.searchSource.QQMusic;
import cn.iqianye.mc.zmusic.utils.OtherUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class PlayMusic {
    static String[] errMsg;
    static String musicID;
    static String musicName;
    static String musicSinger;
    static String musicFullName;
    static String musicUrl;
    static JsonObject musicLyric;
    static long musicMaxTime;
    static String searchSourceName;
    static JsonObject json;

    public static void play(String searchKey, String source, Object player, String type, List<Object> players) {
        try {
            boolean supportId;
            long time = System.currentTimeMillis();
            ZMusic.message.sendNormalMessage(Lang.searching, player);
            switch (source) {
                case "163": 
                case "netease": {
                    json = NeteaseCloudMusic.getMusicUrl(searchKey);
                    searchSourceName = "\u7f51\u6613\u4e91\u97f3\u4e50";
                    break;
                }
                case "qq": {
                    json = QQMusic.getMusicUrl(searchKey);
                    searchSourceName = "QQ\u97f3\u4e50";
                    break;
                }
                case "kugou": {
                    json = KuGouMusic.getMusicUrl(searchKey);
                    searchSourceName = "\u9177\u72d7\u97f3\u4e50";
                    break;
                }
                case "kuwo": {
                    json = KuwoMusic.getMusicUrl(searchKey);
                    searchSourceName = "\u9177\u6211\u97f3\u4e50";
                    break;
                }
                case "bilibili": {
                    if (ZMusic.bilibiliIsVIP) {
                        ZMusic.message.sendNormalMessage("\u54d4\u54e9\u54d4\u54e9\u97f3\u4e50\u9700\u8981\u5728\u63d2\u4ef6\u670d\u52a1\u5668\u5c06M4A\u8f6c\u6362\u4e3aMP3\u3002", player);
                        ZMusic.message.sendNormalMessage("\u7b2c\u4e00\u6b21\u641c\u7d22\u5c06\u4f1a\u8017\u65f6\u5f88\u4e45\uff0c\u5982\u6709\u5176\u4ed6\u7528\u6237\u4f7f\u7528\u8fc7\uff0c\u5c06\u4f1a\u8fd4\u56de\u7f13\u5b58\u6587\u4ef6\u3002", player);
                        ZMusic.message.sendNormalMessage("\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002\u3002\u3002\u3002", player);
                        json = BiliBiliMusic.getMusic(searchKey);
                        searchSourceName = "\u54d4\u54e9\u54d4\u54e9\u97f3\u4e50";
                        break;
                    }
                    ZMusic.message.sendErrorMessage("\u9519\u8bef,\u672c\u670d\u52a1\u5668\u672a\u6388\u6743.", player);
                    return;
                }
                default: {
                    ZMusic.message.sendErrorMessage("\u9519\u8bef\uff1a\u672a\u77e5\u7684\u641c\u7d22\u6e90", player);
                    return;
                }
            }
            boolean bl = supportId = source.equalsIgnoreCase("163") || source.equalsIgnoreCase("netease") || source.equalsIgnoreCase("qq") || source.equalsIgnoreCase("bilibili");
            if (json != null) {
                if (supportId) {
                    musicID = json.get("id").getAsString();
                }
            } else {
                ZMusic.message.sendPlayError(player, searchKey);
                return;
            }
            musicName = json.get("name").getAsString();
            musicSinger = json.get("singer").getAsString();
            musicFullName = musicName + " - " + musicSinger;
            musicUrl = json.get("url").getAsString();
            musicLyric = OtherUtils.formatLyric(json.get("lyric").getAsString(), json.get("lyricTr").getAsString());
            musicMaxTime = json.get("time").getAsInt();
            errMsg = json.get("error").getAsString().split("\n");
            switch (type) {
                case "all": {
                    PlayMusic.play(null, players, Lang.playAllSource.replaceAll("%player%", ZMusic.player.getName(player)), time);
                    break;
                }
                case "self": {
                    PlayMusic.play(player, new ArrayList<Object>(), "\u641c\u7d22", time);
                    break;
                }
                case "music": {
                    String s = Lang.musicMessage;
                    String prefix = "\u00a7a" + s.split("%fullName%")[0];
                    TextComponent message = new TextComponent(Config.prefix + prefix.replaceAll("%player%", ZMusic.player.getName(player)).replaceAll("%source%", searchSourceName));
                    TextComponent music = new TextComponent("\u00a7r[\u00a7e" + musicFullName + "\u00a7r]");
                    music.setColor(ChatColor.YELLOW);
                    if (supportId) {
                        music.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm play " + source + " -id:" + musicID));
                    } else {
                        music.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/zm play " + source + " " + musicName));
                    }
                    music.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7b" + Lang.clickPlayText).create()));
                    message.addExtra((BaseComponent)music);
                    String suffix = s.split("%fullName%")[1];
                    message.addExtra(suffix);
                    for (Object p : players) {
                        ZMusic.message.sendJsonMessage(message, p);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ZMusic.message.sendPlayError(player, searchKey);
        }
    }

    private static void play(Object player, List<Object> players, String src, long time) {
        if (player != null) {
            players.add(player);
        }
        for (Object p : players) {
            LyricSender lyricSender;
            OtherUtils.resetPlayerStatus(p);
            PlayListPlayer plp = PlayerData.getPlayerPlayListPlayer(p);
            if (plp != null) {
                plp.isStop = true;
                PlayerData.setPlayerPlayListPlayer(p, null);
            }
            if ((lyricSender = PlayerData.getPlayerLyricSender(p)) != null) {
                lyricSender.stopThis();
            }
            lyricSender = new LyricSender();
            PlayerData.setPlayerLyricSender(p, lyricSender);
            lyricSender.player = p;
            lyricSender.lyric = musicLyric;
            lyricSender.maxTime = musicMaxTime;
            lyricSender.name = musicName;
            lyricSender.singer = musicSinger;
            lyricSender.fullName = musicFullName;
            lyricSender.platform = searchSourceName;
            lyricSender.src = src;
            lyricSender.url = musicUrl;
            lyricSender.init();
            ZMusic.runTask.runAsync(lyricSender);
            for (String msg : errMsg) {
                if (msg.isEmpty()) continue;
                ZMusic.message.sendErrorMessage(msg, p);
            }
            ZMusic.music.play(musicUrl, p);
            time = System.currentTimeMillis() - time;
            ZMusic.message.sendNormalMessage(Lang.playSuccess.replaceAll("%source%", searchSourceName).replaceAll("%fullName%", musicFullName).replaceAll("%time%", String.valueOf(time)), p);
            String title = "\u00a7a" + Lang.playing + "\n\u00a7e" + musicFullName;
            OtherUtils.sendAdv(p, title);
        }
    }
}

