/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music.searchSource;

import cn.iqianye.mc.zmusic.utils.NetUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class KuGouMusic {
    public static JsonObject getMusicUrl(String musicName) {
        try {
            String getUrl = "https://songsearch.kugou.com/song_search_v2?keyword=" + URLEncoder.encode(musicName, "utf-8") + "&platform=WebFilter&format=json&page=1&pagesize=1";
            String jsonText = NetUtils.getNetString(getUrl, null);
            Gson gson = new Gson();
            JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
            if (json.get("status").getAsInt() == 1) {
                JsonObject data = json.get("data").getAsJsonObject();
                JsonObject list = data.getAsJsonArray("lists").get(0).getAsJsonObject();
                String songName = list.get("SongName").getAsString();
                String songSinger = list.get("SingerName").getAsString();
                String hash = list.get("FileHash").getAsString();
                String id = list.get("ID").getAsString();
                String getInfoUrl = "http://m.kugou.com/app/i/getSongInfo.php?cmd=playInfo&hash=" + hash;
                String infoJsonText = NetUtils.getNetString(getInfoUrl, "http://m.kugou.com/play/info/" + id);
                JsonObject infoJosn = (JsonObject)gson.fromJson(infoJsonText, JsonObject.class);
                String song_url = infoJosn.get("url").getAsString();
                int song_time = infoJosn.get("timeLength").getAsInt();
                String getLyricInfoUrl = "http://krcs.kugou.com/search?ver=1&man=yes&client=mobi&keyword=&duration=&hash=" + hash;
                String lyricInfoStr = NetUtils.getNetString(getLyricInfoUrl, null);
                JsonObject getLyrrcJson = (JsonObject)gson.fromJson(lyricInfoStr, JsonObject.class);
                String lyricID = "";
                String lyricAccessKey = "";
                try {
                    JsonObject candidates = getLyrrcJson.getAsJsonArray("candidates").get(0).getAsJsonObject();
                    lyricID = candidates.get("id").getAsString();
                    lyricAccessKey = candidates.get("accesskey").getAsString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String getLyricUrl = "http://lyrics.kugou.com/download?ver=1&id=" + lyricID + "&accesskey=" + lyricAccessKey + "&fmt=lrc&charset=utf8";
                String lyricStr = NetUtils.getNetString(getLyricUrl, null);
                JsonObject lyricJSON = (JsonObject)gson.fromJson(lyricStr, JsonObject.class);
                String lyricBase64 = lyricJSON.get("content").getAsString();
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytes = decoder.decode(lyricBase64);
                String lyric = new String(bytes, StandardCharsets.UTF_8);
                lyric = lyric.replaceAll("\r", "");
                StringBuilder sb = new StringBuilder();
                sb.append("\u9177\u72d7\u97f3\u4e50\u6682\u4e0d\u652f\u6301\u7ffb\u8bd1\u663e\u793a\n");
                JsonObject returnObject = new JsonObject();
                returnObject.addProperty("name", songName);
                returnObject.addProperty("singer", songSinger);
                returnObject.addProperty("time", (Number)song_time);
                returnObject.addProperty("url", song_url);
                returnObject.addProperty("lyric", lyric);
                returnObject.addProperty("lyricTr", "");
                returnObject.addProperty("error", sb.toString());
                return returnObject;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonArray getMusicList(String musicName) {
        try {
            String getUrl = "https://songsearch.kugou.com/song_search_v2?keyword=" + URLEncoder.encode(musicName, "utf-8") + "&platform=WebFilter&format=json&page=1&pagesize=10";
            String jsonText = NetUtils.getNetString(getUrl, null);
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
            if (json.get("status").getAsInt() == 1) {
                JsonObject data = json.get("data").getAsJsonObject();
                JsonArray list = data.getAsJsonArray("lists");
                JsonArray returnJson = new JsonArray();
                for (JsonElement j : list) {
                    String songName = j.getAsJsonObject().get("SongName").getAsString();
                    String songSinger = j.getAsJsonObject().get("SingerName").getAsString();
                    JsonObject returnJsonObj = new JsonObject();
                    returnJsonObj.addProperty("name", songName);
                    returnJsonObj.addProperty("singer", songSinger);
                    returnJson.add((JsonElement)returnJsonObj);
                }
                return returnJson;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

