/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.music.searchSource;

import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.utils.NetUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URLEncoder;

public class NeteaseCloudMusic {
    public static JsonObject getMusicUrl(String musicName) {
        try {
            String getUrl;
            String jsonText;
            Gson gson;
            JsonObject json;
            JsonObject result;
            if (musicName.contains("-id:")) {
                musicName = musicName.split("-id:")[1];
            }
            if ((result = (json = (JsonObject)(gson = new Gson()).fromJson(jsonText = NetUtils.getNetString(getUrl = Config.neteaseApiRoot + "search?keywords=" + URLEncoder.encode(musicName, "UTF-8") + "&limit=1&type=1", null), JsonObject.class)).getAsJsonObject("result")) != null || result.get("songCount").getAsInt() != 0) {
                JsonObject jsonOut = result.getAsJsonArray("songs").get(0).getAsJsonObject();
                int musicID = jsonOut.get("id").getAsInt();
                JsonObject getUrlJson = (JsonObject)gson.fromJson(NetUtils.getNetString(Config.neteaseApiRoot + "song/url?id=" + musicID + "&br=320000", null), JsonObject.class);
                String musicUrl = null;
                try {
                    musicUrl = getUrlJson.get("data").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String lyricJsonText = NetUtils.getNetString(Config.neteaseApiRoot + "lyric?id=" + musicID, null);
                JsonObject lyricJson = (JsonObject)gson.fromJson(lyricJsonText, JsonObject.class);
                String name = jsonOut.get("name").getAsString();
                int inttime = jsonOut.get("duration").getAsInt();
                String time = String.valueOf(inttime /= 1000);
                JsonArray singer = jsonOut.get("artists").getAsJsonArray();
                String singerName = "";
                for (JsonElement j : singer) {
                    singerName = singerName + j.getAsJsonObject().get("name").getAsString() + "/";
                }
                singerName = singerName.substring(0, singerName.length() - 1);
                String lyric = "";
                String lyricTr = "";
                try {
                    lyric = lyricJson.get("lrc").getAsJsonObject().get("lyric").getAsString();
                    lyric = lyric.replaceAll("\r", "");
                    lyricTr = lyricJson.get("tlyric").getAsJsonObject().get("lyric").getAsString();
                    lyricTr = lyricTr.replaceAll("\r", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StringBuilder sb = new StringBuilder();
                JsonObject returnJson = new JsonObject();
                returnJson.addProperty("id", (Number)musicID);
                returnJson.addProperty("url", musicUrl);
                returnJson.addProperty("time", time);
                returnJson.addProperty("name", name);
                returnJson.addProperty("singer", singerName);
                returnJson.addProperty("lyric", lyric);
                returnJson.addProperty("lyricTr", lyricTr);
                returnJson.addProperty("error", sb.toString());
                return returnJson;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonArray getMusicList(String musicName) {
        try {
            String getUrl = Config.neteaseApiRoot + "search?keywords=" + URLEncoder.encode(musicName, "UTF-8") + "&limit=10&type=1";
            Gson gson = new GsonBuilder().create();
            String jsonText = NetUtils.getNetString(getUrl, null);
            JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
            JsonObject result = json.getAsJsonObject("result");
            JsonArray returnJson = new JsonArray();
            if (result != null || result.get("songCount").getAsInt() != 0) {
                JsonArray jsonOut = result.getAsJsonArray("songs");
                for (JsonElement j : jsonOut) {
                    String name = j.getAsJsonObject().get("name").getAsString();
                    int musicID = j.getAsJsonObject().get("id").getAsInt();
                    JsonArray singer = j.getAsJsonObject().get("artists").getAsJsonArray();
                    String singerName = "";
                    for (JsonElement js : singer) {
                        singerName = singerName + js.getAsJsonObject().get("name").getAsString() + "/";
                    }
                    singerName = singerName.substring(0, singerName.length() - 1);
                    JsonObject returnJsonObj = new JsonObject();
                    returnJsonObj.addProperty("id", (Number)musicID);
                    returnJsonObj.addProperty("name", name);
                    returnJsonObj.addProperty("singer", singerName);
                    returnJson.add((JsonElement)returnJsonObj);
                }
                return returnJson;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonObject getMusicSongList(String playListId) {
        try {
            String getUrl = Config.neteaseApiRoot + "playlist/detail?id=" + playListId;
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(NetUtils.getNetString(getUrl, null), JsonObject.class);
            JsonArray trackIds = json.get("playlist").getAsJsonObject().get("trackIds").getAsJsonArray();
            String playListName = json.getAsJsonObject("playlist").get("name").getAsString();
            int playListSongs = json.getAsJsonObject("playlist").get("trackCount").getAsInt();
            if (playListSongs > 1000) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (JsonElement jsonElement : trackIds) {
                sb.append(jsonElement.getAsJsonObject().get("id").getAsString()).append(",");
            }
            String s = sb.toString();
            s = s.substring(0, s.length() - 1);
            JsonObject playListInfo = (JsonObject)gson.fromJson(NetUtils.getNetString(Config.neteaseApiRoot + "song/detail", null, "ids=" + s), JsonObject.class);
            JsonArray songList = playListInfo.get("songs").getAsJsonArray();
            JsonObject returnJson = new JsonObject();
            JsonArray returnJsonArr = new JsonArray();
            for (JsonElement jsonElement : songList) {
                String songName = jsonElement.getAsJsonObject().get("name").getAsString();
                int songTime = jsonElement.getAsJsonObject().get("dt").getAsInt();
                songTime /= 1000;
                JsonArray ar = jsonElement.getAsJsonObject().get("ar").getAsJsonArray();
                StringBuilder singer = new StringBuilder();
                for (JsonElement j : ar) {
                    try {
                        singer.append(j.getAsJsonObject().get("name").getAsString()).append("/");
                    }
                    catch (Exception exception) {}
                }
                if (singer.length() - 1 >= 0) {
                    singer = new StringBuilder(singer.substring(0, singer.length() - 1));
                } else {
                    singer.append("\u65e0");
                }
                String songId = jsonElement.getAsJsonObject().get("id").getAsString();
                JsonObject returnJsonObj = new JsonObject();
                returnJsonObj.addProperty("id", songId);
                returnJsonObj.addProperty("name", songName);
                returnJsonObj.addProperty("singer", singer.toString());
                returnJsonObj.addProperty("time", (Number)songTime);
                returnJsonArr.add((JsonElement)returnJsonObj);
            }
            returnJson.addProperty("name", playListName);
            returnJson.addProperty("songs", (Number)playListSongs);
            returnJson.add("list", (JsonElement)returnJsonArr);
            return returnJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

