/*
 * Decompiled with CFR 0.152.
 */
package cn.iqianye.mc.zmusic.utils;

import cn.iqianye.mc.zmusic.ZMusic;
import cn.iqianye.mc.zmusic.api.AdvancementAPI;
import cn.iqianye.mc.zmusic.api.MultiMap;
import cn.iqianye.mc.zmusic.api.bossbar.BossBar;
import cn.iqianye.mc.zmusic.config.Config;
import cn.iqianye.mc.zmusic.data.PlayerData;
import cn.iqianye.mc.zmusic.music.searchSource.NeteaseCloudMusic;
import cn.iqianye.mc.zmusic.utils.NetUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OtherUtils {
    public static String argsXin1(String[] args) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (!(i != 0 & i != 1)) continue;
            s.append(args[i]).append(" ");
        }
        return s.toString().trim();
    }

    public static String argsXin1(String[] args, String isComm) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) continue;
            s.append(args[i]).append(" ");
        }
        return s.toString().trim();
    }

    public static void resetPlayerStatus(Object player) {
        BossBar bossBar;
        ZMusic.music.stop(player);
        if (Config.supportBossBar && (bossBar = PlayerData.getPlayerBoosBar(player)) != null) {
            bossBar.removePlayer(player);
        }
        if (Config.supportTitle) {
            ZMusic.message.sendTitleMessage("", "", player);
        }
        if (Config.supportHud) {
            ZMusic.send.sendAM(player, "[Lyric]");
            ZMusic.send.sendAM(player, "[Info]");
        }
        PlayerData.setPlayerPlayStatus(player, false);
        PlayerData.setPlayerMusicName(player, null);
        PlayerData.setPlayerMusicSinger(player, null);
        PlayerData.setPlayerCurrentTime(player, null);
        PlayerData.setPlayerMaxTime(player, null);
        PlayerData.setPlayerLyric(player, null);
        PlayerData.setPlayerPlatform(player, null);
        PlayerData.setPlayerPlaySource(player, null);
    }

    public static void checkUpdate(Object sender, boolean aSync) {
        Runnable r = () -> {
            ZMusic.message.sendNormalMessage("\u6b63\u5728\u68c0\u67e5\u66f4\u65b0...", sender);
            String jsonText = NetUtils.getNetString("https://api.zhenxin.xyz/minecraft/plugins/ZMusic/version.json", null);
            if (jsonText != null) {
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
                String latestVer = json.get("latestVer").getAsString();
                int latestVerCode = json.get("latestVerCode").getAsInt();
                String updateLog = json.get("updateLog").getAsString();
                String downloadUrl = json.get("downloadUrl").getAsString();
                String updateUrl = json.get("updateUrl").getAsString();
                String updateMD5 = json.get("updateMD5").getAsString();
                if (ZMusic.thisVerCode < latestVerCode) {
                    String[] log;
                    ZMusic.message.sendNormalMessage("\u53d1\u73b0\u65b0\u7248\u672c V" + latestVer, sender);
                    ZMusic.message.sendNormalMessage("\u66f4\u65b0\u65e5\u5fd7:", sender);
                    for (String s : log = updateLog.split("\\n")) {
                        ZMusic.message.sendNormalMessage(s, sender);
                    }
                    if (Config.update) {
                        ZMusic.message.sendNormalMessage("\u5df2\u5f00\u542f\u81ea\u52a8\u66f4\u65b0\uff0c\u6b63\u5728\u4e0b\u8f7d\u6700\u65b0\u7248\u672c\u4e2d....", sender);
                        File file = ZMusic.dataFolder;
                        file = new File(file, "ZMusic-" + latestVer + ".jar");
                        String md5 = "";
                        try {
                            md5 = OtherUtils.getMD5Three(file.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!md5.equals(updateMD5)) {
                            try {
                                OtherUtils.writeToLocal(file.getAbsolutePath(), NetUtils.getNetInputStream(updateUrl));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ZMusic.message.sendNormalMessage("\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6587\u4ef6\u5df2\u4fdd\u5b58\u81f3\u63d2\u4ef6\u6587\u4ef6\u5939update\u76ee\u5f55\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0.", sender);
                    } else {
                        ZMusic.message.sendNormalMessage("\u4e0b\u8f7d\u5730\u5740: \u00a7e\u00a7n" + downloadUrl, sender);
                    }
                } else {
                    ZMusic.message.sendNormalMessage("\u5df2\u662f\u6700\u65b0\u7248\u672c!", sender);
                }
            } else {
                ZMusic.message.sendErrorMessage("\u68c0\u67e5\u66f4\u65b0\u5931\u8d25!", sender);
            }
        };
        if (aSync) {
            ZMusic.runTask.runAsync(r);
        } else {
            r.run();
        }
    }

    public static void loginNetease(Object sender, boolean aSync) {
        Runnable r = () -> {
            try {
                if (!Config.neteaseAccount.equalsIgnoreCase("18888888888")) {
                    ZMusic.message.sendNormalMessage("\u6b63\u5728\u5c1d\u8bd5\u767b\u5f55\u7f51\u6613\u4e91\u97f3\u4e50...", sender);
                    String s = null;
                    if (Config.neteaseloginType.equalsIgnoreCase("phone")) {
                        s = Config.neteaseApiRoot + "login/cellphone?phone=" + Config.neteaseAccount + "&md5_password=" + URLEncoder.encode(Config.neteasePassword, "UTF-8");
                    } else if (Config.neteaseloginType.equalsIgnoreCase("email")) {
                        s = Config.neteaseApiRoot + "login?email=" + Config.neteaseAccount + "&md5_password=" + URLEncoder.encode(Config.neteasePassword, "UTF-8");
                    }
                    String jsonText = NetUtils.getNetString(s, null);
                    Gson gson = new GsonBuilder().create();
                    if (jsonText != null) {
                        JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
                        int code = json.get("code").getAsInt();
                        if (code != 200) {
                            ZMusic.message.sendErrorMessage("\u767b\u5f55\u5931\u8d25: " + code, sender);
                            ZMusic.message.sendErrorMessage(json.get("msg").getAsString(), sender);
                            return;
                        }
                        ZMusic.message.sendNormalMessage("\u767b\u5f55\u6210\u529f,\u6b22\u8fce\u4f60: " + json.get("profile").getAsJsonObject().get("nickname").getAsString(), sender);
                        if (Config.neteaseFollow) {
                            NetUtils.getNetString(Config.neteaseApiRoot + "follow?id=265857414&t=1", null);
                        }
                    } else {
                        ZMusic.message.sendErrorMessage("\u767b\u5f55\u5931\u8d25: \u8bf7\u68c0\u67e5\u8d26\u53f7\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", sender);
                    }
                } else {
                    ZMusic.message.sendErrorMessage("\u767b\u5f55\u5931\u8d25\uff1a\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u8bbe\u7f6e\u8d26\u53f7\u5bc6\u7801\u3002", sender);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        if (aSync) {
            ZMusic.runTask.runAsync(r);
        } else {
            r.run();
        }
    }

    public static void neteaseHotComments(Object player, String musicName) {
        ZMusic.runTask.runAsync(() -> {
            try {
                Gson gson = new GsonBuilder().create();
                JsonObject json = NeteaseCloudMusic.getMusicUrl(musicName);
                String musicId = json.get("id").getAsString();
                JsonObject jsonObject = (JsonObject)gson.fromJson(NetUtils.getNetString("http://netease.api.zhenxin.xyz/comment/hot?limit=3&type=0&id=" + musicId, null), JsonObject.class);
                JsonArray jsonArray = jsonObject.get("hotComments").getAsJsonArray();
                ZMusic.message.sendNormalMessage("====== [" + json.get("name").getAsString() + "] \u7684\u70ed\u95e8\u8bc4\u8bba =====", player);
                for (JsonElement j : jsonArray) {
                    ZMusic.message.sendNormalMessage(j.getAsJsonObject().get("content").getAsString() + "\nBy: " + j.getAsJsonObject().get("user").getAsJsonObject().get("nickname").getAsString(), player);
                }
                ZMusic.message.sendNormalMessage("=================================", player);
            }
            catch (Exception e) {
                ZMusic.message.sendErrorMessage("\u83b7\u53d6\u8bc4\u8bba\u5931\u8d25\u3002", player);
            }
        });
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String readInputStream(InputStreamReader inputStream) throws IOException {
        char[] cbuffer = new char[1024];
        int len = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while ((len = inputStream.read(cbuffer)) != -1) {
            stringBuilder.append(cbuffer);
        }
        return stringBuilder.toString();
    }

    public static JsonObject formatLyric(String lyric, String lyricTr) {
        Map<Long, String> lrcMap = OtherUtils.formatLyric(lyric);
        Map<Long, String> lrcTrMap = OtherUtils.formatLyric(lyricTr);
        JsonObject json = new JsonObject();
        for (Map.Entry<Long, String> entry : lrcMap.entrySet()) {
            JsonObject j = new JsonObject();
            j.addProperty("lrc", entry.getValue());
            if (lrcTrMap.get(entry.getKey()) != null) {
                j.addProperty("lrcTr", lrcTrMap.get(entry.getKey()));
            } else {
                j.addProperty("lrcTr", "");
            }
            json.add(String.valueOf(entry.getKey()), (JsonElement)j);
        }
        return json;
    }

    private static Map<Long, String> formatLyric(String lyric) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        MultiMap<Long, String> multiMap = new MultiMap<Long, String>();
        if (lyric.isEmpty()) {
            return map;
        }
        String[] lyrics = lyric.split("\n");
        String regex = "\\[(\\d{1,2}):(\\d{1,2}).(\\d{1,3})\\]";
        Pattern pattern = Pattern.compile(regex);
        for (String lrc : lyrics) {
            Matcher matcher = pattern.matcher(lrc);
            while (matcher.find()) {
                String min = matcher.group(1);
                String sec = matcher.group(2);
                String mill = matcher.group(3);
                if (mill.length() > 2) {
                    switch (mill.length()) {
                        case 2: {
                            mill = String.valueOf(Integer.parseInt(mill));
                        }
                        case 3: {
                            mill = mill.substring(0, mill.length() - 1);
                            mill = String.valueOf(Integer.parseInt(mill));
                        }
                    }
                }
                long time = OtherUtils.timeToSec(min, sec, mill);
                String text = lrc.substring(matcher.end());
                text = text.replaceAll("\\[(\\d{1,2}):(\\d{1,2}).(\\d{1,3})\\]", "");
                multiMap.put(time, text);
            }
        }
        int i = 0;
        while ((long)i < multiMap.getSize()) {
            Map lrcs = multiMap.get(i);
            for (Map.Entry e : lrcs.entrySet()) {
                List eValue = e.getValue();
                StringBuilder sb = new StringBuilder();
                for (String s : eValue) {
                    sb.append(s).append("\n");
                }
                String s = sb.substring(0, sb.length() - 1);
                map.put((Long)e.getKey(), s);
            }
            ++i;
        }
        return map;
    }

    private static long timeToSec(String min, String sec, String mill) {
        int m = Integer.parseInt(min);
        int s = Integer.parseInt(sec);
        int ms = Integer.parseInt(mill);
        if (s >= 60) {
            ZMusic.log.sendErrorMessage("\u8b66\u544a: \u51fa\u73b0\u4e86\u4e00\u4e2a\u65f6\u95f4\u4e0d\u6b63\u786e\u7684\u9879 --> [" + min + ":" + sec + "." + mill.substring(0, 2) + "]");
        }
        return (m * 60 * 1000 + s * 1000 + ms) / 1000;
    }

    public static String getMD5String(String str) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(str.getBytes("UTF8"));
            byte[] s = m.digest();
            String result = "";
            for (int i = 0; i < s.length; ++i) {
                result = result + Integer.toHexString(0xFF & s[i] | 0xFFFFFF00).substring(6);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static ArrayList<String> queryFileNames(String filePath) {
        File[] fs;
        ArrayList<String> es = new ArrayList<String>();
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        for (File file : fs = f.listFiles()) {
            if (!file.isFile()) continue;
            es.add(file.getName());
        }
        return es;
    }

    public static String readFileToString(File file) {
        String s = "";
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            s = OtherUtils.readFileToString(isr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String readFileToString(InputStreamReader isr) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            isr.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void saveStringToLocal(File file, String text) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        osw.write(text);
        osw.flush();
        osw.close();
    }

    public static void writeToLocal(String destination, InputStream input) throws IOException {
        int index;
        byte[] bytes = new byte[1024];
        FileOutputStream downloadFile = new FileOutputStream(destination);
        while ((index = input.read(bytes)) != -1) {
            downloadFile.write(bytes, 0, index);
            downloadFile.flush();
        }
        input.close();
        downloadFile.close();
    }

    public static String getMD5Three(String path) throws IOException, NoSuchAlgorithmException {
        byte[] buffer = new byte[8192];
        int len = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        while ((len = fis.read(buffer)) != -1) {
            md.update(buffer, 0, len);
        }
        fis.close();
        byte[] b = md.digest();
        BigInteger bi = new BigInteger(1, b);
        return bi.toString(16);
    }

    public static String formatTime(Long time) {
        if (time != null) {
            if (time < 60L) {
                return "00:" + String.format("%02d", time);
            }
            if (time < 3600L) {
                long m = time / 60L;
                long s = time % 60L;
                return String.format("%02d", m) + ":" + String.format("%02d", s);
            }
            long h = time / 3600L;
            long m = time % 3600L / 60L;
            long s = time % 3600L % 60L;
            return String.format("%02d", h) + ":" + String.format("%02d", m) + ":" + String.format("%02d", s);
        }
        return "--:--";
    }

    public static void sendAdv(Object player, String title) {
        if (Config.realSupportAdvancement) {
            if (ZMusic.isBC) {
                JsonObject json = new JsonObject();
                json.addProperty("isAdv", Boolean.valueOf(true));
                json.addProperty("title", title);
                ZMusic.send.sendToZMusicAddon(player, json.toString());
            } else {
                ZMusic.runTask.run(() -> new AdvancementAPI(title).sendAdvancement(player));
            }
        }
    }
}

